/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.aerztekasse.core.internal;

import at.medevit.elexis.aerztekasse.core.IAerztekasseService;
import at.medevit.elexis.aerztekasse.core.internal.AerztkasseSettings;
import ch.elexis.TarmedRechnung.XMLFileUtil;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.IMandator;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.InvoiceState;
import ch.elexis.core.services.INamedQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.rgw.tools.Result;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Component
public class AerztekasseService
implements IAerztekasseService {
    private AerztkasseSettings settings;
    private Optional<String> currentToken;
    private long currentTokenTimestamp;

    @Activate
    public void activate() {
        this.settings = new AerztkasseSettings();
    }

    @Override
    public List<File> getXmlFiles(File sendDirectory) {
        if (sendDirectory.exists() && sendDirectory.isDirectory() && sendDirectory.canRead()) {
            File[] xmlFiles = sendDirectory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().toLowerCase().endsWith("xml");
                }
            });
            return new ArrayList<File>(Arrays.asList(xmlFiles));
        }
        return Collections.emptyList();
    }

    @Override
    public Result<Object> sendFiles(File sendDirectory) {
        Result ret = new Result();
        this.validDirectories((Result<Object>)ret);
        if (!ret.isOK()) {
            return ret;
        }
        if (sendDirectory.exists() && sendDirectory.isDirectory() && sendDirectory.canRead()) {
            List<File> xmlFiles = this.getXmlFiles(sendDirectory);
            for (File file : xmlFiles) {
                Result<Object> fileResult = this.sendFile(file);
                if (!fileResult.isOK()) {
                    ret.add(fileResult);
                    this.moveToError(file);
                    continue;
                }
                this.moveToArchive(file);
            }
        } else {
            return ret.add(Result.SEVERITY.ERROR, 0, "Send directory [" + sendDirectory.getAbsolutePath() + "] is not valid", null, true);
        }
        return ret;
    }

    @Override
    public void moveToArchive(File file) {
        XMLFileUtil.moveToArchive((File)file, (File)new File(this.settings.getArchiveDirectory()));
    }

    @Override
    public void moveToError(File file) {
        XMLFileUtil.moveToArchive((File)file, (File)new File(this.settings.getErrorDirectory()));
    }

    private void validDirectories(Result<Object> result) {
        if (StringUtils.isBlank((CharSequence)this.settings.getArchiveDirectory()) || !new File(this.settings.getArchiveDirectory()).exists()) {
            result.add(Result.SEVERITY.ERROR, 0, "No archive directory [" + this.settings.getArchiveDirectory() + "] is not valid", null, true);
        }
        if (StringUtils.isBlank((CharSequence)this.settings.getErrorDirectory()) || !new File(this.settings.getErrorDirectory()).exists()) {
            result.add(Result.SEVERITY.ERROR, 0, "No error directory [" + this.settings.getErrorDirectory() + "] is not valid", null, true);
        }
    }

    @Override
    public Result<Object> sendFile(File invoiceFile) {
        Result ret = new Result();
        this.validDirectories((Result<Object>)ret);
        if (!ret.isOK()) {
            return ret;
        }
        try {
            Optional<IInvoice> invoice = this.loadInvoiceForFilename(invoiceFile.getName());
            if (invoice.isPresent()) {
                String account = this.settings.getAccount(invoice.get().getMandator().getBiller());
                if (StringUtils.isEmpty((CharSequence)account)) {
                    ret.add(Result.SEVERITY.ERROR, 0, "No account for mandator [" + invoice.get().getMandator().getLabel() + "]", null, true);
                    return ret;
                }
                CloseableHttpClient httpClient = HttpClients.createDefault();
                HttpPost uploadFile = new HttpPost(this.settings.getXmlImportUrl());
                uploadFile.addHeader("cdm_account_number", (Object)account);
                uploadFile.addHeader("Authorization", (Object)("Bearer " + this.getToken().orElseThrow(() -> new IllegalStateException("Could not get bearer token"))));
                uploadFile.addHeader("Accept-Language", (Object)Locale.getDefault().getLanguage());
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.addBinaryBody("File", (InputStream)new FileInputStream(invoiceFile), ContentType.APPLICATION_OCTET_STREAM, invoiceFile.getName());
                HttpEntity multipart = builder.build();
                uploadFile.setEntity(multipart);
                CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)uploadFile);
                HttpEntity responseEntity = response.getEntity();
                String responseString = IOUtils.toString((InputStream)responseEntity.getContent(), (String)"UTF-8");
                if (response.getCode() >= 200 && response.getCode() < 300) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder xmlbuilder = factory.newDocumentBuilder();
                    Document doc = xmlbuilder.parse(new InputSource(new StringReader(responseString)));
                    XPathFactory xPathfactory = XPathFactory.newInstance();
                    XPath xpath = xPathfactory.newXPath();
                    XPathExpression xPathExpr = xpath.compile("/uploadResponse");
                    NodeList nodes = (NodeList)xPathExpr.evaluate(doc, XPathConstants.NODESET);
                    if (nodes.getLength() == 1) {
                        Element node = (Element)nodes.item(0);
                        String result = node.getAttribute("result");
                        if ("failure".equals(result)) {
                            LoggerFactory.getLogger(this.getClass()).error("Upload failure\n" + responseString);
                            ret.add(Result.SEVERITY.ERROR, 0, "Upload result failure\n\n" + responseString, null, true);
                            this.setInvoiceFailure(invoice.get(), node);
                        } else {
                            this.setInvoiceSuccess(invoice.get());
                        }
                    }
                } else {
                    LoggerFactory.getLogger(this.getClass()).warn("Uploading xml failed [" + response.getCode() + " " + responseString + "]");
                    if (responseString.contains("SameMD5Found")) {
                        ret.add(Result.SEVERITY.ERROR, 0, "Die Rechnung " + invoice.get().getNumber() + " wurde bereits \u00fcbermittelt.", null, true);
                    } else {
                        ret.add(Result.SEVERITY.ERROR, 0, "Upload result failure\n\n" + responseString, null, true);
                    }
                }
            } else {
                ret.add(Result.SEVERITY.ERROR, 0, "No invoice found for file [" + invoiceFile.getName() + "]", null, true);
            }
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error uploading xml", (Throwable)e);
        }
        return ret;
    }

    private void setInvoiceSuccess(IInvoice invoice) {
        invoice.setState(InvoiceState.PAID);
        CoreModelServiceHolder.get().save((Identifiable)invoice);
    }

    private void setInvoiceFailure(IInvoice invoice, Element node) {
        StringBuilder sb = new StringBuilder();
        NodeList invoiceElements = node.getElementsByTagName("invoice");
        if (invoiceElements.getLength() == 1) {
            Element invoiceelement = (Element)invoiceElements.item(0);
            sb.append(invoiceelement.getAttribute("filename")).append(" - ");
            NodeList errorElements = invoiceelement.getElementsByTagName("error");
            if (errorElements.getLength() == 1) {
                Element errorelement = (Element)errorElements.item(0);
                sb.append(errorelement.getAttribute("message")).append(" [").append(errorelement.getAttribute("code")).append("]");
            }
        } else {
            NodeList generalerrorelements = node.getElementsByTagName("generalError");
            if (generalerrorelements.getLength() == 1) {
                Element generalerrorelement = (Element)generalerrorelements.item(0);
                sb.append(generalerrorelement.getAttribute("message")).append(" [").append(generalerrorelement.getAttribute("code")).append("]");
            }
        }
        invoice.reject(InvoiceState.REJECTCODE.REJECTED_BY_PEER, sb.toString());
        CoreModelServiceHolder.get().save((Identifiable)invoice);
    }

    private Optional<String> getToken() {
        Optional<String> newToken;
        if (this.currentToken != null && !this.currentToken.isEmpty() && System.currentTimeMillis() - this.currentTokenTimestamp > 28800000L) {
            this.currentToken = null;
            this.currentTokenTimestamp = 0L;
        }
        if ((this.currentToken == null || this.currentToken.isEmpty()) && (newToken = this.getAccessToken(this.settings.getUsername(), this.settings.getPassword(), this.settings.getTokenUrl())).isPresent()) {
            this.currentToken = newToken;
            this.currentTokenTimestamp = System.currentTimeMillis();
        }
        if (this.currentToken != null && !this.currentToken.isEmpty()) {
            return this.currentToken;
        }
        return Optional.empty();
    }

    private Optional<String> getAccessToken(String username, String password, String tokenUrl) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("grant_type", "password");
        parameters.put("username", StringUtils.defaultString((String)username));
        parameters.put("password", StringUtils.defaultString((String)password));
        parameters.put("client_id", this.getClientId());
        parameters.put("client_secret", this.getClientSecret());
        String form = parameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(tokenUrl)).headers("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(form)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() >= 200 && response.statusCode() < 300) {
                Gson gson = new Gson();
                Map map = (Map)gson.fromJson(response.body().toString(), Map.class);
                String token = (String)map.get("access_token");
                LoggerFactory.getLogger(this.getClass()).info("Got access token");
                return Optional.of(token);
            }
            LoggerFactory.getLogger(this.getClass()).error("Getting access token failed [" + response.statusCode() + " " + response.body().toString() + "]");
        }
        catch (IOException | InterruptedException e2) {
            LoggerFactory.getLogger(this.getClass()).error("Error getting access token", (Throwable)e2);
        }
        return Optional.empty();
    }

    private String getClientId() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream properties = this.getClass().getResourceAsStream("/rsc/id.properties");){
                if (properties != null) {
                    Properties idProps = new Properties();
                    idProps.load(properties);
                    if (this.settings.isPreprod()) {
                        return idProps.getProperty("preprod_client_id");
                    }
                    return idProps.getProperty("client_id");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading id properties", (Throwable)e);
        }
        return "";
    }

    private String getClientSecret() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream properties = this.getClass().getResourceAsStream("/rsc/id.properties");){
                if (properties != null) {
                    Properties idProps = new Properties();
                    idProps.load(properties);
                    if (this.settings.isPreprod()) {
                        return idProps.getProperty("preprod_client_secret");
                    }
                    return idProps.getProperty("client_secret");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Error loading id properties", (Throwable)e);
        }
        return "";
    }

    @Override
    public boolean hasClientId() {
        return StringUtils.isNotBlank((CharSequence)this.getClientId());
    }

    @Override
    public boolean hasCredentials() {
        return StringUtils.isNotBlank((CharSequence)this.settings.getUsername()) && StringUtils.isNotBlank((CharSequence)this.settings.getPassword());
    }

    @Override
    public void setGlobalArchiveDir(String archiveDir) {
        this.settings.setArchiveDirectory(archiveDir);
    }

    @Override
    public Optional<String> getGlobalArchiveDir() {
        return Optional.ofNullable(this.settings.getArchiveDirectory());
    }

    @Override
    public void setGlobalErrorDir(String errorDir) {
        this.settings.setErrorDirectory(errorDir);
    }

    @Override
    public void setAccount(IMandator mandator, String account) {
        this.settings.setAccount((IContact)mandator, account);
    }

    @Override
    public Optional<String> getAccount(IMandator mandator) {
        if (StringUtils.isNotBlank((CharSequence)this.settings.getAccount((IContact)mandator))) {
            return Optional.of(this.settings.getAccount((IContact)mandator));
        }
        return Optional.empty();
    }

    public Optional<IInvoice> loadInvoiceForFilename(String filename) {
        String invNr = filename.replace(".xml", "");
        invNr = invNr.replace("_m1", "");
        invNr = invNr.replace("_m2", "");
        invNr = invNr.replace("_m3", "");
        invNr = invNr.replace("_storno", "");
        invNr = invNr.replaceAll(".*_", "");
        INamedQuery query = CoreModelServiceHolder.get().getNamedQuery(IInvoice.class, new String[]{"number"});
        List found = query.executeWithParameters(query.getParameterMap(new Object[]{"number", invNr}));
        if (!found.isEmpty()) {
            return Optional.of((IInvoice)found.get(0));
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getUsername() {
        if (StringUtils.isNotBlank((CharSequence)this.settings.getUsername())) {
            return Optional.of(this.settings.getUsername());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getPassword() {
        if (StringUtils.isNotBlank((CharSequence)this.settings.getPassword())) {
            return Optional.of(this.settings.getPassword());
        }
        return Optional.empty();
    }
}

