/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.elexis.aerztekasse.core.internal;

import ch.elexis.core.model.IContact;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.utils.CoreUtil;

public class AerztkasseSettings {
    private static String preProdTokenUrl = "https://idp.preprod.cdm.ch/f5-oauth2/v1/token";
    private static String preProdXmlImportUrl = "https://api.preprod.cdm.ch/ext/isi/api/v1/xml_import/xml";
    private static String prodTokenUrl = "https://idp.cdm.ch/f5-oauth2/v1/token";
    private static String prodXmlImportUrl = "https://api.cdm.ch/ext/isi/api/v1/xml_import/xml";

    public void setUsername(String username) {
        ConfigServiceHolder.get().set("net/medshare/connector/finance/aerztekasse/username", username);
    }

    public String getUsername() {
        return ConfigServiceHolder.get().get("net/medshare/connector/finance/aerztekasse/username", null);
    }

    public void setPassword(String password) {
        ConfigServiceHolder.get().set("net/medshare/connector/finance/aerztekasse/password", password);
    }

    public String getPassword() {
        return ConfigServiceHolder.get().get("net/medshare/connector/finance/aerztekasse/password", null);
    }

    public String getTokenUrl() {
        return this.isPreprod() ? preProdTokenUrl : prodTokenUrl;
    }

    public boolean isPreprod() {
        boolean snapshotMode;
        if (CoreUtil.isTestMode()) {
            return true;
        }
        boolean bl = snapshotMode = System.getProperty("aerztekasseSnapshotMode") != null;
        if (snapshotMode) {
            return ConfigServiceHolder.get().get("net/medshare/connector/finance/aerztekasse/deploymentlevel", "PREPROD").equals("PREPROD");
        }
        return false;
    }

    public void setArchiveDirectory(String archiveDirectory) {
        ConfigServiceHolder.get().set("net/medshare/connector/finance/aerztekasse/archivedir", archiveDirectory);
    }

    public String getArchiveDirectory() {
        return ConfigServiceHolder.get().get("net/medshare/connector/finance/aerztekasse/archivedir", null);
    }

    public void setErrorDirectory(String archiveDirectory) {
        ConfigServiceHolder.get().set("net/medshare/connector/finance/aerztekasse/errordir", archiveDirectory);
    }

    public String getErrorDirectory() {
        return ConfigServiceHolder.get().get("net/medshare/connector/finance/aerztekasse/errordir", null);
    }

    public void setAccount(IContact biller, String account) {
        ConfigServiceHolder.get().set("net/medshare/connector/finance/aerztekasse/account/" + biller.getId(), account);
    }

    public String getAccount(IContact biller) {
        return ConfigServiceHolder.get().get("net/medshare/connector/finance/aerztekasse/account/" + biller.getId(), null);
    }

    public String getXmlImportUrl() {
        return this.isPreprod() ? preProdXmlImportUrl : prodXmlImportUrl;
    }
}

