/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.model.importer;

import ch.elexis.core.services.IElexisEntityManager;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.Map;

public class EntityUtil {
    private IElexisEntityManager entityManager;

    public EntityUtil(IElexisEntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void save(List<Object> saveObject) {
        try (EntityManager em = (EntityManager)this.entityManager.getEntityManager();){
            em.getTransaction().begin();
            for (Object object : saveObject) {
                em.merge(object);
            }
            em.getTransaction().commit();
        }
    }

    public <T> T load(String id, Class<T> clazz) {
        try (EntityManager em = (EntityManager)this.entityManager.getEntityManager();){
            Object object = em.find(clazz, (Object)id);
            return (T)object;
        }
    }

    public <T> List<T> loadAll(Class<T> clazz) {
        try (EntityManager em = (EntityManager)this.entityManager.getEntityManager();){
            CriteriaQuery criteria = em.getCriteriaBuilder().createQuery(clazz);
            criteria.select((Selection)criteria.from(clazz));
            List list = em.createQuery(criteria).getResultList();
            return list;
        }
    }

    public <T> List<T> loadByNamedQuery(Map<String, String> propertyMap, Class<T> clazz) {
        try (EntityManager em = (EntityManager)this.entityManager.getEntityManager();){
            StringBuilder queryName = new StringBuilder();
            queryName.append(clazz.getSimpleName());
            for (String property : propertyMap.keySet()) {
                queryName.append(".").append(property);
            }
            TypedQuery namedQuery = em.createNamedQuery(queryName.toString(), clazz);
            for (String property : propertyMap.keySet()) {
                namedQuery.setParameter(property, (Object)propertyMap.get(property));
            }
            List list = namedQuery.getResultList();
            return list;
        }
    }

    public int executeUpdate(String string) {
        try (EntityManager em = (EntityManager)this.entityManager.getEntityManager();){
            em.getTransaction().begin();
            Query query = em.createQuery(string);
            int ret = query.executeUpdate();
            em.getTransaction().commit();
            int n = ret;
            return n;
        }
    }
}

