/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.model.common.preference;

import at.medevit.ch.artikelstamm.marge.Marge;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.rgw.tools.Money;

public class MargePreference {
    private static Marge[] marges = null;

    public static Marge[] getMarges() {
        if (marges == null) {
            MargePreference.initMarges();
        }
        return marges;
    }

    public static void storeMargeConfiguration() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < marges.length) {
            Marge m = marges[i];
            sb.append(m.getStartInterval() + "/" + m.getEndInterval() + "/" + m.getAddition());
            if (i != marges.length) {
                sb.append("$");
            }
            ++i;
        }
        ConfigServiceHolder.get().set("artikelstamm/csvMargeStorage", sb.toString());
    }

    private static void initMarges() {
        String margeStorageString = ConfigServiceHolder.get().get("artikelstamm/csvMargeStorage", "0/0/0$0/0/0$0/0/0");
        String[] margeStorageEntry = margeStorageString.split("\\$");
        marges = new Marge[margeStorageEntry.length];
        int i = 0;
        while (i < margeStorageEntry.length) {
            String entry = margeStorageEntry[i];
            String[] values = entry.split("/");
            if (values.length == 3) {
                MargePreference.marges[i] = new Marge();
                marges[i].setStartInterval(Double.parseDouble(values[0] == null ? "0.0" : values[0]));
                marges[i].setEndInterval(Double.parseDouble(values[1] == null ? "0.0" : values[1]));
                marges[i].setAddition(Double.parseDouble(values[2] == null ? "0.0" : values[2]));
            }
            ++i;
        }
    }

    public static Money calculateVKP(Money ekPreis) {
        double amount = ekPreis.getAmount();
        int i = 0;
        while (i < MargePreference.getMarges().length) {
            Marge m = MargePreference.getMarges()[i];
            if (m.isValid() && m.startInterval <= amount && m.endInterval >= amount) {
                double mult = 1.0 + m.addition / 100.0;
                return new Money(amount * mult);
            }
            ++i;
        }
        return new Money();
    }
}

