/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.model;

import at.medevit.ch.artikelstamm.ArtikelstammConstants;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.model.common.preference.MargePreference;
import at.medevit.ch.artikelstamm.model.service.ArtikelstammModelServiceHolder;
import at.medevit.ch.artikelstamm.model.service.CoreModelServiceHolder;
import ch.elexis.core.jdt.NonNull;
import ch.elexis.core.jpa.entities.EntityWithId;
import ch.elexis.core.jpa.model.adapter.AbstractIdDeleteModelAdapter;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IBillableOptifier;
import ch.elexis.core.model.IBillableVerifier;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IBillingSystemFactor;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IXid;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.billable.AbstractNoObligationOptifier;
import ch.elexis.core.model.billable.DefaultVerifier;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.XidServiceHolder;
import ch.elexis.core.types.ArticleSubTyp;
import ch.elexis.core.types.ArticleTyp;
import ch.elexis.core.types.VatInfo;
import ch.rgw.tools.Money;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class ArtikelstammItem
extends AbstractIdDeleteModelAdapter<ch.elexis.core.jpa.entities.ArtikelstammItem>
implements Identifiable,
IArtikelstammItem {
    private static final String EXTINFO_VAL_VAT_OVERRIDEN = "VAT_OVERRIDE";
    private static final String EXTINFO_VAL_PPUB_OVERRIDE_STORE = "PPUB_OVERRIDE_STORE";
    private static final String EXTINFO_VAL_PKG_SIZE_OVERRIDE_STORE = "PKG_SIZE_OVERRIDE_STORE";
    private static IBillableOptifier<ArtikelstammItem> optifier;
    private IBillableVerifier verifier = new DefaultVerifier();

    public ArtikelstammItem(ch.elexis.core.jpa.entities.ArtikelstammItem entity) {
        super((EntityWithId)entity);
    }

    public synchronized IBillableOptifier<ArtikelstammItem> getOptifier() {
        if (optifier == null) {
            optifier = new AbstractNoObligationOptifier<ArtikelstammItem>(CoreModelServiceHolder.get(), ConfigServiceHolder.get(), ContextServiceHolder.get()){

                protected void setPrice(ArtikelstammItem billable, IBilled billed) {
                    billed.setFactor(1.0);
                    billed.setNetPrice(billable.getPurchasePrice());
                    Money sellingPrice = billable.getSellingPrice();
                    if (sellingPrice.isZero()) {
                        sellingPrice = MargePreference.calculateVKP(ArtikelstammItem.this.getPurchasePrice());
                    }
                    int vkPreis = sellingPrice.getCents();
                    double pkgSize = Math.abs(billable.getPackageSize());
                    double vkUnits = billable.getSellingSize();
                    if (pkgSize > 0.0 && vkUnits > 0.0 && pkgSize != vkUnits) {
                        billed.setPoints((int)Math.round(vkUnits * ((double)vkPreis / pkgSize)));
                    } else {
                        billed.setPoints(Math.round(vkPreis));
                    }
                }

                protected boolean isNoObligation(ArtikelstammItem billable) {
                    return !billable.isInSLList();
                }

                public Optional<IBillingSystemFactor> getFactor(IEncounter encounter) {
                    return Optional.empty();
                }
            };
        }
        return optifier;
    }

    public IBillableVerifier getVerifier() {
        return this.verifier;
    }

    public String getCodeSystemName() {
        return "Artikelstamm";
    }

    public String getCode() {
        String gtin = this.getGtin();
        if (gtin != null && gtin.length() > 3) {
            return gtin;
        }
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getPhar();
    }

    public String getText() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getDscr();
    }

    public void setText(String value) {
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setDscr(value);
    }

    public Object getExtInfo(Object key) {
        return this.extInfoHandler.getExtInfo(key);
    }

    public void setExtInfo(Object key, Object value) {
        this.extInfoHandler.setExtInfo(key, value);
    }

    public Map<Object, Object> getMap() {
        return this.extInfoHandler.getMap();
    }

    public String getGtin() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getGTIN();
    }

    public void setGtin(String value) {
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setGtin(value);
    }

    @NonNull
    public String getAtcCode() {
        return StringUtils.defaultString((String)((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getAtc());
    }

    public void setAtcCode(String value) {
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setAtc(value);
    }

    public int getSellingSize() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getVerkaufseinheit();
    }

    public void setSellingSize(int value) {
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntityMarkDirty()).setVerkaufseinheit(value);
    }

    public int getPackageSize() {
        return Math.abs(((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getPkg_size());
    }

    public void setPackageSize(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must not be lower than 0");
        }
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setPkg_size(value);
    }

    public String getPackageUnit() {
        return null;
    }

    public void setPackageUnit(String value) {
    }

    public String getProductId() {
        if (this.isProduct()) {
            return this.getId();
        }
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getProdno();
    }

    public IArticle getProduct() {
        String prodno = ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getProdno();
        if (prodno != null) {
            return ArtikelstammModelServiceHolder.get().load(prodno, IArtikelstammItem.class).orElse(null);
        }
        return null;
    }

    public void setProduct(IArticle value) {
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setProdno(value != null ? value.getId() : null);
    }

    public Money getPurchasePrice() {
        String priceString = ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getPexf();
        if (StringUtils.isNotBlank((CharSequence)priceString)) {
            try {
                return new Money(priceString);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Money();
    }

    public void setPurchasePrice(Money value) {
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setPexf(value != null ? Double.toString(value.doubleValue()) : null);
    }

    public Money getSellingPrice() {
        String priceString = ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getPpub();
        if (StringUtils.isNotBlank((CharSequence)priceString)) {
            try {
                Money value = new Money(priceString);
                return this.isUserDefinedPrice() ? value.negate() : value;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return new Money();
    }

    public void setSellingPrice(Money value) {
        if (value != null && this.isUserDefinedPrice() && !value.isNegative()) {
            value.negate();
        }
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntityMarkDirty()).setPpub(value != null ? Double.toString(value.doubleValue()) : null);
    }

    public boolean isObligation() {
        return this.isInSLList();
    }

    public void setObligation(boolean value) {
    }

    public ArticleTyp getTyp() {
        return ArticleTyp.ARTIKELSTAMM;
    }

    public void setTyp(ArticleTyp value) {
    }

    public ArticleSubTyp getSubTyp() {
        String type = ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getType();
        if (type != null) {
            if (ArtikelstammConstants.TYPE.P.name().equals(type)) {
                return ArticleSubTyp.PHARMA;
            }
            if (ArtikelstammConstants.TYPE.N.name().equals(type)) {
                return ArticleSubTyp.NONPHARMA;
            }
        }
        return ArticleSubTyp.UNKNOWN;
    }

    public void setSubTyp(ArticleSubTyp value) {
        if (value != null) {
            if (ArticleSubTyp.PHARMA.equals((Object)value)) {
                ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setType(ArtikelstammConstants.TYPE.P.name());
            } else if (ArticleSubTyp.NONPHARMA.equals((Object)value)) {
                ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setType(ArtikelstammConstants.TYPE.N.name());
            }
        }
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setType(null);
    }

    public boolean isProduct() {
        return ArtikelstammConstants.TYPE.X.name().equalsIgnoreCase(((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getType());
    }

    public List<IArticle> getPackages() {
        IQuery query = ArtikelstammModelServiceHolder.get().getQuery(IArtikelstammItem.class);
        query.and("prodno", IQuery.COMPARATOR.EQUALS, (Object)this.getId());
        query.and("type", IQuery.COMPARATOR.NOT_EQUALS, (Object)"X");
        return query.execute();
    }

    public void setCode(String code) {
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setPhar(code);
    }

    public String getPHAR() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getPhar();
    }

    public ArtikelstammConstants.TYPE getType() {
        return ArtikelstammConstants.TYPE.valueOf((String)((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getType());
    }

    public String getManufacturerLabel() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getComp_name();
    }

    public boolean isInSLList() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).isSl_entry() || ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).isK70_entry();
    }

    public void setInK70(boolean value) {
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntityMarkDirty()).setK70_entry(value);
    }

    public boolean isInK70() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).isK70_entry();
    }

    public String getSwissmedicCategory() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getIkscat();
    }

    public String getGenericType() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getGeneric_type();
    }

    public Integer getDeductible() {
        try {
            return Integer.valueOf(((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getDeductible());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public boolean isNarcotic() {
        return "1".equals(((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getNarcotic_cas());
    }

    public boolean isInLPPV() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).isLppv();
    }

    public boolean isLimited() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).isLimitation();
    }

    public String getLimitationPoints() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getLimitation_pts();
    }

    public String getLimitationText() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getLimitation_txt();
    }

    public boolean isCalculatedPrice() {
        String value = ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getPpub();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return false;
        }
        String exfValue = ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getPexf();
        return exfValue != null && !exfValue.isEmpty();
    }

    public void restoreOriginalSellingPrice() {
        String overridenPrice;
        if (this.isUserDefinedPrice() && (overridenPrice = (String)this.getExtInfo(EXTINFO_VAL_PPUB_OVERRIDE_STORE)) != null) {
            this.setUserDefinedPrice(false);
        }
    }

    public boolean isUserDefinedPrice() {
        String ppub = ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getPpub();
        if (StringUtils.isNotBlank((CharSequence)ppub)) {
            return ppub.startsWith("-");
        }
        return false;
    }

    public void setUserDefinedPrice(boolean activate) {
        if (activate) {
            String ppub = StringUtils.defaultString((String)((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getPpub(), (String)"0");
            this.setExtInfo(EXTINFO_VAL_PPUB_OVERRIDE_STORE, ppub);
            double value = 0.0;
            try {
                value = Double.valueOf(ppub);
            }
            catch (NumberFormatException nfe) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error #setUserDefinedPrice [{}] value is [{}], setting 0", (Object)this.getId(), (Object)ppub);
            }
            this.setUserDefinedPriceValue(new Money(value));
        } else {
            String ppubStored = (String)this.getExtInfo(EXTINFO_VAL_PPUB_OVERRIDE_STORE);
            ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntityMarkDirty()).setPpub(ppubStored);
            this.setExtInfo(EXTINFO_VAL_PPUB_OVERRIDE_STORE, null);
        }
    }

    public String getName() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getDscr();
    }

    public void setName(String value) {
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setDscr(value);
    }

    public void setUserDefinedPriceValue(Money value) {
        String originalPpub = (String)this.getExtInfo(EXTINFO_VAL_PPUB_OVERRIDE_STORE);
        if (originalPpub == null) {
            this.setExtInfo(EXTINFO_VAL_PPUB_OVERRIDE_STORE, this.getSellingPrice() != null ? Double.toString(this.getSellingPrice().doubleValue()) : "");
        }
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setPpub(value != null ? "-" + Double.toString(value.doubleValue()) : null);
    }

    public String getAdditionalDescription() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getAdddscr();
    }

    public void setAdditionalDescription(String value) {
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setAdddscr(value);
    }

    public boolean isBlackBoxed() {
        return !"0".equals(((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getBb());
    }

    public VatInfo getVatInfo() {
        if (this.isOverrideVatInfo()) {
            return VatInfo.valueOf((String)((String)this.extInfoHandler.getExtInfo((Object)EXTINFO_VAL_VAT_OVERRIDEN)));
        }
        return this.getOriginalVatInfo();
    }

    private VatInfo getOriginalVatInfo() {
        switch (this.getType()) {
            case P: {
                return VatInfo.VAT_CH_ISMEDICAMENT;
            }
            case N: {
                return VatInfo.VAT_CH_NOTMEDICAMENT;
            }
        }
        return VatInfo.VAT_NONE;
    }

    public void overrideVatInfo(VatInfo vatInfo) {
        VatInfo originalVatInfo = this.getOriginalVatInfo();
        if (vatInfo == originalVatInfo) {
            this.extInfoHandler.setExtInfo((Object)EXTINFO_VAL_VAT_OVERRIDEN, null);
        } else {
            this.extInfoHandler.setExtInfo((Object)EXTINFO_VAL_VAT_OVERRIDEN, (Object)vatInfo.toString());
        }
    }

    public boolean isOverrideVatInfo() {
        Object value = this.extInfoHandler.getExtInfo((Object)EXTINFO_VAL_VAT_OVERRIDEN);
        return value instanceof String;
    }

    public String getLabel() {
        return this.getAdditionalDescription() != null && this.getAdditionalDescription().length() > 0 ? this.getName() + " (" + this.getAdditionalDescription() + ")" : this.getName();
    }

    public boolean isUserDefinedPkgSize() {
        return ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getPkg_size() < 0;
    }

    public void restoreOriginalPackageSize() {
        String ppubStored;
        if (this.isUserDefinedPkgSize() && (ppubStored = (String)this.getExtInfo(EXTINFO_VAL_PKG_SIZE_OVERRIDE_STORE)) != null && !ppubStored.isEmpty()) {
            this.setPackageSize(Integer.parseInt(ppubStored));
            this.setExtInfo(EXTINFO_VAL_PKG_SIZE_OVERRIDE_STORE, null);
        }
    }

    public int getUserDefinedPkgSize() {
        int oldValue = ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).getPkg_size();
        if (oldValue < 0) {
            return oldValue * -1;
        }
        return ch.elexis.core.jpa.entities.ArtikelstammItem.IS_USER_DEFINED_PKG_SIZE;
    }

    public void setUserDefinedPkgSizeValue(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must not be lower than 0");
        }
        int pkgSize = this.getPackageSize();
        this.setExtInfo(EXTINFO_VAL_PKG_SIZE_OVERRIDE_STORE, Integer.toString(pkgSize));
        ((ch.elexis.core.jpa.entities.ArtikelstammItem)this.getEntity()).setPkg_size(value * -1);
    }

    public boolean addXid(String domain, String id, boolean updateIfExists) {
        return XidServiceHolder.get().addXid((Identifiable)this, domain, id, updateIfExists);
    }

    public IXid getXid(String domain) {
        return XidServiceHolder.get().getXid((Identifiable)this, domain);
    }

    public boolean isVaccination() {
        String atcCode = this.getAtcCode();
        return atcCode != null && atcCode.toUpperCase().startsWith("J07") && !atcCode.toUpperCase().startsWith("J07AX");
    }

    public String getCodeSystemCode() {
        String gtin = this.getGtin();
        if (gtin != null && gtin.length() > 3) {
            if (this.getType() == ArtikelstammConstants.TYPE.P || this.isInSLList()) {
                return "402";
            }
            if (this.getType() == ArtikelstammConstants.TYPE.N) {
                return "406";
            }
        }
        return "999";
    }

    public String getPackageSizeString() {
        return "";
    }

    public void setPackageSizeString(String value) {
        throw new UnsupportedOperationException();
    }
}

