/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.ui.cv;

import at.medevit.atc_codes.ATCCode;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.elexis.common.service.ModelServiceHolder;
import at.medevit.ch.artikelstamm.elexis.common.ui.ArtikelstammDetailDialog;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.ATCFilterInfoListElement;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.ATCMenuContributionItem;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.ArtikelstammCommonViewerContentProvider;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.AtcQueryFilter;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.BlackboxViewerFilterAction;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.MephaPrefferedProviderSorterAction;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.SupportedATCFilteringAction;
import at.medevit.ch.artikelstamm.elexis.common.ui.cv.VATMenuContributionItem;
import at.medevit.ch.artikelstamm.elexis.common.ui.provider.ATCArtikelstammDecoratingLabelProvider;
import at.medevit.ch.artikelstamm.elexis.common.ui.provider.LagerhaltungArtikelstammLabelProvider;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.actions.ToggleVerrechenbarFavoriteAction;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.selectors.ActiveControl;
import ch.elexis.core.ui.selectors.FieldDescriptor;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.SelectorPanelProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.core.ui.views.KonsDetailView;
import ch.elexis.core.ui.views.artikel.Messages;
import ch.elexis.core.ui.views.codesystems.CodeSelectorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;

public class ArtikelstammCodeSelectorFactory
extends CodeSelectorFactory {
    private SelectorPanelProvider slp;
    private int eventType = 1;
    private ToggleVerrechenbarFavoriteAction tvfa = new ToggleVerrechenbarFavoriteAction();
    private static final String DISP_NAME = "Artikel oder Wirkstoff";
    private ArtikelstammCommonViewerContentProvider commonViewContentProvider;
    private ISelectionChangedListener selChange = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            TableViewer tv = (TableViewer)event.getSource();
            StructuredSelection ss = (StructuredSelection)tv.getSelection();
            ArtikelstammCodeSelectorFactory.this.tvfa.updateSelection(ss.isEmpty() ? null : ss.getFirstElement());
            if (!ss.isEmpty() && ss.getFirstElement() instanceof IArtikelstammItem) {
                IArtikelstammItem selected = (IArtikelstammItem)ss.getFirstElement();
                ContextServiceHolder.get().getRootContext().setNamed("at.medevit.ch.artikelstamm.elexis.common.ui.selection", (Object)selected);
            } else {
                ContextServiceHolder.get().getRootContext().setNamed("at.medevit.ch.artikelstamm.elexis.common.ui.selection", null);
            }
        }
    };

    public ViewerConfigurer createViewerConfigurer(CommonViewer cv) {
        final CommonViewer cov = cv;
        cov.setSelectionChangedListener(this.selChange);
        FieldDescriptor[] fields = new FieldDescriptor[]{new FieldDescriptor(DISP_NAME, "ldscr", FieldDescriptor.Typ.STRING, null).ignoreCase(false).valueToLower(true)};
        Listener keyListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == ArtikelstammCodeSelectorFactory.this.eventType && (event.keyCode == 13 || event.keyCode == 0x1000050)) {
                    ArtikelstammCodeSelectorFactory.this.slp.fireChangedEvent();
                }
            }
        };
        FieldDescriptor[] fieldDescriptorArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDescriptor fd = fieldDescriptorArray[n2];
            fd.setAssignedListener(this.eventType, keyListener);
            ++n2;
        }
        this.slp = new SelectorPanelProvider(fields, true);
        this.slp.setChangeDelay(750);
        this.slp.addChangeListener((ViewerConfigurer.ControlFieldListener)new AControlFieldListener(this.slp));
        this.commonViewContentProvider = new ArtikelstammCommonViewerContentProvider(cv, (ViewerConfigurer.ControlFieldProvider)this.slp);
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        this.populateSelectorPanel(this.slp, this.commonViewContentProvider, actionList);
        this.slp.addActions(actionList.toArray(new IAction[actionList.size()]));
        SimpleWidgetProvider swp = new SimpleWidgetProvider(3, 0, null);
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        String atcLang = ConfigServiceHolder.get().get("artikelstamm/atcCodeLanguage", "ger");
        ATCArtikelstammDecoratingLabelProvider adlp = new ATCArtikelstammDecoratingLabelProvider((ILabelProvider)new LagerhaltungArtikelstammLabelProvider(), decorator, atcLang);
        ViewerConfigurer vc = new ViewerConfigurer((ViewerConfigurer.ICommonViewerContentProvider)this.commonViewContentProvider, (LabelProvider)adlp, (ViewerConfigurer.ControlFieldProvider)this.slp, (ViewerConfigurer.ButtonProvider)new ViewerConfigurer.DefaultButtonProvider(), (ViewerConfigurer.WidgetProvider)swp);
        MenuManager menu = new MenuManager();
        menu.add((IAction)new Action(Messages.ArtikelContextMenu_propertiesAction){
            {
                super($anonymous0);
                this.setImageDescriptor(Images.IMG_EDIT.getImageDescriptor());
                this.setToolTipText(Messages.ArtikelContextMenu_propertiesTooltip);
            }

            public void run() {
                StructuredSelection structuredSelection = new StructuredSelection(cov.getSelection());
                Object element = structuredSelection.getFirstElement();
                ArtikelstammDetailDialog dd = new ArtikelstammDetailDialog(UiDesk.getTopShell(), (IArtikelstammItem)element);
                dd.open();
            }
        });
        MenuManager subMenu = new MenuManager("ATC Gruppen-Selektion", Images.IMG_CATEGORY_GROUP.getImageDescriptor(), null){

            public boolean isDynamic() {
                return true;
            }

            public boolean isVisible() {
                StructuredSelection structuredSelection = new StructuredSelection(cov.getSelection());
                Object element = structuredSelection.getFirstElement();
                if (element instanceof IArtikelstammItem) {
                    IArtikelstammItem ai = (IArtikelstammItem)element;
                    return ai.getAtcCode() != null && ai.getAtcCode().length() > 0;
                }
                return false;
            }
        };
        subMenu.add((IContributionItem)new ATCMenuContributionItem(cov, (CommonViewerContentProvider)this.commonViewContentProvider));
        menu.add((IContributionItem)subMenu);
        menu.add((IAction)this.tvfa);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new VATMenuContributionItem(cov));
        cv.setContextMenu(menu);
        vc.setContentType(ViewerConfigurer.ContentType.GENERICOBJECT);
        return vc;
    }

    public IDoubleClickListener getDoubleClickListener() {
        return new ArtikelstammDoubleClickListener();
    }

    public Class<?> getElementClass() {
        return IArtikelstammItem.class;
    }

    public void dispose() {
    }

    public String getCodeSystemName() {
        return "Artikelstamm";
    }

    public void populateSelectorPanel(SelectorPanelProvider slp, ArtikelstammCommonViewerContentProvider commonViewerContentProvider, List<IAction> actionList) {
        MephaPrefferedProviderSorterAction mppsa = new MephaPrefferedProviderSorterAction((CommonViewerContentProvider)commonViewerContentProvider);
        mppsa.setChecked(ConfigServiceHolder.get().get("artikelstammPreferMepha", false));
        actionList.add((IAction)mppsa);
        actionList.add((IAction)new SupportedATCFilteringAction(commonViewerContentProvider));
        actionList.add((IAction)new BlackboxViewerFilterAction((CommonViewerContentProvider)commonViewerContentProvider, slp));
    }

    private class AControlFieldListener
    implements ViewerConfigurer.ControlFieldListener {
        private SelectorPanelProvider slp;

        public AControlFieldListener(SelectorPanelProvider slp) {
            this.slp = slp;
        }

        public void changed(HashMap<String, String> values) {
            Optional result;
            String val = values.get(ArtikelstammCodeSelectorFactory.DISP_NAME);
            if (val != null && val.length() == 13 && StringUtils.isNumeric((CharSequence)val) && (result = ((ICodeElementServiceContribution)ModelServiceHolder.get()).loadFromCode(val, Collections.emptyMap())).isPresent()) {
                KonsDetailView detailView = this.getKonsDetailView();
                Optional optional = ContextServiceHolder.get().getTyped(IEncounter.class);
            }
        }

        private KonsDetailView getKonsDetailView() {
            IViewReference[] viewReferences;
            IViewReference[] iViewReferenceArray = viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
            int n = viewReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewRef = iViewReferenceArray[n2];
                if ("ch.elexis.Konsdetail".equals(viewRef.getId())) {
                    return (KonsDetailView)viewRef.getPart(false);
                }
                ++n2;
            }
            return null;
        }

        public void reorder(String field) {
        }

        public void selected() {
        }
    }

    private class ArtikelstammDoubleClickListener
    implements IDoubleClickListener {
        private String filterValueStore;

        private ArtikelstammDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            ICodeSelectorTarget target;
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            if (selection.getFirstElement() == null) {
                return;
            }
            if (selection.getFirstElement() instanceof ATCCode) {
                this.filterValueStore = ArtikelstammCodeSelectorFactory.this.slp.getValues()[0];
                ArtikelstammCodeSelectorFactory.this.slp.clearValues();
                ATCCode a = (ATCCode)selection.getFirstElement();
                ArtikelstammCodeSelectorFactory.this.commonViewContentProvider.removeAllQueryFilterByType(AtcQueryFilter.class);
                AtcQueryFilter queryFilter = new AtcQueryFilter();
                queryFilter.setFilterValue(a.atcCode);
                ArtikelstammCodeSelectorFactory.this.commonViewContentProvider.addQueryFilter(queryFilter);
            } else if (selection.getFirstElement() instanceof ATCFilterInfoListElement) {
                ArtikelstammCodeSelectorFactory.this.slp.clearValues();
                ActiveControl ac = (ActiveControl)ArtikelstammCodeSelectorFactory.this.slp.getPanel().getControls().get(0);
                ac.setText(this.filterValueStore != null ? this.filterValueStore : "");
                ArtikelstammCodeSelectorFactory.this.commonViewContentProvider.removeAllQueryFilterByType(AtcQueryFilter.class);
            } else if (selection.getFirstElement() instanceof IArtikelstammItem && (target = CodeSelectorHandler.getInstance().getCodeSelectorTarget()) != null) {
                Object obj = selection.getFirstElement();
                target.codeSelected(obj);
            }
        }
    }
}

