/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.ch.artikelstamm.elexis.common.service;

import at.medevit.ch.artikelstamm.DATASOURCEType;
import at.medevit.ch.artikelstamm.IArtikelstammItem;
import at.medevit.ch.artikelstamm.elexis.common.service.ModelServiceHolder;
import ch.elexis.core.model.Identifiable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;

public class VersionUtil {
    private static DateFormat df = new SimpleDateFormat("ddMMyy HH:mm");
    private static final String VERSION_ENTRY_ID = "VERSION";

    public static DATASOURCEType getDatasourceType() {
        Optional versionEntry = ModelServiceHolder.get().load(VERSION_ENTRY_ID, IArtikelstammItem.class);
        if (versionEntry.isPresent()) {
            return DATASOURCEType.fromValue((String)((IArtikelstammItem)versionEntry.get()).getAdditionalDescription());
        }
        throw new IllegalArgumentException("No Verison entry");
    }

    public static void setDataSourceType(DATASOURCEType datasource) {
        Optional versionEntry = ModelServiceHolder.get().load(VERSION_ENTRY_ID, IArtikelstammItem.class);
        if (versionEntry.isPresent()) {
            ((IArtikelstammItem)versionEntry.get()).setAdditionalDescription(datasource.value());
            ModelServiceHolder.get().save((Identifiable)versionEntry.get());
        }
        throw new IllegalArgumentException("No Verison entry");
    }

    public static int getCurrentVersion() {
        Object ppub;
        Optional versionEntry = ModelServiceHolder.get().load(VERSION_ENTRY_ID, IArtikelstammItem.class);
        if (versionEntry.isPresent() && (ppub = ModelServiceHolder.get().getEntityProperty("ppub", (Identifiable)versionEntry.get())) instanceof String) {
            try {
                return Integer.parseInt(((String)ppub).trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static void setCurrentVersion(int newVersion) {
        Optional versionEntry = ModelServiceHolder.get().load(VERSION_ENTRY_ID, IArtikelstammItem.class);
        if (versionEntry.isPresent()) {
            ModelServiceHolder.get().setEntityProperty("ppub", (Object)Integer.toString(newVersion), (Identifiable)versionEntry.get());
            ModelServiceHolder.get().save((Identifiable)versionEntry.get());
        }
        throw new IllegalArgumentException("No Verison entry");
    }

    public static void setImportSetCreationDate(Date time) {
        Optional versionEntry = ModelServiceHolder.get().load(VERSION_ENTRY_ID, IArtikelstammItem.class);
        if (versionEntry.isPresent()) {
            ModelServiceHolder.get().setEntityProperty("dscr", (Object)df.format(time.getTime()), (Identifiable)versionEntry.get());
            ModelServiceHolder.get().save((Identifiable)versionEntry.get());
        }
        throw new IllegalArgumentException("No Verison entry");
    }

    public static Date getImportSetCreationDate() {
        Optional versionEntry = ModelServiceHolder.get().load(VERSION_ENTRY_ID, IArtikelstammItem.class);
        if (versionEntry.isPresent()) {
            Object value = ModelServiceHolder.get().getEntityProperty("dscr", (Identifiable)versionEntry.get());
            if (value instanceof String) {
                try {
                    return df.parse((String)value);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return null;
        }
        throw new IllegalArgumentException("No Verison entry");
    }
}

