/*
 * Decompiled with CFR 0.152.
 */
package at.medevit.atc_codes;

import at.medevit.atc_codes.ATCCode;
import at.medevit.atc_codes.ATCCodeService;
import at.medevit.atc_codes.internal.ATCCodes;
import ch.elexis.core.jdt.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component
public class ATCCodeServiceImpl
implements ATCCodeService {
    @Override
    public ATCCode getForATCCode(String atcCode) {
        return ATCCodes.getInstance().getATCCode(atcCode);
    }

    @Override
    public List<ATCCode> getHierarchyForATCCode(String atcCode) {
        ArrayList<ATCCode> ret = new ArrayList<ATCCode>();
        ATCCode root = this.getForATCCode(atcCode);
        if (root != null) {
            ret.add(root);
            int currentLevel = root.level - 1;
            while (currentLevel > 0) {
                ATCCode temp = this.fetchLevelForATCCode(root, currentLevel);
                --currentLevel;
                ret.add(temp);
            }
        }
        return ret;
    }

    private ATCCode fetchLevelForATCCode(ATCCode root, int currentLevel) {
        switch (currentLevel) {
            case 4: {
                return this.getForATCCode(root.atcCode.substring(0, 5));
            }
            case 3: {
                return this.getForATCCode(root.atcCode.substring(0, 4));
            }
            case 2: {
                return this.getForATCCode(root.atcCode.substring(0, 3));
            }
            case 1: {
                return this.getForATCCode(root.atcCode.substring(0, 1));
            }
        }
        return null;
    }

    @Override
    public List<ATCCode> getATCCodesMatchingName(String name, int language, int matchType) {
        return ATCCodes.getInstance().getATCCodesMatchingName(name, language, matchType);
    }

    @Override
    public List<ATCCode> getAllATCCodes() {
        return ATCCodes.getInstance().getAllATCCodes();
    }

    @Override
    @Nullable
    public ATCCode getNextInHierarchy(ATCCode code) {
        List<ATCCode> allATCCodes = this.getAllATCCodes();
        boolean fetchNext = false;
        for (ATCCode atcCode : allATCCodes) {
            if (atcCode.level != code.level) continue;
            if (fetchNext) {
                return atcCode;
            }
            fetchNext = atcCode.equals(code);
        }
        return null;
    }
}

