/*
 * Decompiled with CFR 0.152.
 */
package at.gruber.elexis.mythic22.netlistener;

import at.gruber.elexis.mythic22.inputhandler.InputHandler;
import at.gruber.elexis.mythic22.model.Mythic22Result;
import at.gruber.elexis.mythic22.persistency.PersistencyHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetListener
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(NetListener.class);
    private static final String START = "MYTHIC";
    private static final String END = "END_RESULT";
    private int m_serverPort;
    private static boolean m_running = false;
    private Thread m_thread;
    private Socket m_socket;
    private ServerSocket m_serverSocket;

    public NetListener(int serverPort) {
        this.m_serverPort = serverPort;
    }

    public void startContinousRead() {
        if (this.m_thread == null || this.m_thread.getState() == Thread.State.TERMINATED) {
            this.m_thread = new Thread(this);
        }
        this.m_serverSocket = null;
        this.m_socket = null;
        m_running = true;
        this.m_thread.start();
    }

    private String readFromServer() {
        boolean mythicHeaderFound = false;
        boolean mythicEndReached = false;
        StringBuilder strBuilder = new StringBuilder();
        try {
            String temp;
            if (this.m_serverSocket == null || this.m_serverSocket.isClosed()) {
                this.m_serverSocket = new ServerSocket(this.m_serverPort);
                this.m_serverSocket.setSoTimeout(5000);
            }
            this.m_socket = this.m_serverSocket.accept();
            BufferedReader in = new BufferedReader(new InputStreamReader(this.m_socket.getInputStream()));
            while (!mythicEndReached && (temp = in.readLine()) != null) {
                if (temp.startsWith(START)) {
                    mythicHeaderFound = true;
                } else if (temp.startsWith(END)) {
                    mythicEndReached = true;
                }
                if (!mythicHeaderFound) continue;
                strBuilder.append(temp);
                strBuilder.append('\n');
            }
            in.close();
            this.m_socket.close();
            if (mythicHeaderFound && mythicEndReached) {
                return strBuilder.toString();
            }
            return null;
        }
        catch (IOException e) {
            if (e instanceof BindException) {
                this.requestThreadToStop();
            }
            if (e instanceof SocketTimeoutException) {
                return null;
            }
            String message = "Error on creation of server socket on port " + this.m_serverPort;
            Status status = new Status(2, "at.gruber.elexis.mythic22", message, (Throwable)e);
            StatusManager.getManager().handle((IStatus)status, 2);
            logger.error(message, (Throwable)e);
            return null;
        }
    }

    @Override
    public void run() {
        logger.debug("Starting mythic 22 listener");
        while (m_running) {
            String temp = this.readFromServer();
            if (temp == null) continue;
            logger.debug("Got mythic 22 input of length " + temp.length());
            Mythic22Result result = InputHandler.getInstance().processInput(temp);
            if (PersistencyHandler.getInstance().persistMythicResult(result)) continue;
            String message = "Error persisting data!";
            Status status = new Status(2, "at.gruber.elexis.mythic22", message);
            StatusManager.getManager().handle((IStatus)status, 2);
        }
        logger.debug("Stopping mythic 22 listener");
        try {
            if (this.m_serverSocket != null) {
                this.m_serverSocket.close();
                this.m_serverSocket = null;
            }
        }
        catch (IOException e) {
            String message = "Error closing server socket on " + this.m_serverSocket.getLocalPort();
            logger.warn(message, (Throwable)e);
        }
    }

    public void requestThreadToStop() {
        m_running = false;
    }

    public int getServerPort() {
        return this.m_serverPort;
    }

    public static boolean isRunning() {
        return m_running;
    }
}

