/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.function.primitive;

import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.tuple.Tuples;

public class BooleanCaseFunction<V>
implements BooleanToObjectFunction<V> {
    private static final long serialVersionUID = 1L;
    private final MutableList<Pair<BooleanPredicate, BooleanToObjectFunction<? extends V>>> predicateFunctions = Lists.mutable.empty();
    private BooleanToObjectFunction<? extends V> defaultFunction;

    public BooleanCaseFunction() {
    }

    public BooleanCaseFunction(BooleanToObjectFunction<? extends V> newDefaultFunction) {
        this.setDefault(newDefaultFunction);
    }

    public BooleanCaseFunction<V> addCase(BooleanPredicate predicate, BooleanToObjectFunction<? extends V> function) {
        this.predicateFunctions.add(Tuples.pair(predicate, function));
        return this;
    }

    public BooleanCaseFunction<V> setDefault(BooleanToObjectFunction<? extends V> function) {
        this.defaultFunction = function;
        return this;
    }

    @Override
    public V valueOf(boolean argument) {
        int localSize = this.predicateFunctions.size();
        for (int i = 0; i < localSize; ++i) {
            Pair pair = (Pair)this.predicateFunctions.get(i);
            if (!((BooleanPredicate)pair.getOne()).accept(argument)) continue;
            return ((BooleanToObjectFunction)pair.getTwo()).valueOf(argument);
        }
        if (this.defaultFunction != null) {
            return this.defaultFunction.valueOf(argument);
        }
        return null;
    }

    public String toString() {
        return "new BooleanCaseFunction(" + this.predicateFunctions + ')';
    }
}

