/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import com.equo.chromium.ChromiumBrowser;
import com.equo.chromium.internal.IndependentBrowser;
import com.equo.chromium.utils.EventAction;
import com.equo.chromium.utils.EventType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefStringVisitor;

public class Subscriber {
    private IndependentBrowser _browser;
    private Map<EventType, List<EventAction>> subscribeEvents = new HashMap<EventType, List<EventAction>>();
    private Map<Long, ActionData> subscribeIndex = new HashMap<Long, ActionData>();
    private long eventId = 0L;
    private boolean firstLoading = true;
    private int _errorCode = 0;
    protected static EventAction eventActionOfAfterCreated = null;

    public Subscriber(IndependentBrowser browser) {
        this._browser = browser;
    }

    public void dispose() {
        this._browser = null;
        this.unSubscribeAll();
    }

    public static void subscribeOnAfterCreated(EventAction eventAction) {
        eventActionOfAfterCreated = eventAction;
    }

    public static EventAction getEventActionOfAfterCreated() {
        return eventActionOfAfterCreated;
    }

    public synchronized long subscribe(EventType eventType, EventAction action) {
        this._browser.isCreated().thenRun(() -> {
            this.subscribeEvents.computeIfAbsent(eventType, m -> new ArrayList()).add(action);
            this.subscribeIndex.put(this.eventId, new ActionData(eventType, action));
        });
        return this.eventId++;
    }

    public synchronized boolean unSubscribe(long idEvent) {
        this._browser.isCreated().thenRun(() -> {
            ActionData actionData = this.subscribeIndex.get(idEvent);
            if (actionData != null) {
                this.subscribeEvents.get((Object)actionData.eventType).remove(actionData.action);
                this.subscribeIndex.remove(idEvent);
            }
        });
        return false;
    }

    public synchronized void unSubscribeAll() {
        this.subscribeIndex.clear();
        this.subscribeEvents.clear();
    }

    protected void notifySubscribers(EventType eventType) {
        this.notifySubscribers(eventType, new HashMap<String, Object>());
    }

    protected synchronized void notifySubscribers(EventType eventType, Map<String, Object> mapData) {
        this.subscribeEvents.computeIfAbsent(eventType, m -> new ArrayList()).forEach(e -> {
            e.setJsonData(mapData);
            CompletableFuture.runAsync(e);
        });
    }

    public void onAfterCreatedNotify(CefBrowser browser) {
        if (eventActionOfAfterCreated != null && !this._browser.isCreated().isDone()) {
            HashMap<String, Object> mapData = new HashMap<String, Object>();
            mapData.put("chromium_instance", (ChromiumBrowser)browser.getReference());
            eventActionOfAfterCreated.setJsonData(mapData);
            eventActionOfAfterCreated.run();
        }
        this._browser.isCreated().complete(true);
        this.notifySubscribers(EventType.onAfterCreated);
    }

    public void onLoadEndNotify(final CefFrame frame) {
        CefFrame parentFrame = frame.getParent();
        final boolean isMain = frame.isMain();
        final String parentId = parentFrame != null ? parentFrame.getIdentifier() : "0";
        frame.getSource(new CefStringVisitor(){

            @Override
            public void visit(String source) {
                String jsonSource = source.replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
                HashMap<String, Object> mapData = new HashMap<String, Object>();
                mapData.put("isMain", isMain);
                mapData.put("html", jsonSource);
                mapData.put("name", frame.getName());
                mapData.put("id", frame.getIdentifier());
                mapData.put("parentId", parentId);
                Subscriber.this.notifySubscribers(EventType.onLoadEnd, mapData);
            }
        });
    }

    public void onLoadingStateChangeNotify(boolean isLoading, String url) {
        if (this.firstLoading || isLoading) {
            this.notifySubscribers(EventType.onLoadingStateChange);
            this.firstLoading = false;
        } else {
            this.firstLoading = true;
        }
    }

    public void onBeforeBrowseNotify() {
        this.notifySubscribers(EventType.onNavigationStart);
    }

    public void onAddressChangeNotify(boolean isLoading, String url) {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        mapData.put("errorCode", this._errorCode);
        this._errorCode = 0;
        this.notifySubscribers(EventType.onNavigationFinished, mapData);
    }

    public void onLoadErrorNotify(int error) {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        mapData.put("errorCode", error);
        this._errorCode = error;
        this.notifySubscribers(EventType.onLoadError, mapData);
    }

    public void onLoadStartNotify() {
        this.notifySubscribers(EventType.onLoadStart);
    }

    public void onFindResultNotify(int count, int activeMatchOrdinal) {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        mapData.put("count", count);
        mapData.put("activeMatchOrdinal", activeMatchOrdinal);
        this.notifySubscribers(EventType.onFindResult, mapData);
    }

    public void onConsoleMessageNotify(CefSettings.LogSeverity level, String message, String source, int line) {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        mapData.put("level", level.toString());
        mapData.put("message", message);
        mapData.put("source", source);
        mapData.put("line", line);
        this.notifySubscribers(EventType.onConsoleMessage, mapData);
    }

    public void onFullscreenModeChangeNotify(boolean fullscreen) {
        this.notifySubscribers(fullscreen ? EventType.onFullScreenEntered : EventType.onFullScreenExited);
    }

    class ActionData {
        public EventType eventType;
        public Runnable action;

        public ActionData(EventType eventType, Runnable action) {
            this.eventType = eventType;
            this.action = action;
        }
    }
}

