/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.cef.OS;

public class ResourceExpander {
    public static final String DEFAULT_EXECUTABLE_NAME = OS.isMacintosh() ? "equochro Helper" : "equochro_helper";
    public static final String CUSTOM_EXECUTABLE_NAME = System.getProperty("chromium.executable.name", DEFAULT_EXECUTABLE_NAME);

    public static void setExecutable(File newFile) {
        String[] executables = new String[]{"", "so"};
        if (Arrays.asList(executables).contains(ResourceExpander.getExtension(newFile.getName())) && !newFile.canExecute()) {
            try {
                newFile.setExecutable(true);
            }
            catch (Throwable e) {
                System.err.println(e.getMessage());
            }
        }
    }

    public static String getExtension(String filename) {
        Optional<String> ext = Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
        return ext.isPresent() ? ext.get() : "";
    }

    public static Path findResource(Path extractTo, String resource, boolean replace) {
        Path path = extractTo.resolve(resource);
        if (Files.exists(path, new LinkOption[0]) && !replace) {
            return path;
        }
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (ResourceExpander.extract(path, resource) && Files.exists(path, new LinkOption[0])) {
                return path;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to extract " + resource + "from jar");
        }
        throw new UnsatisfiedLinkError("Could not find resource " + resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean extract(Path extractToFilePath, String resource) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = ResourceExpander.class.getResourceAsStream("/" + resource);){
            if (is == null) return false;
            Files.copy(is, extractToFilePath, StandardCopyOption.REPLACE_EXISTING);
            ResourceExpander.setExecutable(extractToFilePath.toFile());
            return true;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    static Path extractFromJar(String chromiumPath, String arch, String subdir, URI location) throws IOException {
        block39: {
            Path extractPath = chromiumPath.isEmpty() ? Paths.get(System.getProperty("user.home"), ".equo", "chromium") : Paths.get(chromiumPath, new String[0]);
            extractPath = extractPath.resolve(arch);
            Throwable throwable = null;
            Object var6_7 = null;
            try (JarFile jarFile = new JarFile(new File(location));){
                block41: {
                    JarEntry entry = jarFile.getJarEntry(String.valueOf(subdir) + "/chromium.properties");
                    if (entry == null) break block39;
                    Throwable throwable2 = null;
                    Object var10_13 = null;
                    try (InputStream is = jarFile.getInputStream(entry);){
                        Object object;
                        Properties props = new Properties();
                        props.load(is);
                        String ver = props.getProperty("version");
                        boolean replace = true;
                        Path oldFile = extractPath.resolve(subdir).resolve("chromium.properties");
                        if (Files.exists(oldFile, new LinkOption[0])) {
                            Properties oldProps = new Properties();
                            object = null;
                            Object var18_25 = null;
                            try (BufferedReader oldis = Files.newBufferedReader(oldFile);){
                                oldProps.load(oldis);
                                String oldVer = oldProps.getProperty("version");
                                if (Objects.equals(ver, oldVer)) {
                                    replace = false;
                                }
                            }
                            catch (Throwable throwable3) {
                                if (object == null) {
                                    object = throwable3;
                                } else if (object != throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                                throw object;
                            }
                        }
                        for (String prop : props.stringPropertyNames()) {
                            if (prop.length() != 2) continue;
                            String propValue = props.getProperty(prop);
                            Path path = ResourceExpander.findResource(extractPath, propValue, replace);
                            if (CUSTOM_EXECUTABLE_NAME.equals(DEFAULT_EXECUTABLE_NAME) || !ResourceExpander.isHelperExecutable(path)) continue;
                            ResourceExpander.createExecutableWithCustomName(path);
                        }
                        if (!replace) break block41;
                        Throwable throwable4 = null;
                        object = null;
                        try (InputStream propsIs = jarFile.getInputStream(entry);){
                            Files.copy(propsIs, oldFile, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Throwable throwable5) {
                            if (throwable4 == null) {
                                throwable4 = throwable5;
                            } else if (throwable4 != throwable5) {
                                throwable4.addSuppressed(throwable5);
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                        } else if (throwable2 != throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        throw throwable2;
                    }
                }
                return extractPath;
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        return null;
    }

    public static boolean isHelperExecutable(Path path) {
        String pathString = path.toString();
        if (OS.isMacintosh()) {
            String macPattern = ".*/equochro Helper( \\(.*\\))?\\.app/Contents/MacOS/equochro Helper( \\(.*\\))?";
            return pathString.matches(macPattern);
        }
        if (OS.isLinux()) {
            return DEFAULT_EXECUTABLE_NAME.equals(path.getFileName().toString());
        }
        return (String.valueOf(DEFAULT_EXECUTABLE_NAME) + ".exe").equals(path.getFileName().toString());
    }

    public static Path createExecutableWithCustomName(Path originalFile) {
        String pathString = originalFile.toString();
        int lastIndex = pathString.lastIndexOf(DEFAULT_EXECUTABLE_NAME);
        if (lastIndex != -1) {
            String newPathString = String.valueOf(pathString.substring(0, lastIndex)) + CUSTOM_EXECUTABLE_NAME + pathString.substring(lastIndex + DEFAULT_EXECUTABLE_NAME.length());
            Path newPath = Paths.get(newPathString, new String[0]);
            try {
                if (OS.isMacintosh()) {
                    Files.createSymbolicLink(newPath, originalFile, new FileAttribute[0]);
                } else {
                    Files.move(originalFile, newPath, StandardCopyOption.REPLACE_EXISTING);
                }
                return newPath;
            }
            catch (FileAlreadyExistsException e) {
                return newPath;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return originalFile;
    }
}

