/*
 * Decompiled with CFR 0.152.
 */
package ch.rgw.tools;

import ch.rgw.tools.DatabaseNativeExceptionHandler;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.FuzzyMatcher;
import ch.rgw.tools.IJdbcLink;
import ch.rgw.tools.JdbcLinkException;
import ch.rgw.tools.JdbcLinkExceptionTranslation;
import ch.rgw.tools.JdbcLinkUtil;
import ch.rgw.tools.Log;
import ch.rgw.tools.StringTool;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class JdbcLink
implements IJdbcLink {
    public static final String MYSQL_DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    public static final String POSTGRESQL_DRIVER_CLASS_NAME = "org.postgresql.Driver";
    public static final String H2_DRIVER_CLASS_NAME = "org.h2.Driver";
    public int lastErrorCode;
    public String lastErrorString;
    public int verMajor = 0;
    public int verMinor = 0;
    public String DBFlavor = null;
    private String sDrv;
    private String sConn;
    private String sUser;
    private String sPwd;
    private DataSource dataSource;
    private GenericObjectPool<PoolableConnection> connectionPool;
    private Connection preparedStatementConnection;
    public static final String DBFLAVOR_MYSQL = "mysql";
    public static final String DBFLAVOR_POSTGRESQL = "postgresql";
    public static final String DBFLAVOR_H2 = "h2";
    private int keepAliveCount;
    private Timer keepAliveTimer = new Timer();
    PreparedStatement preparedStatementKeepAlive;
    private static Log log = Log.get("jdbcLink");
    public static final int CONNECT_SUCCESS = 0;
    public static final int CONNECT_CLASSNOTFOUND = 1;
    public static final int CONNECT_FAILED = 2;
    public static final int CONNECT_UNKNOWN_ERROR = 10;
    public static final int TRANSACTION_COMMIT_FAILED = 21;
    public static final int TRANSACTION_ROLLBACK_FAILED = 22;
    public static final int TRANSACTION_COMMIT_NOT_SUPPORTED = 23;
    public static final int CONNECTION_CANT_CREATE_STATEMENT = 30;
    public static final int CONNECTION_CANT_PREPARE_STAMENT = 31;
    public static final int CONNECTION_SQL_ERROR = 40;
    public static final String VALIDATION_QUERY = "SELECT 1;";
    private HashMap<PreparedStatement, Connection> preparedConnections = new HashMap();
    public static final int INTEGRAL = 1;
    public static final int TEXT = 2;
    public static final int BINARY = 3;
    public static final int OTHER = 4;

    public static final String getVersion() {
        return "3.2.1";
    }

    private JdbcLink() {
    }

    public static JdbcLink createMySqlLink(String host, String database) {
        log.log(Level.INFO, "Creating MySQL-Link");
        String[] hostdetail = host.split(":");
        String hostname = hostdetail[0];
        String hostport = hostdetail.length > 1 ? hostdetail[1] : "3306";
        String driver = MYSQL_DRIVER_CLASS_NAME;
        String connect = "jdbc:mysql://" + hostname + ":" + hostport + "/" + database + "?autoReconnect=true&useSSL=false&allowPublicKeyRetrieval=true&serverTimezone=Europe/Zurich";
        return new JdbcLink(driver, connect, DBFLAVOR_MYSQL);
    }

    public static JdbcLink createInProcHsqlDBLink(String database) {
        log.log(Level.INFO, "Creating HSQL-In-Proc-Link");
        String driver = "org.hsqldb.jdbcDriver";
        String connect = "jdbc:hsqldb:" + database;
        return new JdbcLink(driver, connect, "hsqldb");
    }

    public static JdbcLink createHsqlDBLink(String host) {
        log.log(Level.INFO, "Creating HSQL-Link");
        String driver = "org.hsqldb.jdbcDriver";
        String connect = "jdbc:hsqldb:hsql://" + host;
        return new JdbcLink(driver, connect, "hsqldb");
    }

    public static JdbcLink createH2Link(String database) {
        log.log(Level.INFO, "Creating H2-Link");
        Object prefix = "jdbc:h2:";
        if (database.contains(".zip!")) {
            prefix = (String)prefix + "zip:";
        }
        Object connect = "";
        connect = database.startsWith("jdbc:h2:mem:") ? database : (String)prefix + database + ";AUTO_SERVER=TRUE";
        return new JdbcLink(H2_DRIVER_CLASS_NAME, (String)connect, DBFLAVOR_H2);
    }

    public static JdbcLink create4DLink(String host) {
        log.log(Level.INFO, "Creating 4D-Link");
        String driver = "com.fourd.jdbc.DriverImpl";
        String connect = "jdbc:4d:" + host + ":19813";
        return new JdbcLink(driver, connect, "4d");
    }

    public static JdbcLink createPostgreSQLLink(String host, String database) {
        log.log(Level.INFO, "Creating PostgreSQL-Link");
        String[] hostdetail = host.split(":");
        String hostname = hostdetail[0];
        String hostport = hostdetail.length > 1 ? hostdetail[1] : "5432";
        String connect = "jdbc:postgresql://" + hostname + ":" + hostport + "/" + database;
        return new JdbcLink(POSTGRESQL_DRIVER_CLASS_NAME, connect, DBFLAVOR_POSTGRESQL);
    }

    public static JdbcLink createODBCLink(String dsn) {
        log.log(Level.INFO, "Creating ODBC-Link");
        String driver = "sun.jdbc.odbc.JdbcOdbcDriver";
        String connect = "jdbc:odbc:" + dsn;
        return new JdbcLink(driver, connect, "ODBC");
    }

    public JdbcLink(String driver, String connect, String flavor) {
        this.sDrv = driver;
        this.sConn = connect;
        this.DBFlavor = flavor.toLowerCase();
    }

    public JdbcLink(DataSource dataSource) throws SQLException {
        String databaseProductName;
        this.dataSource = dataSource;
        this.DBFlavor = databaseProductName = dataSource.getConnection().getMetaData().getDatabaseProductName().toLowerCase();
        this.sDrv = this.translateDriverName(dataSource.getConnection().getMetaData().getDriverName());
        this.sConn = dataSource.getConnection().getMetaData().getURL();
    }

    private String translateDriverName(String driverName) {
        if (driverName.toLowerCase().contains(DBFLAVOR_MYSQL)) {
            return MYSQL_DRIVER_CLASS_NAME;
        }
        if (driverName.toLowerCase().contains("postgre")) {
            return POSTGRESQL_DRIVER_CLASS_NAME;
        }
        if (driverName.toLowerCase().contains(DBFLAVOR_H2)) {
            return H2_DRIVER_CLASS_NAME;
        }
        return driverName;
    }

    public boolean connect(String user, String password) {
        if (this.dataSource == null) {
            Exception cause = null;
            try {
                this.sUser = user;
                this.sPwd = password;
                Driver driver = (Driver)Class.forName(this.sDrv).newInstance();
                this.verMajor = driver.getMajorVersion();
                this.verMinor = driver.getMinorVersion();
                log.log(Level.INFO, "Loading database driver " + this.sDrv);
                log.log(Level.INFO, "Connecting with database " + this.sConn);
                Properties properties = new Properties();
                properties.put("user", user);
                properties.put("password", password);
                DriverConnectionFactory connectionFactory = new DriverConnectionFactory(driver, this.sConn, properties);
                PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
                poolableConnectionFactory.setValidationQuery(VALIDATION_QUERY);
                poolableConnectionFactory.setDefaultAutoCommit(Boolean.valueOf(true));
                poolableConnectionFactory.setDefaultReadOnly(Boolean.valueOf(false));
                this.connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnectionFactory);
                this.connectionPool.setMaxTotal(32);
                this.connectionPool.setMinIdle(2);
                this.connectionPool.setMaxWait(Duration.ofSeconds(10L));
                this.connectionPool.setTestOnBorrow(true);
                poolableConnectionFactory.setPool(this.connectionPool);
                this.dataSource = new PoolingDataSource(this.connectionPool);
            }
            catch (ClassNotFoundException ex) {
                this.lastErrorCode = 1;
                this.lastErrorString = "Class not found exception: " + ex.getMessage();
                throw JdbcLinkExceptionTranslation.translateException("Connect failed: " + this.lastErrorString, cause);
            }
            catch (IllegalAccessException e) {
                this.lastErrorCode = 10;
                this.lastErrorString = "Illegal access exception: " + e.getMessage();
                throw JdbcLinkExceptionTranslation.translateException("Connect failed: " + this.lastErrorString, cause);
            }
            catch (InstantiationException e) {
                this.lastErrorCode = 10;
                this.lastErrorString = "Instantiation exception: " + e.getMessage();
                throw JdbcLinkExceptionTranslation.translateException("Connect failed: " + this.lastErrorString, cause);
            }
        }
        try {
            Connection conn = this.dataSource.getConnection();
            conn.close();
            this.lastErrorCode = 0;
            this.lastErrorString = "Connect successful";
            log.log("Connect successful", 5);
            return true;
        }
        catch (SQLException e) {
            this.lastErrorCode = 10;
            this.lastErrorString = "SQL exception: " + e.getMessage();
            throw JdbcLinkExceptionTranslation.translateException("Connect failed: " + this.lastErrorString, e);
        }
        catch (IllegalStateException e) {
            this.lastErrorCode = 10;
            this.lastErrorString = "Illegal state exception: " + e.getMessage();
            throw JdbcLinkExceptionTranslation.translateException("Connect failed: " + this.lastErrorString, e);
        }
    }

    public Connection getKeepAliveConnection() {
        Connection conncetion;
        log.log(Level.INFO, "Creating new keep alive connection [" + this.keepAliveCount + "]");
        try {
            conncetion = this.dataSource.getConnection();
            this.keepAliveTimer.scheduleAtFixedRate((TimerTask)new KeepAliveTask(conncetion), 5000L, 5000L);
        }
        catch (SQLException ex) {
            this.lastErrorCode = 2;
            this.lastErrorString = "SQL exception: " + ex.getMessage();
            throw JdbcLinkExceptionTranslation.translateException("Connect failed: " + this.lastErrorString, ex);
        }
        return conncetion;
    }

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            this.lastErrorCode = 2;
            this.lastErrorString = "SQL exception: " + ex.getMessage();
            throw JdbcLinkExceptionTranslation.translateException("Connect failed: " + this.lastErrorString, ex);
        }
    }

    public String getDriverName() {
        return this.sDrv;
    }

    public String getConnectString() {
        return this.sConn;
    }

    public Stm getStatement() {
        this.checkLink();
        return this.createStatement();
    }

    private Stm createStatement() {
        try {
            return new Stm();
        }
        catch (SQLException ex) {
            this.lastErrorCode = 30;
            this.lastErrorString = ex.getMessage();
            throw JdbcLinkExceptionTranslation.translateException(this.lastErrorString, ex);
        }
    }

    public void releaseStatement(Stm s) {
        if (s != null) {
            s.delete();
        }
    }

    private void checkLink() {
        if (this.dataSource == null) {
            throw new JdbcLinkException("JdbcLink closed");
        }
    }

    public PreparedStatement getPreparedStatement(String sql) {
        try {
            Connection connection = this.dataSource.getConnection();
            PreparedStatement statement = connection.prepareStatement(sql);
            this.preparedConnections.put(statement, connection);
            return statement;
        }
        catch (SQLException e) {
            this.lastErrorCode = 31;
            this.lastErrorString = e.getMessage();
            throw JdbcLinkExceptionTranslation.translateException(this.lastErrorString, e);
        }
    }

    public void releasePreparedStatement(PreparedStatement statement) {
        Connection connection = this.preparedConnections.get(statement);
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                throw JdbcLinkExceptionTranslation.translateException(e);
            }
        }
        this.preparedConnections.remove(statement);
    }

    public synchronized PreparedStatement prepareStatement(String sql) {
        this.checkLink();
        try {
            if (this.preparedStatementConnection == null) {
                this.preparedStatementConnection = this.getKeepAliveConnection();
            }
            return this.preparedStatementConnection.prepareStatement(sql);
        }
        catch (SQLException ex) {
            this.lastErrorCode = 31;
            this.lastErrorString = ex.getMessage();
            throw JdbcLinkExceptionTranslation.translateException(this.lastErrorString, ex);
        }
    }

    public static int generalType(int t) {
        switch (t) {
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 16: {
                return 1;
            }
            case -1: 
            case 1: 
            case 12: {
                return 2;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: {
                return 3;
            }
        }
        return 4;
    }

    public static String getString(ResultSet r, String field) throws Exception {
        String res = r.getString(field);
        if (StringTool.isNothing((Object)res)) {
            return " ";
        }
        return res;
    }

    public synchronized void disconnect() {
        block7: {
            try {
                try {
                    if (this.keepAliveTimer != null) {
                        this.keepAliveTimer.cancel();
                    }
                    if (this.preparedStatementConnection != null) {
                        this.preparedStatementConnection.close();
                    }
                    this.connectionPool.close();
                }
                catch (Exception exception) {
                    this.dataSource = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.dataSource = null;
                throw throwable;
            }
            this.dataSource = null;
        }
        log.log("Disconnected", 4);
    }

    public boolean isAlive() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean nextMatch(ResultSet r, String field, FuzzyMatcher m) {
        try {
            do {
                if (r.next()) continue;
                return false;
            } while (!m.match(r.getString(field)));
            return true;
        }
        catch (SQLException ex) {
            ExHandler.handle((Throwable)ex);
            return false;
        }
    }

    public String dbDriver() {
        return this.sDrv;
    }

    public String queryString(String sql) {
        Stm stm = this.getStatement();
        String res = stm.queryString(sql);
        this.releaseStatement(stm);
        return res;
    }

    public int queryInt(String sql) {
        Stm stm = this.getStatement();
        int res = stm.queryInt(sql);
        this.releaseStatement(stm);
        return res;
    }

    public boolean execScript(InputStream i, boolean translate, boolean stopOnError) {
        Stm stm = this.getStatement();
        boolean ret = stm.execScript(i, translate, stopOnError);
        this.releaseStatement(stm);
        return ret;
    }

    public int exec(String sql) {
        Stm stm = this.getStatement();
        int res = stm.exec(sql);
        this.releaseStatement(stm);
        return res;
    }

    public String wrapFlavored(String s) {
        if (StringTool.isNothing((Object)s)) {
            return "''";
        }
        try {
            return JdbcLinkUtil.wrap((byte[])s.getBytes("UTF-8"), (String)this.DBFlavor);
        }
        catch (UnsupportedEncodingException e) {
            ExHandler.handle((Throwable)e);
            return JdbcLinkUtil.wrap((byte[])s.getBytes(), (String)this.DBFlavor);
        }
    }

    public static String readStatement(InputStream is) {
        String sql;
        block6: {
            StringBuffer inp = new StringBuffer(1000);
            sql = "<none>";
            try {
                int c;
                boolean comment = false;
                while ((c = is.read()) != -1) {
                    if (c == 59) break;
                    if (c == 35) {
                        comment = true;
                    }
                    if (c == 13 || c == 10) {
                        comment = false;
                    }
                    if (comment) continue;
                    inp.append((char)c);
                }
                sql = inp.toString().replaceAll("[\\n\\r\\t]", " ");
                if ((sql = sql.replaceAll(" {2,}", " ").trim()).length() >= 4) break block6;
                return null;
            }
            catch (IOException ex) {
                ExHandler.handle((Throwable)ex);
                return null;
            }
        }
        return sql;
    }

    public boolean dumpTable(BufferedWriter w, String name) throws Exception {
        Stm stm = this.getStatement();
        ResultSet res = stm.query("SELECT * from " + name);
        ResultSetMetaData rm = res.getMetaData();
        int cols = rm.getColumnCount();
        String[] ColNames = new String[cols];
        int[] colTypes = new int[cols];
        w.write("CREATE TABLE " + name + "(");
        int i = 0;
        while (i < cols) {
            ColNames[i] = rm.getColumnName(i + 1);
            colTypes[i] = rm.getColumnType(i + 1);
            w.write(ColNames[i] + " " + colTypes[i] + ",\n");
            ++i;
        }
        w.write(");");
        while (res != null && res.next()) {
            w.write("INSERT INTO " + name + " (");
            i = 0;
            while (i < cols) {
                w.write(ColNames[i]);
                if (i < cols - 1) {
                    w.write(",");
                }
                ++i;
            }
            w.write(") VALUES (");
            i = 0;
            while (i < cols) {
                Object o = res.getObject(ColNames[i]);
                switch (JdbcLink.generalType(colTypes[i])) {
                    case 1: {
                        if (o == null) {
                            w.write("0");
                            break;
                        }
                        w.write(Integer.toString((Integer)o));
                        break;
                    }
                    case 2: {
                        if (o == null) {
                            w.write(JdbcLinkUtil.wrap((String)"null"));
                            break;
                        }
                        w.write(JdbcLinkUtil.wrap((String)((String)o)));
                        break;
                    }
                    default: {
                        String t = o.getClass().getName();
                        log.log("Unknown type " + t, 2);
                        throw new Exception("Cant write " + t);
                    }
                }
                if (i < cols - 1) {
                    w.write(",");
                }
                ++i;
            }
            w.write(");");
            w.newLine();
        }
        res.close();
        this.releaseStatement(stm);
        return true;
    }

    public String translateFlavor(String sql) {
        if (this.DBFlavor.equalsIgnoreCase(DBFLAVOR_POSTGRESQL)) {
            sql = sql.replaceAll("BLOB", "BYTEA");
            sql = sql.replaceAll("DROP INDEX (.+?) ON .+?;", "DROP INDEX $1;");
            sql = sql.replaceAll("MODIFY\\s+(\\w+)\\s+(.+)", "ALTER COLUMN $1 TYPE $2");
            sql = sql.replaceAll("SIGNED", "INT");
        } else if (this.DBFlavor.startsWith("hsqldb") || this.DBFlavor.startsWith(DBFLAVOR_H2)) {
            sql = sql.replaceAll("TEXT", "LONGVARCHAR");
            sql = sql.replaceAll("BLOB", "LONGVARBINARY");
            sql = sql.replaceAll("CREATE +TABLE", "CREATE CACHED TABLE");
            sql = sql.replaceAll("DROP INDEX (.+?) ON .+?;", "DROP INDEX $1;");
            sql = sql.replaceAll("MODIFY (.+)", "ALTER COLUMN $1");
        } else if (this.DBFlavor.equalsIgnoreCase(DBFLAVOR_MYSQL)) {
            sql = sql.replaceAll("BLOB", "LONGBLOB");
            sql = sql.replaceAll("TEXT", "LONGTEXT");
        } else if (this.DBFlavor.equalsIgnoreCase("db2")) {
            sql = sql.replaceAll("VARCHAR\\s*\\([0-9]+\\)", "VARCHAR");
            sql = sql.replaceAll("TEXT", "CLOB");
        }
        return sql;
    }

    public String toString() {
        return this.DBFlavor + " " + this.verMajor + "." + this.verMinor;
    }

    public static String wrap(String sql) {
        return JdbcLinkUtil.wrap((String)sql);
    }

    private class KeepAliveTask
    extends TimerTask {
        private Connection connection;
        private PreparedStatement keapAliveStatement;

        public KeepAliveTask(Connection connection) throws SQLException {
            this.connection = connection;
            this.keapAliveStatement = connection.prepareStatement(JdbcLink.VALIDATION_QUERY);
        }

        @Override
        public void run() {
            try {
                this.keapAliveStatement.execute();
            }
            catch (SQLException e) {
                JdbcLink.this.lastErrorCode = 40;
                JdbcLink.this.lastErrorString = e.getMessage();
                JdbcLink.this.keepAliveTimer.cancel();
                throw JdbcLinkExceptionTranslation.translateException(JdbcLink.this.lastErrorString, e);
            }
        }
    }

    public class Stm {
        private Connection conn;
        private Statement stm;

        private void checkStm() {
            if (this.stm == null || this.conn == null) {
                throw new JdbcLinkException("Statement not valid!");
            }
        }

        private boolean reconnect() {
            try {
                if (this.conn != null && !this.conn.isClosed()) {
                    this.conn.close();
                    if (this.conn instanceof PoolableConnection) {
                        JdbcLink.this.connectionPool.invalidateObject((Object)((PoolableConnection)this.conn));
                    }
                }
                log.log(Level.WARNING, "JdbcLink.Stm - trying reconnect");
                this.conn = JdbcLink.this.getConnection();
                this.stm = this.conn.createStatement();
                return true;
            }
            catch (SQLException ex) {
                log.log(Level.SEVERE, "JdbcLink.Stm - reconnect failed " + ex.getMessage());
                JdbcLink.this.lastErrorCode = ex.getErrorCode();
                JdbcLink.this.lastErrorString = ex.getMessage();
                return false;
            }
            catch (JdbcLinkException je) {
                log.log(Level.SEVERE, "JdbcLink.Stm - Reconnect failed " + je.getMessage());
                return false;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "JdbcLink.Stm - Reconnect failed " + e.getMessage());
                return false;
            }
        }

        Stm() throws SQLException {
            block2: {
                try {
                    this.conn = JdbcLink.this.getConnection();
                    this.stm = this.conn.createStatement();
                }
                catch (SQLException se) {
                    log.log(Level.WARNING, "need reconnect " + se.getMessage());
                    if (this.reconnect()) break block2;
                    throw se;
                }
            }
        }

        public boolean isClosed() {
            this.checkStm();
            if (JdbcLink.DBFLAVOR_POSTGRESQL.equals(JdbcLink.this.DBFlavor)) {
                return false;
            }
            try {
                return this.stm.isClosed();
            }
            catch (SQLException ex) {
                ExHandler.handle((Throwable)ex);
                return false;
            }
            catch (UnsupportedOperationException ex) {
                ExHandler.handle((Throwable)ex);
                return false;
            }
        }

        public void delete() {
            try {
                if (this.stm != null && !this.stm.isClosed()) {
                    this.stm.close();
                }
                if (this.conn != null && !this.conn.isClosed()) {
                    this.conn.close();
                }
            }
            catch (SQLException ex) {
                ExHandler.handle((Throwable)ex);
            }
            this.stm = null;
            this.conn = null;
        }

        public int exec(String sql) {
            return this.internalExec(sql, false);
        }

        private int internalExec(String SQLText, boolean inError) {
            this.checkStm();
            try {
                return this.stm.executeUpdate(SQLText);
            }
            catch (SQLException e) {
                if (!inError && JdbcLink.this.connect(JdbcLink.this.sUser, JdbcLink.this.sPwd)) {
                    return this.internalExec(SQLText, true);
                }
                boolean throwException = DatabaseNativeExceptionHandler.handleException(JdbcLink.this.DBFlavor, e);
                if (throwException) {
                    throw JdbcLinkExceptionTranslation.translateException("Fehler bei: " + SQLText, e);
                }
                return 1;
            }
        }

        public ResultSet query(String SQLText) {
            return this.internalQuery(SQLText, false);
        }

        private ResultSet internalQuery(String SQLText, boolean inError) {
            this.checkStm();
            ResultSet res = null;
            try {
                res = this.stm.executeQuery(SQLText);
                return res;
            }
            catch (SQLException e) {
                if (!inError && this.reconnect()) {
                    log.log(Level.WARNING, "Reconnect");
                    return this.internalQuery(SQLText, true);
                }
                JdbcLink.this.lastErrorString = e.getMessage();
                JdbcLink.this.lastErrorCode = 40;
                throw JdbcLinkExceptionTranslation.translateException(JdbcLink.this.lastErrorString, e);
            }
        }

        public Vector queryList(String sql, String[] fields) {
            Vector<Object> rs = new Vector<Object>();
            log.log("executing " + sql, 5);
            ResultSet res = this.internalQuery(sql, false);
            try {
                if (res != null) {
                    while (res.next()) {
                        Object[] o = new Object[fields.length];
                        int i = 0;
                        while (i < fields.length) {
                            o[i] = res.getObject(fields[i]);
                            ++i;
                        }
                        if (fields.length == 1) {
                            rs.add(o[0]);
                            continue;
                        }
                        rs.add(o);
                    }
                }
            }
            catch (SQLException ex) {
                ExHandler.handle((Throwable)ex);
            }
            return rs;
        }

        public String queryString(String sql) {
            block3: {
                String r;
                block4: {
                    ResultSet res = this.internalQuery(sql, false);
                    try {
                        if (res == null || !res.next()) break block3;
                        r = res.getString(1);
                        if (r != null && !r.equals("null") && !r.equals("")) break block4;
                        return "";
                    }
                    catch (SQLException ex) {
                        ExHandler.handle((Throwable)ex);
                        return null;
                    }
                }
                return r;
            }
            return null;
        }

        public int queryInt(String sql) {
            ResultSet res = this.internalQuery(sql, false);
            try {
                if (res != null && res.next()) {
                    return res.getInt(1);
                }
            }
            catch (SQLException ex) {
                ExHandler.handle((Throwable)ex);
            }
            return -1;
        }

        /*
         * Unable to fully structure code
         */
        public boolean execScript(InputStream s, boolean translate, boolean stopOnError) {
            sql = "<none>";
            if (s != null) ** GOTO lbl16
            return false;
lbl-1000:
            // 1 sources

            {
                JdbcLink.log.log(sql, 5);
                if (translate) {
                    sql = JdbcLink.this.translateFlavor(sql);
                }
                System.out.println(sql);
                try {
                    this.stm.execute(sql);
                    continue;
                }
                catch (SQLException ex) {
                    ExHandler.handle((Throwable)ex);
                    if (!stopOnError) continue;
                    return false;
                }
lbl16:
                // 3 sources

                ** while ((sql = JdbcLink.readStatement((InputStream)s)) != null)
            }
lbl17:
            // 1 sources

            return true;
        }
    }
}

