/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.utils;

import ch.rgw.tools.StringTool;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreUtil {
    public static final String TEST_MODE = "elexis.test.mode";
    public static final String HOME_MODE = "ch.elexis.home";
    private static Logger logger = LoggerFactory.getLogger(CoreUtil.class);
    private static final OS osType;
    private static final boolean testMode;

    static {
        String osName = System.getProperty("os.name");
        osType = osName.startsWith("Linux") ? OS.LINUX : (osName.startsWith("Mac") || osName.startsWith("Darwin") ? OS.MAC : (osName.startsWith("Windows") ? OS.WINDOWS : OS.UNSPECIFIED));
        testMode = Boolean.valueOf(System.getProperty(TEST_MODE));
    }

    public static boolean isTestMode() {
        return testMode;
    }

    public static Path getElexisServerHomeDirectory() {
        String userHomeProp = System.getProperty("user.home");
        File homedir = new File(new File(userHomeProp), "elexis-server");
        if (!homedir.exists()) {
            homedir.mkdir();
        }
        return Paths.get(homedir.toURI());
    }

    public static File getWritableUserDir() {
        File userDir;
        String homeProp = System.getProperty(HOME_MODE);
        if (StringUtils.isNotBlank((CharSequence)homeProp)) {
            File baseDir = new File(System.getProperty("user.dir"));
            userDir = new File(baseDir, homeProp);
        } else {
            String userhome = System.getProperty("user.home");
            if (StringUtils.isBlank((CharSequence)userhome)) {
                userhome = System.getProperty("java.io.tmpdir");
            }
            userDir = new File(userhome, "elexis");
        }
        if (!userDir.exists() && !userDir.mkdirs()) {
            logger.error("Panic exit, could not create userdir " + userDir.getAbsolutePath());
            System.exit(-5);
        }
        return userDir;
    }

    public static File getTempDir() {
        File ret = null;
        String temp = System.getProperty("java.io.tmpdir");
        if (!StringTool.isNothing((Object)temp)) {
            ret = new File(temp);
            if (ret.exists() && ret.isDirectory()) {
                return ret;
            }
            if (ret.mkdirs()) {
                return ret;
            }
        }
        return CoreUtil.getWritableUserDir();
    }

    public static String getDefaultDBPath() {
        String base = System.getProperty("user.home") + "/elexisdata";
        File f = new File(base);
        if (!f.exists()) {
            f.mkdirs();
        }
        return base;
    }

    public static final OS getOperatingSystemType() {
        return osType;
    }

    public static final boolean isWindows() {
        return osType == OS.WINDOWS;
    }

    public static final boolean isMac() {
        return osType == OS.MAC;
    }

    public static final boolean isLinux() {
        return osType == OS.LINUX;
    }

    public static enum OS {
        UNSPECIFIED,
        MAC,
        LINUX,
        WINDOWS;

    }
}

