/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.model.builder;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.ILabItem;
import ch.elexis.core.model.ILabMapping;
import ch.elexis.core.model.builder.AbstractBuilder;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.types.LabItemTyp;
import java.util.ArrayList;
import java.util.List;

public class ILabItemBuilder
extends AbstractBuilder<ILabItem> {
    private List<ILabMapping> mappingList;

    public ILabItemBuilder(IModelService modelService, String code, String name, String refMale, String refFemale, String unit, LabItemTyp type, String group, int seq) {
        super(modelService);
        this.object = modelService.create(ILabItem.class);
        ((ILabItem)this.object).setCode(code);
        ((ILabItem)this.object).setName(name);
        ((ILabItem)this.object).setReferenceMale(refMale);
        ((ILabItem)this.object).setReferenceFemale(refFemale);
        ((ILabItem)this.object).setUnit(unit);
        ((ILabItem)this.object).setTyp(type);
        ((ILabItem)this.object).setGroup(group);
        ((ILabItem)this.object).setPriority(Integer.toString(seq));
        ((ILabItem)this.object).setVisible(true);
    }

    public ILabItemBuilder origin(IContact origin, String itemName, boolean charge) {
        if (this.mappingList == null) {
            this.mappingList = new ArrayList<ILabMapping>();
        }
        ILabMapping mapping = this.modelService.create(ILabMapping.class);
        mapping.setItem((ILabItem)this.object);
        mapping.setOrigin(origin);
        mapping.setItemName(itemName);
        mapping.setCharge(charge);
        this.mappingList.add(mapping);
        return this;
    }

    @Override
    public ILabItem buildAndSave() {
        this.modelService.save(this.object);
        if (this.mappingList != null) {
            this.modelService.save(this.mappingList);
        }
        return (ILabItem)this.object;
    }

    @Override
    public ILabItem build() {
        if (this.mappingList != null) {
            throw new IllegalStateException("Will loose mapping on lazy save operation");
        }
        return (ILabItem)super.build();
    }
}

