/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.common;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"rdbmsType", "hostName", "port", "databaseName", "connectionString", "username", "password", "text"})
public class DBConnection
implements Serializable {
    private static final long serialVersionUID = -7571011690246990109L;
    public DBType rdbmsType;
    @XmlAttribute
    public String hostName;
    @XmlAttribute
    public String port;
    @XmlAttribute
    public String databaseName;
    @XmlAttribute
    public String connectionString;
    @XmlAttribute
    public String username;
    @XmlAttribute
    public String password;
    @XmlAttribute
    public String text;

    public DBConnection(DBType rdbmsType, String jdbcString, String username, char[] password) {
        this.rdbmsType = rdbmsType;
        this.connectionString = jdbcString;
        this.username = username;
        this.password = new String(password);
    }

    public DBConnection() {
    }

    public boolean allValuesSet() {
        boolean result = true;
        if (this.rdbmsType == null) {
            result = false;
        }
        if (!DBType.H2.equals((Object)this.rdbmsType) && StringUtils.isBlank((CharSequence)this.hostName)) {
            result = false;
        }
        if (StringUtils.isBlank((CharSequence)this.databaseName)) {
            result = false;
        }
        if (StringUtils.isBlank((CharSequence)this.username)) {
            result = false;
        }
        return result;
    }

    public static Optional<String> getHostName(String url) {
        URI uri;
        String host;
        if (url == null || url.startsWith("jdbc:h2:")) {
            return Optional.empty();
        }
        if (url.startsWith("jdbc:")) {
            url = url.substring(5);
        }
        if (!StringUtils.isEmpty((CharSequence)(host = (uri = URI.create(url)).getHost()))) {
            return Optional.of(host);
        }
        return Optional.empty();
    }

    public static Optional<String> getDatabaseName(String url) {
        URI uri;
        String path;
        if (url.startsWith("jdbc:h2:") && (url = url.substring("jdbc:h2:".length())).indexOf(59) > -1) {
            url = url.substring(0, url.indexOf(59));
            return Optional.of(url);
        }
        if (url.startsWith("jdbc:")) {
            url = url.substring(5);
        }
        if (!StringUtils.isBlank((CharSequence)(path = (uri = URI.create(url)).getPath()))) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.contains("/")) {
                path = path.substring(0, path.indexOf("/"));
            }
            return Optional.of(path);
        }
        return Optional.empty();
    }

    @XmlType
    @XmlEnum(value=String.class)
    public static enum DBType {
        MySQL("com.mysql.cj.jdbc.Driver", "mySQl", "3306"),
        PostgreSQL("org.postgresql.Driver", "PostgreSQL", "5432"),
        H2("org.h2.Driver", "H2", "");

        public final String driverName;
        public final String dbType;
        public final String defaultPort;

        private DBType(String driverName, String dbType, String defaultPort) {
            this.driverName = driverName;
            this.dbType = dbType;
            this.defaultPort = defaultPort;
        }

        public static Optional<DBType> valueOfIgnoreCase(String value) {
            DBType[] dBTypeArray = DBType.values();
            int n = dBTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBType dbType = dBTypeArray[n2];
                if (dbType.dbType.equalsIgnoreCase(value)) {
                    return Optional.of(dbType);
                }
                ++n2;
            }
            return Optional.empty();
        }

        public static Optional<DBType> valueOfDriver(String driver) {
            if (driver.equals("com.mysql.jdbc.Driver")) {
                return Optional.of(MySQL);
            }
            DBType[] dBTypeArray = DBType.values();
            int n = dBTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBType dbType = dBTypeArray[n2];
                if (dbType.driverName.equals(driver)) {
                    return Optional.of(dbType);
                }
                ++n2;
            }
            return Optional.empty();
        }
    }
}

