/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.webdav;

import com.github.sardine.Sardine;
import com.github.sardine.Version;
import com.github.sardine.impl.SardineImpl;
import com.github.sardine.impl.SardineRedirectStrategy;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.ProxySelector;
import java.net.URL;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.slf4j.LoggerFactory;

public enum WebdavPool {
    INSTANCE;

    private Cache<String, Sardine> sardines = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private Registry<ConnectionSocketFactory> defaultSchemeRegistry;
    private PoolingHttpClientConnectionManager defaultConnectionManager;
    private DefaultSchemePortResolver defaultSchemePortResolver;
    private SardineRedirectStrategy defaultRedirectStrategy;
    private HttpRoutePlanner defaultRoutePlanner;

    public synchronized Sardine getSardine(URL url) {
        try {
            return (Sardine)this.sardines.get((Object)this.getSardineKey(url), () -> {
                HttpClientBuilder builder = this.getHttpClientBuilder(url);
                SardineImpl sardineImpl = new SardineImpl(builder);
                sardineImpl.enablePreemptiveAuthentication(url);
                sardineImpl.enableCompression();
                return sardineImpl;
            });
        }
        catch (ExecutionException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error getting webdav", (Throwable)e);
            return null;
        }
    }

    private HttpClientBuilder getHttpClientBuilder(URL url) {
        Registry<ConnectionSocketFactory> schemeRegistry = this.createDefaultSchemeRegistry();
        HttpClientConnectionManager cm = this.createDefaultConnectionManager(schemeRegistry);
        String version = Version.getSpecification();
        if (version == null) {
            version = "UNAVAILABLE";
        }
        HttpClientBuilder ret = HttpClients.custom().setUserAgent("Sardine/" + version).setRedirectStrategy((RedirectStrategy)this.createDefaultRedirectStrategy()).setDefaultRequestConfig(RequestConfig.custom().setExpectContinueEnabled(false).setCookieSpec("standard").build()).setConnectionManager(cm).setRoutePlanner(this.createDefaultRoutePlanner((SchemePortResolver)this.createDefaultSchemePortResolver(), null));
        if (StringUtils.isNotBlank((CharSequence)url.getUserInfo())) {
            if (url.getUserInfo().contains(":")) {
                String[] userInfo = url.getUserInfo().split(":");
                ret.setDefaultCredentialsProvider(this.createDefaultCredentialsProvider(userInfo[0], userInfo[1], null, null));
            } else {
                BasicHeader bearerHeader = new BasicHeader("Authorization", "Bearer " + url.getUserInfo());
                ret.setDefaultHeaders(Collections.singletonList(bearerHeader));
            }
        }
        return ret;
    }

    HttpClientConnectionManager createDefaultConnectionManager(Registry<ConnectionSocketFactory> schemeRegistry) {
        if (this.defaultConnectionManager == null) {
            this.defaultConnectionManager = new PoolingHttpClientConnectionManager(schemeRegistry);
        }
        return this.defaultConnectionManager;
    }

    private Registry<ConnectionSocketFactory> createDefaultSchemeRegistry() {
        if (this.defaultSchemeRegistry == null) {
            this.defaultSchemeRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
        }
        return this.defaultSchemeRegistry;
    }

    private DefaultSchemePortResolver createDefaultSchemePortResolver() {
        if (this.defaultSchemePortResolver == null) {
            this.defaultSchemePortResolver = new DefaultSchemePortResolver();
        }
        return this.defaultSchemePortResolver;
    }

    private SardineRedirectStrategy createDefaultRedirectStrategy() {
        if (this.defaultRedirectStrategy == null) {
            this.defaultRedirectStrategy = new SardineRedirectStrategy();
        }
        return this.defaultRedirectStrategy;
    }

    private HttpRoutePlanner createDefaultRoutePlanner(SchemePortResolver resolver, ProxySelector selector) {
        if (this.defaultRoutePlanner == null) {
            this.defaultRoutePlanner = new SystemDefaultRoutePlanner(resolver, selector);
        }
        return this.defaultRoutePlanner;
    }

    private CredentialsProvider createDefaultCredentialsProvider(String username, String password, String domain, String workstation) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        if (username != null) {
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "NTLM"), (Credentials)new NTCredentials(username, password, workstation, domain));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Basic"), (Credentials)new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Digest"), (Credentials)new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Negotiate"), (Credentials)new NTCredentials(username, password, workstation, domain));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Kerberos"), (Credentials)new UsernamePasswordCredentials(username, password));
        }
        return provider;
    }

    String getSardineKey(URL url) {
        return url.getUserInfo() + "@" + url.getHost();
    }
}

