/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.views;

import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.Deleteable;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrderEntry;
import ch.elexis.core.model.IStock;
import ch.elexis.core.model.IStockEntry;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IStockService;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.OrderServiceHolder;
import ch.elexis.core.services.holder.StockCommissioningServiceHolder;
import ch.elexis.core.services.holder.StockServiceHolder;
import ch.elexis.core.status.ElexisStatus;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.actions.CodeSelectorHandler;
import ch.elexis.core.ui.actions.ICodeSelectorTarget;
import ch.elexis.core.ui.dialogs.OrderImportDialog;
import ch.elexis.core.ui.dialogs.StockSelectorDialog;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import ch.elexis.core.ui.editors.KontaktSelektorDialogCellEditor;
import ch.elexis.core.ui.editors.NumericCellEditorValidator;
import ch.elexis.core.ui.editors.ReflectiveEditingSupport;
import ch.elexis.core.ui.events.RefreshingPartListener;
import ch.elexis.core.ui.icons.Images;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.ViewMenus;
import ch.elexis.core.ui.util.dnd.IdentifiableDragSource;
import ch.elexis.core.ui.util.dnd.IdentifiableDropTarget;
import ch.elexis.core.ui.views.IRefreshable;
import ch.elexis.core.ui.views.Messages;
import ch.elexis.core.ui.views.provider.StockEntryLabelProvider;
import ch.elexis.data.PersistentObject;
import ch.elexis.scripting.CSVWriter;
import ch.rgw.tools.ExHandler;
import ch.rgw.tools.Money;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockView
extends ViewPart
implements IRefreshable {
    public static final String ID = "ch.elexis.core.ui.views.StockView";
    private Logger log = LoggerFactory.getLogger(StockView.class);
    private Text filterText;
    private StockEntryLoader loader;
    private TableViewer viewer;
    private StockEntryLabelProvider labelProvider;
    private ViewMenus viewMenus;
    private IAction refreshAction;
    private IAction exportAction;
    private IAction scanInventoryAction;
    private RefreshingPartListener udpateOnVisible = new RefreshingPartListener(this);
    private static final int STOCK = 0;
    private static final int PHARMACODE = 1;
    private static final int GTIN = 2;
    private static final int NAME = 3;
    private static final int VP = 4;
    private static final int MIN = 5;
    private static final int IST = 6;
    private static final int MAX = 7;
    private static final int SUPPLIER = 8;
    private StockViewComparator comparator;
    String[] columns = new String[]{Messages.Core_Stock, Messages.Core_Phamacode, Messages.LagerView_gtin, Messages.Core_Name, Messages.LagerView_vkPreis, Messages.LagerView_minBestand, Messages.LagerView_istBestand, Messages.LagerView_maxBestand, Messages.Core_Article_provider};
    int[] colwidth = new int[]{50, 75, 90, 250, 50, 35, 35, 35, 150};

    public void createPartControl(Composite parent) {
        this.labelProvider = new StockEntryLabelProvider();
        parent.setLayout((Layout)new GridLayout(2, false));
        this.filterText = new Text(parent, 2176);
        this.filterText.setMessage("Filter");
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                StockView.this.refresh();
            }
        });
        ToolBarManager tbm = new ToolBarManager();
        tbm.add((IAction)new Action("", 2){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_FILTER.getImageDescriptor();
            }

            public String getToolTipText() {
                return "Nur zu bestellende anzeigen";
            }

            public void run() {
                StockEntryLoader.setFilterOrderOnly(this.isChecked());
                StockView.this.refresh();
            }
        });
        tbm.add((IAction)new Action("", 2){

            public ImageDescriptor getImageDescriptor() {
                return Images.IMG_CART.getImageDescriptor();
            }

            public String getToolTipText() {
                return "Nur einzubuchende anzeigen";
            }

            public void run() {
                StockEntryLoader.setFilterBookInOnly(this.isChecked());
                StockView.this.refresh();
            }
        });
        tbm.createControl(parent);
        this.viewer = new TableViewer(parent, 268503556);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        int i = 0;
        while (i < this.columns.length) {
            TableViewerColumn tvc = new TableViewerColumn(this.viewer, 0);
            TableColumn tc = tvc.getColumn();
            tc.setText(this.columns[i]);
            tc.setWidth(this.colwidth[i]);
            tc.setData((Object)i);
            tvc.setLabelProvider((CellLabelProvider)new StockEntryLabelProvider.ColumnStockEntryLabelProvider(i, this.labelProvider));
            final int columnIndex = i;
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StockView.this.comparator.setColumn(columnIndex);
                    StockView.this.refresh();
                }
            });
            ReflectiveEditingSupport poes = null;
            if (i == 5) {
                poes = new ReflectiveEditingSupport(this.viewer, ModelPackage.Literals.ISTOCK_ENTRY__MINIMUM_STOCK.getName(), new NumericCellEditorValidator(), true);
            } else if (i == 6) {
                poes = new ReflectiveEditingSupport(this.viewer, ModelPackage.Literals.ISTOCK_ENTRY__CURRENT_STOCK.getName(), new NumericCellEditorValidator(), true){

                    @Override
                    protected boolean canEdit(Object element) {
                        boolean canEdit = super.canEdit(element);
                        if (canEdit) {
                            IStockEntry se = (IStockEntry)element;
                            return !se.getStock().isCommissioningSystem();
                        }
                        return true;
                    }
                };
            } else if (i == 7) {
                poes = new ReflectiveEditingSupport(this.viewer, ModelPackage.Literals.ISTOCK_ENTRY__MAXIMUM_STOCK.getName(), new NumericCellEditorValidator(), true);
            }
            if (poes != null) {
                tvc.setEditingSupport((EditingSupport)poes.setModelService(CoreModelServiceHolder.get()));
            }
            if (i == 8) {
                EditingSupport providerEditingSupport = new EditingSupport((ColumnViewer)this.viewer){

                    protected void setValue(Object element, Object value) {
                        IStockEntry se;
                        if (value instanceof PersistentObject) {
                            value = NoPoUtil.loadAsIdentifiable((PersistentObject)((PersistentObject)value), IContact.class).orElse(null);
                        }
                        if ((se = (IStockEntry)element) == null) {
                            return;
                        }
                        LockResponse lr = LocalLockServiceHolder.get().acquireLock((Object)se);
                        if (!lr.isOk()) {
                            return;
                        }
                        se.setProvider((IContact)value);
                        lr = LocalLockServiceHolder.get().releaseLock((Object)se);
                        if (!lr.isOk()) {
                            StockView.this.log.warn("Error releasing lock for [{}]: {}", (Object)se.getId(), (Object)lr.getStatus());
                        }
                        this.getViewer().refresh();
                    }

                    protected Object getValue(Object element) {
                        IStockEntry se = (IStockEntry)element;
                        if (se == null) {
                            return null;
                        }
                        return se.getProvider();
                    }

                    protected CellEditor getCellEditor(Object element) {
                        return new KontaktSelektorDialogCellEditor((Composite)((TableViewer)this.getViewer()).getTable(), "Lieferant ausw\u00e4hlen", "Bitte selektieren Sie den Lieferant");
                    }

                    protected boolean canEdit(Object element) {
                        IStockEntry stockEntry = (IStockEntry)element;
                        return stockEntry != null && stockEntry.getArticle() != null;
                    }
                };
                tvc.setEditingSupport(providerEditingSupport);
            }
            ++i;
        }
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.viewer, new FocusCellHighlighter((ColumnViewer)this.viewer){});
        ColumnViewerEditorActivationStrategy editorActivationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                ViewerCell cell = (ViewerCell)event.getSource();
                return cell.getColumnIndex() > 4 && cell.getColumnIndex() < 9;
            }
        };
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)editorActivationStrategy, (int)16);
        MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new CheckInOrderedAction((Viewer)StockView.this.viewer));
                manager.add((IAction)new DeleteStockEntryAction((Viewer)StockView.this.viewer));
                ArticleMachineOutputAction amoa = new ArticleMachineOutputAction((Viewer)StockView.this.viewer);
                if (amoa.isVisible()) {
                    manager.add((IAction)amoa);
                    manager.add((IAction)new FullMachineInventoryAction((Viewer)StockView.this.viewer));
                }
            }
        });
        new IdentifiableDropTarget(this.viewer.getControl(), new IdentifiableDropTarget.IReceiver(){

            @Override
            public void dropped(List<Identifiable> identifiables) {
                for (Identifiable identifiable : identifiables) {
                    IStock stock;
                    StockSelectorDialog ssd;
                    int open;
                    if (!(identifiable instanceof IArticle) || ((IArticle)identifiable).isProduct() || (open = (ssd = new StockSelectorDialog(UiDesk.getTopShell(), false)).open()) != 0 || ssd.getResult().length <= 0 || (stock = (IStock)ssd.getResult()[0]) == null) continue;
                    StockServiceHolder.get().storeArticleInStock(stock, StoreToStringServiceHolder.getStoreToString((Object)identifiable));
                    StockView.this.viewer.refresh();
                }
            }

            @Override
            public boolean accept(List<Identifiable> identifiables) {
                for (Identifiable identifiable : identifiables) {
                    if (identifiable instanceof IArticle) continue;
                    return false;
                }
                return true;
            }
        });
        new IdentifiableDragSource((StructuredViewer)this.viewer);
        Menu menu = contextMenu.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.viewer.addDoubleClickListener(event -> {
            void stockEntry;
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            Object element = sel.getFirstElement();
            if (!(element instanceof IStockEntry)) {
                return;
            }
            IStockEntry iStockEntry = (IStockEntry)element;
            IArticle article = stockEntry.getArticle();
            if (article == null) {
                return;
            }
            CodeSelectorHandler handler = CodeSelectorHandler.getInstance();
            ICodeSelectorTarget target = handler.getCodeSelectorTarget();
            if (target != null) {
                target.codeSelected(article);
            }
        });
        this.comparator = new StockViewComparator();
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.makeActions();
        this.viewMenus = new ViewMenus(this.getViewSite());
        this.viewMenus.createToolbar(this.refreshAction, this.scanInventoryAction);
        this.viewMenus.createMenu(this.exportAction);
        this.getSite().getPage().addPartListener((IPartListener2)this.udpateOnVisible);
    }

    @Optional
    @Inject
    public void udpate(@UIEventTopic(value="info/elexis/model/update") IStockEntry entry) {
        if (entry != null && this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.update((Object)entry, null);
        }
    }

    private void makeActions() {
        this.scanInventoryAction = new Action(Messages.StockView_InventoryMode){
            {
                this.setImageDescriptor(Images.IMG_SCANNER_BARCODE.getImageDescriptor());
            }

            public void run() {
                new OrderImportDialog(UiDesk.getTopShell(), null, OrderImportDialog.ACTION_MODE_INVENTORY).open();
            }
        };
        this.refreshAction = new Action(Messages.StockView_reload){
            {
                this.setImageDescriptor(Images.IMG_REFRESH.getImageDescriptor());
            }

            public void run() {
                StockView.this.refresh();
            }
        };
        this.exportAction = new Action(Messages.Core_export_to_csv, Images.IMG_EXPORT.getImageDescriptor()){

            public void run() {
                block17: {
                    FileDialog dialog = new FileDialog(UiDesk.getTopShell(), 8192);
                    dialog.setFilterExtensions(new String[]{"*.csv"});
                    dialog.setFilterNames(new String[]{"Comma Separated Values (CSV)"});
                    dialog.setOverwrite(true);
                    dialog.setFileName("lager_export.csv");
                    String pathToSave = dialog.open();
                    if (pathToSave != null) {
                        CSVWriter csv = null;
                        try {
                            try {
                                int errorUnknownArticle = 0;
                                int success = 0;
                                FileOutputStream fos = new FileOutputStream(pathToSave);
                                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "ISO-8859-1");
                                csv = new CSVWriter(osw);
                                StockView.this.log.debug("csv export started for: " + pathToSave);
                                String[] header = new String[]{"Name", "Pharmacode", "EAN", "Max", "Min", "Aktuell Packung an Lager", "Aktuell an Lager (Anbruch)", "St\u00fcck pro Packung", "St\u00fcck pro Abgabe", "Einkaufspreis", "Verkaufspreis", "Typ (P, N, ...)", "Lieferant"};
                                csv.writeNext(header);
                                List entries = CoreModelServiceHolder.get().getQuery(IStockEntry.class).execute();
                                for (IStockEntry iStockEntry : entries) {
                                    String[] line = new String[header.length];
                                    IArticle article = iStockEntry.getArticle();
                                    if (article != null) {
                                        line[0] = article.getLabel();
                                        line[1] = article.getCode();
                                        line[2] = article.getGtin();
                                        line[3] = String.valueOf(iStockEntry.getMaximumStock());
                                        line[4] = String.valueOf(iStockEntry.getMinimumStock());
                                        line[5] = String.valueOf(iStockEntry.getCurrentStock());
                                        line[6] = String.valueOf(iStockEntry.getFractionUnits());
                                        line[7] = String.valueOf(article.getPackageSize());
                                        line[8] = String.valueOf(article.getSellingSize());
                                        line[9] = new Money(article.getPurchasePrice()).getAmountAsString();
                                        line[10] = new Money(article.getSellingPrice()).getAmountAsString();
                                        line[11] = Character.toString(article.getSubTyp().getTypeChar());
                                        IContact provider = iStockEntry.getProvider();
                                        if (provider != null) {
                                            line[12] = provider.getLabel();
                                        }
                                        csv.writeNext(line);
                                        ++success;
                                        continue;
                                    }
                                    ++errorUnknownArticle;
                                    StockView.this.log.warn("cannot export: id [" + iStockEntry.getId() + "] " + iStockEntry.getLabel());
                                }
                                csv.close();
                                StockView.this.log.debug("csv export finished for: " + pathToSave);
                                StringBuffer msg2 = new StringBuffer();
                                msg2.append("Der Export nach ");
                                msg2.append(pathToSave);
                                msg2.append(" ist abgeschlossen.");
                                msg2.append("\n\n");
                                msg2.append(success);
                                msg2.append(" Artikel wurden erfolgreich exportiert.");
                                if (errorUnknownArticle > 0) {
                                    msg2.append("\n");
                                    msg2.append(errorUnknownArticle);
                                    msg2.append(" Artikel konnten nicht exportiert werden (Unbekannte Artikel Typen).");
                                }
                                SWTHelper.showInfo("Lager export", msg2.toString());
                            }
                            catch (Exception ex) {
                                ExHandler.handle((Throwable)ex);
                                StockView.this.log.error("csv exporter error", (Throwable)ex);
                                SWTHelper.showError("Fehler", ex.getMessage());
                                if (csv == null) break block17;
                                try {
                                    csv.close();
                                }
                                catch (IOException e) {
                                    StockView.this.log.error("cannot close csv exporter", (Throwable)e);
                                }
                            }
                        }
                        finally {
                            if (csv != null) {
                                try {
                                    csv.close();
                                }
                                catch (IOException e) {
                                    StockView.this.log.error("cannot close csv exporter", (Throwable)e);
                                }
                            }
                        }
                    }
                }
            }
        };
    }

    public void setFocus() {
        this.filterText.setFocus();
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener2)this.udpateOnVisible);
        super.dispose();
    }

    @Optional
    @Inject
    public void setFixLayout(MPart part, @Named(value="perspectives/fix_layout") boolean currentState) {
        CoreUiUtil.updateFixLayout((MPart)part, (boolean)currentState);
    }

    @Override
    public void refresh() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            String search = this.filterText.getText();
            if (search != null && search.length() > 2) {
                if (this.loader != null) {
                    this.loader.cancel();
                }
                this.loader = new StockEntryLoader((Viewer)this.viewer, search);
                this.loader.schedule();
            } else {
                this.loader = new StockEntryLoader((Viewer)this.viewer);
                this.loader.schedule();
            }
        }
    }

    public class ArticleMachineOutputAction
    extends Action {
        private Viewer viewer;

        public ArticleMachineOutputAction(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean isVisible() {
            IStock stock;
            IStockEntry stockEntry = this.fetchSelection();
            if (stockEntry != null && (stock = stockEntry.getStock()) != null) {
                String driverUuid = stock.getDriverUuid();
                return driverUuid != null && driverUuid.length() > 8;
            }
            return false;
        }

        public String getText() {
            return Messages.StockView_OutlayArticle;
        }

        public void run() {
            IStockEntry stockEntry = this.fetchSelection();
            IStatus status = StockCommissioningServiceHolder.get().performArticleOutlay(stockEntry, 1, null);
            if (!status.isOK()) {
                ElexisStatus elStatus = new ElexisStatus(status);
                StatusManager.getManager().handle((IStatus)elStatus, 2);
            }
        }

        private IStockEntry fetchSelection() {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IStockEntry) {
                return (IStockEntry)selection.getFirstElement();
            }
            return null;
        }
    }

    public class CheckInOrderedAction
    extends Action {
        private Viewer viewer;
        private IStockEntry stockEntry;

        public CheckInOrderedAction(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean isEnabled() {
            this.stockEntry = null;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IStockEntry) {
                this.stockEntry = (IStockEntry)selection.getFirstElement();
                if (this.stockEntry.getArticle() != null) {
                    return OrderServiceHolder.get().findOpenOrderEntryForStockEntry(this.stockEntry) != null;
                }
            }
            return false;
        }

        public String getText() {
            return Messages.BestellView_CheckInCaption;
        }

        public void run() {
            this.stockEntry = null;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IStockEntry) {
                this.stockEntry = (IStockEntry)selection.getFirstElement();
                if (this.stockEntry.getArticle() != null) {
                    IOrderEntry orderEntry = OrderServiceHolder.get().findOpenOrderEntryForStockEntry(this.stockEntry);
                    OrderImportDialog dialog = new OrderImportDialog(this.viewer.getControl().getShell(), orderEntry.getOrder());
                    dialog.open();
                    this.viewer.refresh();
                }
            }
        }
    }

    public class DeleteStockEntryAction
    extends Action {
        private Viewer viewer;
        private IStockEntry stockEntry;

        public DeleteStockEntryAction(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean isEnabled() {
            this.stockEntry = null;
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IStockEntry) {
                this.stockEntry = (IStockEntry)selection.getFirstElement();
                if (this.stockEntry != null) {
                    IStock stock = this.stockEntry.getStock();
                    return stock != null && !stock.isCommissioningSystem();
                }
            }
            return false;
        }

        public String getText() {
            return Messages.Core_Remove;
        }

        public String getToolTipText() {
            return Messages.LagerView_deleteActionToolTip;
        }

        public void run() {
            IArticle article;
            if (this.stockEntry != null && (article = this.stockEntry.getArticle()) != null && MessageDialog.openConfirm((Shell)this.viewer.getControl().getShell(), (String)Messages.LagerView_deleteActionConfirmCaption, (String)MessageFormat.format(Messages.LagerView_deleteConfirmBody, article.getName()))) {
                CoreModelServiceHolder.get().delete((Deleteable)this.stockEntry);
                this.viewer.refresh();
            }
        }
    }

    public class FullMachineInventoryAction
    extends Action {
        private Viewer viewer;

        public FullMachineInventoryAction(Viewer viewer) {
            this.viewer = viewer;
        }

        public ImageDescriptor getImageDescriptor() {
            return Images.IMG_SYNC.getImageDescriptor();
        }

        public String getText() {
            return Messages.StockView_PerformFullInventoryOnCommSystem;
        }

        public void run() {
            IStockEntry stockEntry = this.fetchSelection();
            IStatus status = StockCommissioningServiceHolder.get().synchronizeInventory(stockEntry.getStock(), null, null);
            if (!status.isOK()) {
                ElexisStatus elStatus = new ElexisStatus(status);
                StatusManager.getManager().handle((IStatus)elStatus, 2);
            }
        }

        private IStockEntry fetchSelection() {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (selection != null && !selection.isEmpty() && selection.getFirstElement() instanceof IStockEntry) {
                return (IStockEntry)selection.getFirstElement();
            }
            return null;
        }
    }

    private static class StockEntryLoader
    extends Job {
        private Viewer viewer;
        private static boolean filterOrderOnly = false;
        private static boolean filterBookInOnly = false;
        private String filter;
        private List<IStockEntry> loaded;

        public StockEntryLoader(Viewer viewer, String filter) {
            super("Stock loading ...");
            this.viewer = viewer;
            this.filter = filter;
        }

        public static void setFilterOrderOnly(boolean checked) {
            filterOrderOnly = checked;
        }

        public static void setFilterBookInOnly(boolean checked) {
            filterBookInOnly = checked;
        }

        public StockEntryLoader(Viewer viewer) {
            super("Stock loading ...");
            this.viewer = viewer;
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Stock loading ...", -1);
            this.loaded = StockServiceHolder.get().getAllStockEntries(false);
            if (filterOrderOnly) {
                this.loaded = this.loaded.parallelStream().filter(se -> this.selectOrderOnly((IStockEntry)se)).collect(Collectors.toList());
            }
            if (filterBookInOnly) {
                this.loaded = this.loaded.parallelStream().filter(se -> this.selectToOrderOnly((IStockEntry)se)).collect(Collectors.toList());
            }
            if (this.filter != null) {
                this.loaded = this.loaded.parallelStream().filter(se -> this.selectFilter((IStockEntry)se, this.filter)).collect(Collectors.toList());
            }
            this.loaded.sort(this.compareArticleLabel());
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    viewer.setInput(loaded);
                }
            });
            return Status.OK_STATUS;
        }

        private Comparator<IStockEntry> compareArticleLabel() {
            return Comparator.comparing(o -> o.getArticle() != null ? o.getArticle().getLabel() : null, Comparator.nullsLast(Comparator.naturalOrder()));
        }

        private boolean selectOrderOnly(IStockEntry se) {
            IStockService.Availability availability = StockServiceHolder.get().determineAvailability(se);
            if (availability != null) {
                switch (availability) {
                    case CRITICAL_STOCK: 
                    case OUT_OF_STOCK: {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        private boolean selectToOrderOnly(IStockEntry se) {
            IOrderEntry availability = OrderServiceHolder.get().findOpenOrderEntryForStockEntry(se);
            return availability != null;
        }

        private boolean selectFilter(IStockEntry se, String filter) {
            if (se.getArticle() != null && se.getArticle().getLabel() != null) {
                if (se.getArticle().getLabel().toLowerCase().contains(filter.toLowerCase())) {
                    return true;
                }
                if (se.getArticle().getGtin() != null && se.getArticle().getGtin().contains(filter)) {
                    return true;
                }
            }
            return false;
        }
    }

    public class StockViewComparator
    extends ViewerComparator {
        private int propertyIndex;
        private int direction = 1;

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction *= -1;
            }
            this.propertyIndex = column;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IStockEntry s1 = (IStockEntry)e1;
            IStockEntry s2 = (IStockEntry)e2;
            switch (this.propertyIndex) {
                case 0: {
                    return s1.getStock().getId().compareTo(s2.getStock().getId()) * this.direction;
                }
                case 1: {
                    String pharmco1 = s1.getArticle().getCode();
                    String pharmco2 = s2.getArticle().getCode();
                    return Objects.compare(pharmco1, pharmco2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 2: {
                    String gtin1 = s1.getArticle().getGtin();
                    String gtin2 = s2.getArticle().getGtin();
                    return Objects.compare(gtin1, gtin2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 3: {
                    String name1 = s1.getArticle().getName();
                    String name2 = s2.getArticle().getName();
                    return Objects.compare(name1, name2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 4: {
                    Money sp1 = s1.getArticle().getSellingPrice();
                    Money sp2 = s2.getArticle().getSellingPrice();
                    return Objects.compare(sp1, sp2, Comparator.nullsFirst(Comparator.naturalOrder())) * this.direction;
                }
                case 5: {
                    return Integer.compare(s1.getMinimumStock(), s2.getMinimumStock()) * this.direction;
                }
                case 6: {
                    return Integer.compare(s1.getCurrentStock(), s2.getCurrentStock()) * this.direction;
                }
                case 7: {
                    return Integer.compare(s1.getMaximumStock(), s2.getMaximumStock()) * this.direction;
                }
                case 8: {
                    String lieferant1 = "";
                    String lieferant2 = "";
                    if (s1.getProvider() != null) {
                        lieferant1 = s1.getProvider().getLabel();
                    }
                    if (s2.getProvider() != null) {
                        lieferant2 = s2.getProvider().getLabel();
                    }
                    return lieferant1.compareTo(lieferant2) * this.direction;
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

