/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.ui.util.NatTableWrapper;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.RichTextCellPainter;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.CellLayerPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.nebula.widgets.nattable.resize.AutoResizeRowPaintListener;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class NatTableFactory {
    public static NatTableWrapper createSingleColumnTable(Composite parent, IRowDataProvider<? extends Object> dataProvider, AbstractRegistryConfiguration customConfiguration) {
        NatTableWrapper natTableWrapper = new NatTableWrapper();
        DataLayer bodyDataLayer = new DataLayer(dataProvider);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyDataLayer){
            private CellLayerPainter painter = new CellLayerPainter();

            public ILayerPainter getLayerPainter() {
                return this.painter;
            }
        };
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        viewportLayer.setRegionName("BODY");
        NatTable natTable = new NatTable(parent, 538184448, (ILayer)viewportLayer, false);
        natTable.setBackground(natTable.getDisplay().getSystemColor(1));
        natTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        natTable.addConfiguration((IConfiguration)new DefaultSingleColumnStyleConfiguration());
        if (customConfiguration != null) {
            natTable.addConfiguration((IConfiguration)customConfiguration);
        }
        AutoResizeRowPaintListener resizeRowPaintListener = new AutoResizeRowPaintListener(natTable, viewportLayer, (ILayer)bodyDataLayer);
        natTable.addPaintListener((PaintListener)resizeRowPaintListener);
        natTableWrapper.setNatTable(natTable);
        natTableWrapper.setDataProvider(dataProvider);
        natTableWrapper.setSelectionLayer(selectionLayer);
        natTableWrapper.configure();
        natTable.addControlListener((ControlListener)new ResizeColumnListener(bodyDataLayer));
        return natTableWrapper;
    }

    public static class DefaultSingleColumnStyleConfiguration
    extends DefaultNatTableStyleConfiguration {
        private Style selectionStyle = new Style();

        public void configureRegistry(IConfigRegistry configRegistry) {
            this.hAlign = HorizontalAlignmentEnum.LEFT;
            super.configureRegistry(configRegistry);
            this.selectionStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)Display.getCurrent().getSystemColor(2));
            this.selectionStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)Display.getCurrent().getSystemColor(26));
            this.selectionStyle.setAttributeValue(CellStyleAttributes.FONT, (Object)GUIHelper.DEFAULT_FONT);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)this.selectionStyle, DisplayMode.SELECT, "selectionAnchor");
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)this.selectionStyle, DisplayMode.SELECT);
            this.cellPainter = new RichTextCellPainter(true, false, true);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new BackgroundPainter(this.cellPainter));
        }
    }

    private static class ResizeColumnListener
    implements ControlListener {
        private DataLayer bodyDataLayer;

        public ResizeColumnListener(DataLayer bodyDataLayer) {
            this.bodyDataLayer = bodyDataLayer;
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            if (e.widget instanceof NatTable) {
                this.bodyDataLayer.setColumnWidthByPosition(0, ((NatTable)e.widget).getBounds().width > 25 ? ((NatTable)e.widget).getBounds().width - 25 : ((NatTable)e.widget).getBounds().width);
            }
        }
    }
}

