/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.util;

import ch.elexis.core.data.service.CodeElementServiceHolder;
import ch.elexis.core.data.service.ContextServiceHolder;
import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.data.service.StoreToStringServiceHolder;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.IArticleDefaultSignature;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.IPrescription;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.builder.IPrescriptionBuilder;
import ch.elexis.core.model.prescription.EntryType;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.ICodeElementServiceContribution;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.MedicationServiceHolder;
import ch.elexis.core.ui.dialogs.PrescriptionSignatureTitleAreaDialog;
import ch.elexis.core.ui.processor.BillingProcessor;
import ch.elexis.core.ui.util.Messages;
import ch.elexis.data.PersistentObject;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class CreatePrescriptionHelper {
    public static final String MEDICATION_SETTINGS_ALWAYS_SHOW_SIGNATURE_DIALOG = "medication/settings/alwaysShowSignatureDialog";
    public static final String MEDICATION_SETTINGS_SIGNATURE_STD_DISPENSATION = "medication/settings/signatureStdDispensation";
    public static final String MEDICATION_SETTINGS_DISPENSE_ARTIKELSTAMM_CONVERT = "medication/settings/artikelstammConvert";
    private IArticle article;
    private Shell parentShell;
    private BillingProcessor billingProcessor;
    private boolean medicationTypeFix = false;

    public CreatePrescriptionHelper(IArticle article, Shell parentShell) {
        this.article = article;
        this.parentShell = parentShell;
    }

    public void setMedicationTypeFix(boolean value) {
        this.medicationTypeFix = value;
    }

    public void createPrescription() {
        Optional validationResult = ContextServiceHolder.get().getNamed("artikelstamm.selected.article.validate");
        if (validationResult.isEmpty() || Boolean.TRUE.equals(validationResult.get())) {
            Optional<IArticleDefaultSignature> defaultSignature = MedicationServiceHolder.get().getDefaultSignature(this.article);
            Optional<IArticleDefaultSignature> signature = Optional.empty();
            if (defaultSignature.isPresent()) {
                signature = defaultSignature;
                if (ConfigServiceHolder.getUser((String)MEDICATION_SETTINGS_ALWAYS_SHOW_SIGNATURE_DIALOG, (boolean)false)) {
                    signature = this.getSignatureWithDialog(defaultSignature);
                }
            } else {
                signature = this.getSignatureWithDialog(Optional.empty());
            }
            signature.ifPresent(s -> {
                IPrescription iPrescription = this.createPrescriptionFromSignature((IArticleDefaultSignature)s);
            });
        }
    }

    private Optional<IArticleDefaultSignature> getSignatureWithDialog(Optional<IArticleDefaultSignature> preSelectedSignature) {
        PrescriptionSignatureTitleAreaDialog dialog = new PrescriptionSignatureTitleAreaDialog(this.parentShell, this.article);
        dialog.setMedicationTypeFix(this.medicationTypeFix);
        preSelectedSignature.ifPresent(s -> dialog.setSignature((IArticleDefaultSignature)s));
        if (dialog.open() != 0) {
            return Optional.empty();
        }
        return Optional.of(dialog.getSignature());
    }

    public IPrescription createPrescriptionFromSignature(IArticleDefaultSignature signature) {
        EntryType disposalType;
        IPrescription prescription = (IPrescription)new IPrescriptionBuilder(CoreModelServiceHolder.get(), ContextServiceHolder.get(), this.article, (IPatient)ContextServiceHolder.get().getActivePatient().get(), signature.getSignatureAsDosisString()).build();
        prescription.setRemark(signature.getComment());
        prescription.setEntryType(signature.getMedicationType());
        if (EntryType.SYMPTOMATIC_MEDICATION.equals((Object)signature.getMedicationType()) && signature.getEndDate() != null) {
            prescription.setDateTo(signature.getEndDate().atTime(23, 59, 59));
            prescription.setStopReason("Stop geplant");
        }
        if (signature.getDisposalType() != EntryType.RECIPE && (disposalType = signature.getDisposalType()) == EntryType.SELF_DISPENSED) {
            this.selfDispense(prescription, false);
        }
        if (signature.getStartDate() != null) {
            prescription.setDateFrom(signature.getStartDate().atStartOfDay());
        }
        CoreModelServiceHolder.get().save((Identifiable)prescription);
        return prescription;
    }

    public void selfDispense(IPrescription prescription, boolean dispensation) {
        Optional encounter = ContextServiceHolder.get().getTyped(IEncounter.class);
        if (encounter.isPresent()) {
            this.billingProcessor = new BillingProcessor((IEncounter)encounter.get());
            boolean isToday = ((IEncounter)encounter.get()).getDate().equals(LocalDate.now());
            if (isToday) {
                IArticle dispensationArticle = prescription.getArticle();
                if (this.shouldUpdateToArtikelstamm() && this.isArtikelstammAvailable() && !this.isEigenartikel(dispensationArticle) && !this.isArtikelstamm(dispensationArticle)) {
                    Optional<IArticle> item = this.getArtikelstammItem(dispensationArticle);
                    if (item.isPresent()) {
                        prescription.setArticle(item.get());
                        MessageDialog.openInformation((Shell)this.parentShell, (String)Messages.CreatePrescriptionHelper_InfoDispensationArtikelstammTitel, (String)MessageFormat.format(Messages.CreatePrescriptionHelper_InfoDispensationArtikelstammUpate, dispensationArticle.getLabel(), item.get().getLabel()));
                        dispensationArticle = item.get();
                    } else {
                        MessageDialog.openError((Shell)this.parentShell, (String)Messages.CreatePrescriptionHelper_InfoDispensationArtikelstammTitel, (String)MessageFormat.format(Messages.CreatePrescriptionHelper_ErrorDispensationArtikelstammUpate, dispensationArticle.getLabel()));
                        return;
                    }
                }
                if (dispensation) {
                    result = BillingServiceHolder.get().bill((IBillable)dispensationArticle, (IEncounter)encounter.get(), 1.0);
                    if (result.isOK()) {
                        IBilled billed = (IBilled)result.get();
                        prescription.setExtInfo((Object)"verrechnetId", (Object)billed.getId().toString());
                        CoreModelServiceHolder.get().save((Identifiable)prescription);
                        this.billingProcessor.updatePrescriptionsWithDosage(billed);
                        ContextServiceHolder.get().postEvent("info/elexis/model/update", encounter.get());
                        return;
                    }
                } else if (!this.isArticleAlreadyBilled(dispensationArticle, (IEncounter)encounter.get())) {
                    result = BillingServiceHolder.get().bill((IBillable)dispensationArticle, (IEncounter)encounter.get(), 1.0);
                    if (result.isOK()) {
                        IBilled billed = (IBilled)result.get();
                        prescription.setExtInfo((Object)"verrechnetId", (Object)billed.getId().toString());
                        CoreModelServiceHolder.get().save((Identifiable)prescription);
                        this.billingProcessor.updatePrescriptionsWithDosage(billed);
                        ContextServiceHolder.get().postEvent("info/elexis/model/update", encounter.get());
                        return;
                    }
                    MessageDialog.openError((Shell)this.parentShell, (String)"Fehler bei der Verrechnung", (String)result.toString());
                } else {
                    return;
                }
            }
        }
        MessageDialog.openWarning((Shell)this.parentShell, (String)Messages.CreatePrescriptionHelper_WarninigNoConsTitle, (String)Messages.CreatePrescriptionHelper_WarninigNoConsText);
    }

    private boolean isArticleAlreadyBilled(IArticle article, IEncounter encounter) {
        return encounter.getBilled().stream().anyMatch(billed -> billed.getBillable() instanceof IArticle && ((IArticle)billed.getBillable()).getId().equals(article.getId()));
    }

    private boolean shouldUpdateToArtikelstamm() {
        return ConfigServiceHolder.getUser((String)MEDICATION_SETTINGS_DISPENSE_ARTIKELSTAMM_CONVERT, (boolean)false);
    }

    private boolean isEigenartikel(IArticle dispensationArticle) {
        return dispensationArticle.getCodeSystemName().equals("Eigenartikel");
    }

    private boolean isArtikelstamm(IArticle dispensationArticle) {
        return StoreToStringServiceHolder.getStoreToString((Object)dispensationArticle).startsWith("ch.artikelstamm.elexis.common.ArtikelstammItem");
    }

    private boolean isArtikelstammAvailable() {
        return PersistentObject.tableExists((String)"ARTIKELSTAMM_CH");
    }

    private Optional<IArticle> getArtikelstammItem(IArticle dispensationArticle) {
        String possiblePharma;
        String gtin = dispensationArticle.getGtin();
        Optional<IArticle> ret = Optional.empty();
        if (gtin != null && !gtin.isEmpty()) {
            ret = this.loadArtikelWithCode(gtin);
        }
        if (!ret.isPresent() && (possiblePharma = dispensationArticle.getCode()) != null && !possiblePharma.isEmpty()) {
            ret = this.loadArtikelWithCode(possiblePharma);
        }
        return ret;
    }

    private Optional<IArticle> loadArtikelWithCode(String gtin) {
        Optional contribution = CodeElementServiceHolder.get().getContribution(ICodeElementService.CodeElementTyp.ARTICLE, "Artikelstamm");
        if (contribution.isPresent()) {
            Optional loadedArticle = ((ICodeElementServiceContribution)contribution.get()).loadFromCode(gtin, Collections.emptyMap());
            if (loadedArticle.isPresent()) {
                return Optional.of((IArticle)loadedArticle.get());
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("No Artikelstamm ICodeElementServiceContribution available");
        }
        return Optional.empty();
    }
}

