/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.locks;

import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.lock.types.LockInfo;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.ui.locks.LockResponseHelper;
import ch.elexis.data.PersistentObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AllOrNoneLockRequestingAction<T extends PersistentObject>
extends Action {
    private Logger log = LoggerFactory.getLogger(AllOrNoneLockRequestingAction.class);
    private List<T> objects;

    public AllOrNoneLockRequestingAction(String text) {
        super(text);
        this.setEnabled(true);
    }

    public void run() {
        this.objects = this.getTargetedObjects();
        if (this.objects == null || this.objects.isEmpty()) {
            return;
        }
        ArrayList<LockInfo> acquiredLocks = new ArrayList<LockInfo>();
        for (PersistentObject object : this.objects) {
            LockResponse lr = LocalLockServiceHolder.get().acquireLock((Object)object);
            if (lr.isOk()) {
                acquiredLocks.add(lr.getLockInfo());
                continue;
            }
            LockResponseHelper.showInfo(lr, object, this.log);
            this.releaseAllAcquiredLocks(acquiredLocks);
            return;
        }
        this.doRun(this.objects);
        this.releaseAllAcquiredLocks(acquiredLocks);
    }

    private void releaseAllAcquiredLocks(List<LockInfo> acquiredLocks) {
        for (LockInfo lockInfo : acquiredLocks) {
            LockResponse lockResponse = LocalLockServiceHolder.get().releaseLock(lockInfo);
            if (lockResponse.isOk()) continue;
            this.log.warn("Could not release lock for [{}] with lock response [{}]", (Object)(lockInfo.getElementType() + "::" + lockInfo.getElementId()), (Object)lockResponse.getStatus());
        }
    }

    public abstract List<T> getTargetedObjects();

    public abstract void doRun(List<T> var1);
}

