/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.exchange.elements;

import ch.elexis.core.ui.exchange.XChangeExporter;
import ch.elexis.core.ui.exchange.elements.FindingElement;
import ch.elexis.core.ui.exchange.elements.MedicalElement;
import ch.elexis.core.ui.exchange.elements.XChangeElement;
import ch.elexis.data.LabItem;
import ch.elexis.data.LabResult;
import ch.rgw.tools.TimeTool;
import ch.rgw.tools.XMLTool;
import java.util.List;

public class ResultElement
extends XChangeElement {
    public static final String XMLNAME = "result";
    public static final String ATTR_DATE = "timestamp";
    public static final String ATTR_NORMAL = "isNormal";
    public static final String ATTR_LABITEM = "findingRef";
    public static final String ELEMENT_META = "meta";
    public static final String ATTRIB_CREATOR = "creator";
    public static final String ELEMENT_IMAGE = "image";
    public static final String ELEMENT_TEXTRESULT = "textResult";
    public static final String ELEMENT_DOCRESULT = "documentRef";

    @Override
    public String getXMLName() {
        return XMLNAME;
    }

    public static ResultElement addResult(MedicalElement me, LabResult lr) {
        FindingElement fe2;
        List<FindingElement> findings = me.getAnalyses();
        for (FindingElement fe2 : findings) {
            if (!fe2.getXid().getID().equals(XMLTool.idToXMLID((String)lr.getItem().getId()))) continue;
            ResultElement re = new ResultElement().asExporter(me.sender, lr);
            me.addAnalyse(re);
            return re;
        }
        fe2 = new FindingElement().asExporter(me.sender, (LabItem)lr.getItem());
        me.addFindingItem(fe2);
        ResultElement re = new ResultElement().asExporter(me.sender, lr);
        me.addAnalyse(re);
        return re;
    }

    private ResultElement asExporter(XChangeExporter home, LabResult lr) {
        this.asExporter(home);
        this.setAttribute("id", XMLTool.idToXMLID((String)lr.getId()));
        this.setAttribute(ATTR_DATE, new TimeTool(lr.getDate()).toString(14));
        this.setAttribute(ATTR_LABITEM, XMLTool.idToXMLID((String)lr.getItem().getId()));
        ResultElement eResult = new ResultElement();
        eResult.setText(lr.getResult());
        this.add(eResult);
        home.getContainer().addChoice(this, lr.getLabel(), (Object)lr);
        return this;
    }

    public void setText(String text) {
    }
}

