/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.eigenleistung;

import ch.elexis.core.model.ICustomService;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.views.IDetailDisplay;
import ch.elexis.data.Eigenleistung;
import ch.elexis.data.PersistentObject;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;

public class EigenleistungDetailDisplay
implements IDetailDisplay {
    private Text textTarif;
    private Text textCode;
    private Text textBezeichnung;
    private Text textEKP;
    private Text textVKP;
    private Text textZeit;

    @Inject
    public void selection(@Optional @Named(value="ch.elexis.core.ui.eigenleistung.selection") ICustomService customService) {
        if (this.textCode != null && !this.textCode.isDisposed()) {
            this.display(customService);
        }
    }

    @Override
    public Composite createDisplay(Composite parent, IViewSite site) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        Label lblTarif = new Label(ret, 0);
        lblTarif.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTarif.setText("Tarif");
        this.textTarif = new Text(ret, 2048);
        this.textTarif.setData("TEST_COMP_NAME", (Object)"EigenleistungDetailTarif_txt");
        this.textTarif.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textTarif.setTextLimit(20);
        this.textTarif.setEditable(false);
        Label lblCode = new Label(ret, 0);
        lblCode.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCode.setText("K\u00fcrzel (Code)");
        this.textCode = new Text(ret, 2048);
        this.textCode.setData("TEST_COMP_NAME", (Object)"EigenleistungDetailCode_txt");
        this.textCode.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textCode.setTextLimit(20);
        this.textCode.setEditable(false);
        Label lblBezeichnung = new Label(ret, 0);
        lblBezeichnung.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblBezeichnung.setText("Bezeichnung");
        this.textBezeichnung = new Text(ret, 2050);
        this.textBezeichnung.setData("TEST_COMP_NAME", (Object)"EigenleistungDetailName_txt");
        this.textBezeichnung.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textBezeichnung.setTextLimit(80);
        this.textBezeichnung.setEditable(false);
        Label lblEKP = new Label(ret, 0);
        lblEKP.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblEKP.setText("Einkaufspreis (Rp.)");
        this.textEKP = new Text(ret, 2048);
        this.textEKP.setData("TEST_COMP_NAME", (Object)"EigenleistungDetailEKP_txt");
        this.textEKP.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textEKP.setTextLimit(6);
        this.textEKP.setEditable(false);
        Label lblVKP = new Label(ret, 0);
        lblVKP.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblVKP.setText("Verkaufspreis (Rp.)");
        this.textVKP = new Text(ret, 2048);
        this.textVKP.setData("TEST_COMP_NAME", (Object)"EigenleistungDetailVKP_txt");
        this.textVKP.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textVKP.setTextLimit(6);
        this.textVKP.setEditable(false);
        Label lblZeit = new Label(ret, 0);
        lblZeit.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblZeit.setText("Zeitbedarf");
        this.textZeit = new Text(ret, 2048);
        this.textZeit.setData("TEST_COMP_NAME", (Object)"EigenleistungDetailZeit_txt");
        this.textZeit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.textZeit.setTextLimit(4);
        this.textZeit.setEditable(false);
        return null;
    }

    public Class<? extends PersistentObject> getElementClass() {
        return Eigenleistung.class;
    }

    @Override
    public void display(Object obj) {
        if (obj instanceof ICustomService) {
            ICustomService customService = (ICustomService)obj;
            this.textTarif.setText(customService.getCodeSystemCode());
            this.textCode.setText((String)CoreModelServiceHolder.get().getEntityProperty("code", (Identifiable)customService));
            this.textBezeichnung.setText(customService.getText());
            this.textEKP.setText(customService.getNetPrice().getCentsAsString());
            this.textVKP.setText(customService.getPrice().getCentsAsString());
            this.textZeit.setText(Integer.toString(customService.getMinutes()));
        } else {
            this.textTarif.setText("");
            this.textCode.setText("");
            this.textBezeichnung.setText("");
            this.textEKP.setText("");
            this.textVKP.setText("");
            this.textZeit.setText("");
        }
    }

    @Override
    public String getTitle() {
        return "Eigenleistung";
    }
}

