/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.ui.util.SWTHelper;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextTemplateImportConflictDialog
extends TitleAreaDialog {
    private String name;
    private Button btnReplace;
    private Button btnChangeName;
    private Button btnSkip;
    private Text txtNewName;
    private String newFilename;
    private boolean replaceTemplate;
    private boolean changeTemplateName;
    private boolean skipTemplate;

    public TextTemplateImportConflictDialog(Shell parentShell, String name) {
        super(parentShell);
        this.name = name;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayout((Layout)new GridLayout(1, false));
        area.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.setMessage("Eine Vorlage mit dem Namen '" + this.name + "' besteht bereits. Wie soll vorgegangen werden?");
        this.setTitle("Vorlage existiert bereits");
        this.btnReplace = new Button(area, 16);
        this.btnReplace.setText("Ersetzen (Bestehende Vorlage wird \u00fcberschrieben)");
        this.btnReplace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTemplateImportConflictDialog.this.clearAndDisableTextField();
            }
        });
        this.btnChangeName = new Button(area, 16);
        this.btnChangeName.setText("Name der Vorlage \u00e4ndern zu");
        this.btnChangeName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTemplateImportConflictDialog.this.txtNewName.setEnabled(true);
            }
        });
        this.txtNewName = new Text(area, 2048);
        this.txtNewName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtNewName.setEnabled(false);
        this.btnSkip = new Button(area, 16);
        this.btnSkip.setText("Vorlage nicht importieren");
        this.btnSkip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTemplateImportConflictDialog.this.clearAndDisableTextField();
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "OK", true);
    }

    private void clearAndDisableTextField() {
        this.txtNewName.setText("");
        this.txtNewName.setEnabled(false);
    }

    protected void okPressed() {
        if (this.btnChangeName.getSelection()) {
            if (this.txtNewName.getText().isEmpty()) {
                SWTHelper.alert("Fehlende Bezeichnung", "Neuer Name der Vorlage muss definiert werden!");
                return;
            }
            this.newFilename = this.txtNewName.getText();
        }
        this.replaceTemplate = this.btnReplace.getSelection();
        this.changeTemplateName = this.btnChangeName.getSelection();
        this.skipTemplate = this.btnSkip.getSelection();
        super.okPressed();
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }

    public boolean doReplaceTemplate() {
        return this.replaceTemplate;
    }

    public boolean doChangeTemplateName() {
        return this.changeTemplateName;
    }

    public boolean doSkipTemplate() {
        return this.skipTemplate;
    }

    public String getNewName() {
        return this.newFilename;
    }
}

