/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.viewers.PersistentObjectLabelProvider;
import ch.elexis.data.Reminder;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class ReminderListSelectionDialog
extends ListSelectionDialog {
    private Label detailLabel;
    private Composite detail;

    public ReminderListSelectionDialog(List<Reminder> input, String message) {
        super(UiDesk.getTopShell(), input, (IStructuredContentProvider)ArrayContentProvider.getInstance(), (ILabelProvider)PersistentObjectLabelProvider.getInstance(), Messages.ReminderListSelectionDialog_SelectToClose);
        this.setTitle(message);
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.detail = new Composite(parent, 0);
        this.detail.setLayout((Layout)new FillLayout(256));
        this.detailLabel = new Label(this.detail, 0);
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                StringBuilder sb = new StringBuilder();
                if (!arg0.getSelection().isEmpty()) {
                    Reminder reminder = (Reminder)((IStructuredSelection)arg0.getSelection()).getFirstElement();
                    sb.append("    " + reminder.getSubject() + "\n");
                    sb.append("    " + reminder.getMessage());
                }
                ReminderListSelectionDialog.this.detailLabel.setText(sb.toString());
                ReminderListSelectionDialog.this.detail.getParent().layout();
            }
        });
        List reminders = (List)this.getViewer().getInput();
        if (!reminders.isEmpty()) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(reminders.get(0)));
        }
        return control;
    }

    protected void okPressed() {
        Object[] result;
        super.okPressed();
        Object[] objectArray = result = this.getResult();
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Reminder reminder = (Reminder)object;
            reminder.setProcessStatus(ProcessStatus.CLOSED);
            ++n2;
        }
    }

    protected Point getInitialSize() {
        return new Point(600, 300);
    }
}

