/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.ui.dialogs.Messages;
import ch.rgw.tools.TimeTool;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DateTimeSelectorDialog
extends Dialog {
    private TimeTool date;
    private DateTime timeSelection;
    private DateTime dateSelection;
    private TimeTool ret;
    private boolean showAsCalendar;

    public DateTimeSelectorDialog(Shell parent, TimeTool date) {
        super(parent);
        this.date = date;
    }

    public DateTimeSelectorDialog(Shell parent, TimeTool date, boolean showAsCalendar) {
        super(parent);
        this.date = date;
        this.showAsCalendar = showAsCalendar;
    }

    public DateTimeSelectorDialog(Shell parentShell) {
        this(parentShell, new TimeTool());
    }

    protected Control createDialogArea(Composite parent) {
        if (this.showAsCalendar) {
            return this.createCalendarArea(parent);
        }
        return this.createDefaultArea(parent);
    }

    private Composite createCalendarArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gd = new GridLayout(1, false);
        gd.marginLeft = 2;
        composite.setLayout((Layout)gd);
        this.dateSelection = new DateTime(composite, 1024);
        this.dateSelection.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        Composite dateComposite = new Composite(composite, 0);
        dateComposite.setLayout((Layout)new GridLayout(2, true));
        dateComposite.setLayoutData((Object)new GridData(768));
        Label label = new Label(dateComposite, 0);
        label.setText("Zeitpunkt");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.timeSelection = new DateTime(dateComposite, 128);
        this.timeSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.timeSelection.setTime(this.date.get(11), this.date.get(12), this.date.get(13));
        this.dateSelection.setDate(this.date.get(1), this.date.get(2), this.date.get(5));
        this.getShell().setText(Messages.DateTimeSelectorDialog_enterDate);
        return composite;
    }

    private Composite createDefaultArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText("Zeitpunkt");
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        Composite dateComposite = new Composite(composite, 0);
        dateComposite.setLayout((Layout)new GridLayout(2, true));
        dateComposite.setLayoutData((Object)new GridData(768));
        this.timeSelection = new DateTime(dateComposite, 128);
        this.timeSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.dateSelection = new DateTime(dateComposite, 1024);
        this.dateSelection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.timeSelection.setTime(this.date.get(11), this.date.get(12), this.date.get(13));
        this.dateSelection.setDate(this.date.get(1), this.date.get(2), this.date.get(5));
        this.getShell().setText(Messages.DateTimeSelectorDialog_enterDate);
        return composite;
    }

    protected void okPressed() {
        this.ret = new TimeTool();
        this.getTime(this.timeSelection, this.ret);
        this.getDate(this.dateSelection, this.ret);
        super.okPressed();
    }

    public TimeTool getSelectedDate() {
        return this.ret;
    }

    private void getTime(DateTime widget, TimeTool time) {
        time.set(11, widget.getHours());
        time.set(12, widget.getMinutes());
        time.set(13, widget.getSeconds());
    }

    private void getDate(DateTime widget, TimeTool date) {
        date.set(1, widget.getYear());
        date.set(2, widget.getMonth());
        date.set(5, widget.getDay());
    }
}

