/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.service.CoreModelServiceHolder;
import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.model.IPerson;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.types.Gender;
import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.dialogs.KontaktErfassenDialog;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.dialogs.provider.ContactSelectionLabelProvider;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.util.viewers.CommonViewer;
import ch.elexis.core.ui.util.viewers.CommonViewerContentProvider;
import ch.elexis.core.ui.util.viewers.DefaultControlFieldProvider;
import ch.elexis.core.ui.util.viewers.SimpleWidgetProvider;
import ch.elexis.core.ui.util.viewers.ViewerConfigurer;
import ch.elexis.data.BezugsKontakt;
import ch.elexis.data.Kontakt;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.StringTool;
import ch.rgw.tools.TimeTool;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ContactSelectionDialog
extends TitleAreaDialog
implements CommonViewer.PoDoubleClickListener {
    public static final int HINTSIZE = 12;
    public static final int HINT_NAME = 0;
    public static final int HINT_FIRSTNAME = 1;
    public static final int HINT_BIRTHDATE = 2;
    public static final int HINT_STREET = 3;
    public static final int HINT_ZIP = 4;
    public static final int HINT_PLACE = 5;
    public static final int HINT_PHONE = 6;
    public static final int HINT_ADD = 7;
    public static final int HINT_FAX = 8;
    public static final int HINT_MAIL = 9;
    public static final int HINT_SEX = 10;
    public static final int HINT_PATIENT = 11;
    CommonViewer commonViewer;
    ViewerConfigurer vc;
    private final String title;
    private final String message;
    private Object selection;
    Button bAll;
    Button bPersons;
    Button bOrgs;
    FilterButtonAdapter fba;
    String[] hints;
    boolean showBezugsKontakt = false;
    String extraText = null;
    private ListViewer bezugsKontaktViewer = null;
    private boolean isSelecting = false;
    private final ContactContentProvider contentProvider;
    private boolean enableEmptyField = false;
    private Set<String> allowedContactIds = null;
    private Class<? extends Identifiable> targetClass;

    public ContactSelectionDialog(Shell parentShell, Class<? extends Identifiable> which, String title, String message, String ... orderFields) {
        super(parentShell);
        this.targetClass = which;
        this.commonViewer = new CommonViewer();
        this.fba = new FilterButtonAdapter();
        this.title = title;
        this.message = message;
        this.contentProvider = new ContactContentProvider(this.commonViewer);
        this.contentProvider.setOrderFields(orderFields);
    }

    public ContactSelectionDialog(Shell parentShell, Class<? extends Identifiable> which, String t, String m, boolean showBezugsKontakt, String ... orderFields) {
        this(parentShell, which, t, m, orderFields);
        this.showBezugsKontakt = showBezugsKontakt;
    }

    public ContactSelectionDialog(Shell parentShell, Class<? extends Identifiable> which, String t, String m, String extra, String ... orderFields) {
        this(parentShell, which, t, m, orderFields);
        this.extraText = extra;
    }

    public boolean close() {
        this.commonViewer.removeDoubleClickListener(this);
        this.commonViewer.dispose();
        return super.close();
    }

    public void setHints(String[] h) {
        this.hints = h;
        int i = 0;
        while (i < this.hints.length) {
            if (this.hints[i] == null) {
                this.hints[i] = "";
            }
            ++i;
        }
        if (!StringUtils.isBlank((CharSequence)this.hints[2])) {
            TimeTool tt = new TimeTool();
            this.hints[2] = tt.set(this.hints[2]) ? tt.toString(4) : "";
        }
        if (!StringTool.isNothing((Object)this.hints[10])) {
            this.hints[10] = this.hints[10].toLowerCase().startsWith("m") ? Gender.MALE.value() : Gender.FEMALE.value();
        }
    }

    private String[] getFilterStrings() {
        String[] ret = new String[]{};
        if (this.targetClass.equals(IContact.class)) {
            ret = new String[]{"code=" + Messages.Core_Kuerzel, "description1=" + Messages.Core_Description};
        } else if (IPerson.class.isAssignableFrom(this.targetClass)) {
            ret = new String[]{"code=" + Messages.Core_Kuerzel, "description1=Nachname", "dob=" + Messages.Core_Enter_Birthdate};
        } else if (IOrganization.class.isAssignableFrom(this.targetClass)) {
            ret = new String[]{"code=" + Messages.Core_Kuerzel, "description1=" + Messages.Core_Description};
        }
        return ret;
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout());
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        this.bezugsKontaktViewer = null;
        if (this.showBezugsKontakt) {
            new Label(ret, 0).setText("Andere Kontakte");
        }
        if (this.extraText != null) {
            new Label(ret, 64).setText(this.extraText);
        }
        this.vc = new ViewerConfigurer(this.contentProvider, new ContactSelectionLabelProvider(), new DefaultControlFieldProvider(this.commonViewer, this.getFilterStrings()), new ViewerConfigurer.ButtonProvider(){

            @Override
            public Button createButton(final Composite parent) {
                Button ret = new Button(parent, 8);
                ret.setText("Neu erstellen...");
                ret.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if ((this).ContactSelectionDialog.this.hints == null) {
                            (this).ContactSelectionDialog.this.hints = new String[3];
                            (this).ContactSelectionDialog.this.hints[0] = (this).ContactSelectionDialog.this.vc.getControlFieldProvider().getValues()[1];
                        }
                        KontaktErfassenDialog ked = new KontaktErfassenDialog(parent.getShell(), (this).ContactSelectionDialog.this.hints);
                        ked.open();
                        (this).ContactSelectionDialog.this.selection = ked.getResult();
                        ContactSelectionDialog.this.okPressed();
                    }
                });
                return ret;
            }

            @Override
            public boolean isAlwaysEnabled() {
                return false;
            }
        }, new SimpleWidgetProvider(3, 0, this.commonViewer));
        Composite types = new Composite(ret, 2048);
        types.setLayout((Layout)new FillLayout());
        types.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, false));
        this.bAll = new Button(types, 16);
        this.bPersons = new Button(types, 16);
        this.bOrgs = new Button(types, 16);
        this.bAll.setText("Alle");
        this.bPersons.setText("Personen");
        this.bOrgs.setText("Organisationen");
        this.bAll.addSelectionListener((SelectionListener)this.fba);
        this.bPersons.addSelectionListener((SelectionListener)this.fba);
        this.bOrgs.addSelectionListener((SelectionListener)this.fba);
        this.initContactTypeSelection();
        this.commonViewer.create(this.vc, ret, 0, "1");
        GridData gd = SWTHelper.getFillGridData(1, true, 1, true);
        gd.heightHint = 100;
        this.commonViewer.getViewerWidget().getControl().setLayoutData((Object)gd);
        this.setTitle(this.title);
        this.setMessage(this.message);
        this.vc.getContentProvider().startListening();
        this.commonViewer.addDoubleClickListener(this);
        if (this.showBezugsKontakt) {
            this.commonViewer.getViewerWidget().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel;
                    if (ContactSelectionDialog.this.isSelecting) {
                        return;
                    }
                    if (ContactSelectionDialog.this.bezugsKontaktViewer != null && (sel = (IStructuredSelection)ContactSelectionDialog.this.bezugsKontaktViewer.getSelection()).size() > 0) {
                        ContactSelectionDialog.this.isSelecting = true;
                        ContactSelectionDialog.this.bezugsKontaktViewer.setSelection((ISelection)new StructuredSelection(), false);
                        ContactSelectionDialog.this.isSelecting = false;
                    }
                }
            });
        }
        return ret;
    }

    private void initContactTypeSelection() {
        if (IPerson.class.isAssignableFrom(this.targetClass)) {
            this.bPersons.setSelection(true);
        } else if (IOrganization.class.isAssignableFrom(this.targetClass)) {
            this.bOrgs.setSelection(true);
        } else {
            this.bAll.setSelection(true);
        }
    }

    public Object getSelection() {
        return this.selection;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.Core_Select_Contact);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.enableEmptyField) {
            parent.setLayout((Layout)new GridLayout(3, false));
            Button btnClear = this.createButton(parent, 3, Messages.KontaktSelector_clearField, false);
            btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ContactSelectionDialog.this.selection = null;
                    ContactSelectionDialog.this.vc.getContentProvider().stopListening();
                    ContactSelectionDialog.this.close();
                }
            });
        } else {
            parent.setLayout((Layout)new GridLayout(2, false));
        }
        this.createButton(parent, 0, "OK", false);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected void cancelPressed() {
        this.selection = null;
        this.vc.getContentProvider().stopListening();
        super.cancelPressed();
    }

    private Object getBezugsKontaktSelection() {
        IStructuredSelection sel;
        Object bezugsKontakt = null;
        if (this.bezugsKontaktViewer != null && (sel = (IStructuredSelection)this.bezugsKontaktViewer.getSelection()).size() > 0) {
            bezugsKontakt = sel.getFirstElement();
        }
        return bezugsKontakt;
    }

    protected void okPressed() {
        Object bKSel = this.getBezugsKontaktSelection();
        if (bKSel instanceof Kontakt) {
            this.selection = bKSel;
        } else if (bKSel instanceof BezugsKontakt) {
            BezugsKontakt bezugsKontakt = (BezugsKontakt)bKSel;
            Kontakt kontakt = Kontakt.load((String)bezugsKontakt.get("otherID"));
            if (kontakt.exists()) {
                this.selection = kontakt;
            }
        } else if (this.selection == null) {
            Object[] sel = this.commonViewer.getSelection();
            if (sel != null && sel.length > 0) {
                this.selection = sel[0];
            } else {
                Table tbl = (Table)this.commonViewer.getViewerWidget().getControl();
                tbl.setSelection(0);
                if (this.commonViewer.getSelection().length > 0) {
                    this.selection = this.commonViewer.getSelection()[0];
                }
            }
        }
        this.vc.getContentProvider().stopListening();
        this.commonViewer.removeDoubleClickListener(this);
        super.okPressed();
    }

    @Override
    public void doubleClicked(PersistentObject obj, CommonViewer cv) {
        this.okPressed();
    }

    public static IContact showInSync(Class<? extends IContact> clazz, String title, String message, String extra) {
        InSync rn = new InSync(clazz, title, message, extra, null, new String[0]);
        UiDesk.getDisplay().syncExec((Runnable)rn);
        return rn.ret;
    }

    public static IContact showInSync(Class<? extends IContact> clazz, String title, String message) {
        InSync rn = new InSync(clazz, title, message, null, null, new String[0]);
        UiDesk.getDisplay().syncExec((Runnable)rn);
        return rn.ret;
    }

    public static IContact showInSync(Class<? extends IContact> clazz, String title, String message, String extra, String[] hints) {
        InSync rn = new InSync(clazz, title, message, extra, hints, new String[0]);
        UiDesk.getDisplay().syncExec((Runnable)rn);
        return rn.ret;
    }

    public static IContact showInSync(Class<? extends IContact> clazz, String title, String message, String[] hints) {
        InSync rn = new InSync(clazz, title, message, null, hints, new String[0]);
        UiDesk.getDisplay().syncExec((Runnable)rn);
        return rn.ret;
    }

    public void enableEmptyFieldButton() {
        this.enableEmptyField = true;
    }

    public void setAllowedContacts(List<IContact> allowedContacts) {
        this.allowedContactIds = allowedContacts == null ? null : allowedContacts.stream().filter(Objects::nonNull).map(Identifiable::getId).collect(Collectors.toSet());
    }

    private class ContactContentProvider
    extends CommonViewerContentProvider
    implements IStructuredContentProvider {
        public ContactContentProvider(CommonViewer commonViewer) {
            super(commonViewer);
        }

        @Override
        protected IQuery<?> getBaseQuery() {
            return CoreModelServiceHolder.get().getQuery(ContactSelectionDialog.this.targetClass);
        }

        public Object[] getElements(Object inputElement) {
            List<Identifiable> roots = Collections.emptyList();
            IQuery<?> query = this.getBaseQuery();
            if (this.hasActiveFilter(this.fieldFilterValues)) {
                query.startGroup();
                for (String key : this.fieldFilterValues.keySet()) {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)this.fieldFilterValues.get(key)))) continue;
                    query.and(key, IQuery.COMPARATOR.LIKE, (Object)("%" + (String)this.fieldFilterValues.get(key) + "%"));
                }
                query.andJoinGroups();
            }
            if (this.fieldOrderBy != null) {
                query.orderBy(this.fieldOrderBy, this.fieldOrder);
            } else if (this.orderFields != null && this.orderFields.length > 0) {
                String[] stringArray = this.orderFields;
                int n = this.orderFields.length;
                int n2 = 0;
                while (n2 < n) {
                    String field = stringArray[n2];
                    query.orderBy(field, this.fieldOrder);
                    ++n2;
                }
            }
            roots = query.execute();
            if (ContactSelectionDialog.this.allowedContactIds != null && !ContactSelectionDialog.this.allowedContactIds.isEmpty()) {
                roots = roots.stream().filter(ident -> ContactSelectionDialog.this.allowedContactIds.contains(ident.getId())).toList();
            }
            return roots.toArray();
        }

        private boolean hasActiveFilter(Map<String, String> fieldFilterValues) {
            if (fieldFilterValues != null && !fieldFilterValues.isEmpty()) {
                for (String key : fieldFilterValues.keySet()) {
                    String value = fieldFilterValues.get(key);
                    if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    class FilterButtonAdapter
    extends SelectionAdapter {
        FilterButtonAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (((Button)e.getSource()).getSelection()) {
                ContactSelectionDialog.this.targetClass = ContactSelectionDialog.this.bPersons.getSelection() ? IPerson.class : (ContactSelectionDialog.this.bOrgs.getSelection() ? IOrganization.class : IContact.class);
                ViewerConfigurer.ControlFieldProvider controlFieldProvider = ContactSelectionDialog.this.commonViewer.getConfigurer().getControlFieldProvider();
                if (controlFieldProvider instanceof DefaultControlFieldProvider) {
                    ((DefaultControlFieldProvider)controlFieldProvider).updateFields(ContactSelectionDialog.this.getFilterStrings(), true);
                    ContactSelectionDialog.this.getShell().layout(true, true);
                }
                ContactSelectionDialog.this.commonViewer.notify(CommonViewer.Message.update);
            }
        }
    }

    private static class InSync
    implements Runnable {
        IContact ret;
        String title;
        String message;
        Class<? extends IContact> clazz;
        String extra;
        String[] hints;
        private String[] orderFields;

        InSync(Class<? extends IContact> clazz, String title, String message, String extra, String[] hints, String ... orderFields) {
            this.title = title;
            this.message = message;
            this.clazz = clazz;
            this.extra = extra;
            this.hints = hints;
            this.orderFields = orderFields;
            if (orderFields == null) {
                this.orderFields = new String[]{ModelPackage.Literals.ICONTACT__DESCRIPTION1.getName(), ModelPackage.Literals.ICONTACT__DESCRIPTION2.getName(), ModelPackage.Literals.ICONTACT__STREET.getName(), ModelPackage.Literals.ICONTACT__CITY.getName()};
            }
        }

        @Override
        public void run() {
            Shell shell = UiDesk.getDisplay().getActiveShell();
            ContactSelectionDialog ksl = new ContactSelectionDialog(shell, (Class<? extends Identifiable>)this.clazz, this.title, this.message, this.extra, this.orderFields);
            if (this.hints != null) {
                ksl.setHints(this.hints);
            }
            this.ret = ksl.open() == 0 ? (IContact)ksl.getSelection() : null;
        }
    }
}

