/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.util.BillingUtil;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.EncounterServiceHolder;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.e4.fieldassist.PatientSearchToken;
import ch.elexis.core.ui.util.MoneyInput;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.controls.DaysOrDateSelectionComposite;
import ch.elexis.core.ui.views.controls.GenericSelectionComposite;
import ch.elexis.core.ui.views.controls.KontaktSelectionComposite;
import ch.elexis.core.ui.views.controls.TimeSpanSelectionComposite;
import ch.elexis.data.BillingSystem;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.Kontakt;
import ch.elexis.data.Mandant;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.IFilter;
import ch.rgw.tools.Money;
import ch.rgw.tools.TimeSpan;
import ch.rgw.tools.TimeTool;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.LoggerFactory;

public class BillingProposalWizardDialog
extends TitleAreaDialog {
    private List<Konsultation> proposal;
    private boolean series;
    private Button insurerOnly;
    private KontaktSelectionComposite insurerSelection;
    private Button timeSpanOnly;
    private TimeSpanSelectionComposite timeSpanSelection;
    private Button beforeTimeOnly;
    private FilterByMoneyComposite filterSeriesByMoneyComposite;
    private FilterByMoneyComposite filterKonsByMoneyComposite;
    private DaysOrDateSelectionComposite beforeDaysOrDate;
    private Button converageMarkedOnly;
    private Button mandatorOnly;
    private GenericSelectionComposite mandatorSelector;
    private Button patientOnly;
    private GenericSelectionComposite patientSelector;
    private Button accountingOnly;
    private GenericSelectionComposite accountingSelector;
    private Button errorneousOnly;

    public BillingProposalWizardDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Rechnungs-Vorschlag Auswahl");
        this.setMessage(Messages.KonsZumVerrechnenWizardDialog_createProposal);
        this.getShell().setText("Rechnungs-Vorschlag");
    }

    protected Control createDialogArea(Composite parent) {
        Composite ret = (Composite)super.createDialogArea(parent);
        Composite content = new Composite(ret, 0);
        content.setLayout((Layout)new GridLayout(2, false));
        content.setLayoutData((Object)new GridData(1808));
        this.timeSpanOnly = new Button(content, 32);
        this.timeSpanOnly.setText("Offene Konsultationen innerhalb des Zeitraums");
        this.timeSpanOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BillingProposalWizardDialog.this.timeSpanOnly.getSelection()) {
                    BillingProposalWizardDialog.this.beforeTimeOnly.setSelection(false);
                }
                BillingProposalWizardDialog.this.filterKonsByMoneyComposite.changeVisibility(BillingProposalWizardDialog.this.timeSpanOnly.getSelection());
            }
        });
        this.timeSpanSelection = new TimeSpanSelectionComposite(content, 0);
        this.timeSpanSelection.setLayoutData(new GridData(131072, 0x1000000, true, false));
        this.timeSpanSelection.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    BillingProposalWizardDialog.this.timeSpanOnly.setSelection(true);
                    BillingProposalWizardDialog.this.beforeTimeOnly.setSelection(false);
                } else {
                    BillingProposalWizardDialog.this.timeSpanOnly.setSelection(false);
                }
            }
        });
        LocalDate dateNow = LocalDate.now();
        this.timeSpanSelection.setTimeSpan(new TimeSpan(new TimeTool(dateNow.withDayOfMonth(1)), new TimeTool(dateNow)));
        this.filterKonsByMoneyComposite = new FilterByMoneyComposite(content, false);
        this.beforeTimeOnly = new Button(content, 32);
        this.beforeTimeOnly.setText("Offene Behandlungsserien vor Tagen oder Datum");
        this.beforeTimeOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (BillingProposalWizardDialog.this.beforeTimeOnly.getSelection()) {
                    BillingProposalWizardDialog.this.timeSpanOnly.setSelection(false);
                }
                BillingProposalWizardDialog.this.filterSeriesByMoneyComposite.changeVisibility(BillingProposalWizardDialog.this.beforeTimeOnly.getSelection());
            }
        });
        this.beforeDaysOrDate = new DaysOrDateSelectionComposite(content, 0);
        this.beforeDaysOrDate.setLayoutData(new GridData(131072, 0x1000000, true, false));
        this.beforeDaysOrDate.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    BillingProposalWizardDialog.this.beforeTimeOnly.setSelection(true);
                    BillingProposalWizardDialog.this.timeSpanOnly.setSelection(false);
                } else {
                    BillingProposalWizardDialog.this.beforeTimeOnly.setSelection(false);
                }
            }
        });
        this.beforeDaysOrDate.setDate(LocalDate.now().minusDays(30L));
        this.filterSeriesByMoneyComposite = new FilterByMoneyComposite(content, true);
        this.converageMarkedOnly = new Button(content, 32);
        this.converageMarkedOnly.setText(Messages.KonsZumVerrechnenWizardDialog_selectCasesToCharge);
        new Label(content, 0);
        this.insurerOnly = new Button(content, 32);
        this.insurerOnly.setText("nur von folgendem Versicherer");
        this.insurerSelection = new KontaktSelectionComposite(content, 2);
        this.insurerSelection.setLayoutData(new GridData(131072, 0x1000000, true, false));
        this.insurerSelection.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    BillingProposalWizardDialog.this.insurerOnly.setSelection(true);
                } else {
                    BillingProposalWizardDialog.this.insurerOnly.setSelection(false);
                }
            }
        });
        this.mandatorOnly = new Button(content, 32);
        this.mandatorOnly.setText("nur von folgenden Mandanten");
        this.mandatorSelector = new GenericSelectionComposite(content, 0, ch.elexis.core.l10n.Messages.Core_Select_Mandator, ch.elexis.core.ui.actions.Messages.GlobalActions_ChangeMandator, ch.elexis.core.ui.actions.Messages.GlobalActions_ChangeMandatorMessage);
        this.mandatorSelector.setInput(new Query(Mandant.class).execute());
        this.mandatorSelector.setLayoutData(new GridData(131072, 0x1000000, true, false));
        this.mandatorSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    BillingProposalWizardDialog.this.mandatorOnly.setSelection(true);
                } else {
                    BillingProposalWizardDialog.this.mandatorOnly.setSelection(false);
                }
            }
        });
        this.patientOnly = new Button(content, 32);
        this.patientOnly.setText("nur von folgenden Patienten");
        this.patientSelector = new GenericSelectionComposite(content, 0, ch.elexis.core.l10n.Messages.Core_Select_Patient, ch.elexis.core.l10n.Messages.Core_Select_Patient, ch.elexis.core.l10n.Messages.Core_Select_Patient);
        Function<String, List<?>> inputFunction = s -> {
            IQuery query = CoreModelServiceHolder.get().getQuery(IPatient.class);
            query.and((EStructuralFeature)ModelPackage.Literals.ICONTACT__PATIENT, IQuery.COMPARATOR.EQUALS, (Object)true);
            if (s != null && s.length() > 2) {
                List searchParts = PatientSearchToken.getPatientSearchTokens((String[])s.toLowerCase().split(" "));
                searchParts.forEach(st -> st.apply(query));
            }
            query.orderBy((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION1, IQuery.ORDER.ASC);
            query.orderBy((EStructuralFeature)ModelPackage.Literals.ICONTACT__DESCRIPTION2, IQuery.ORDER.ASC);
            return query.execute();
        };
        this.patientSelector.setInputFunction(inputFunction);
        this.patientSelector.setLayoutData(new GridData(131072, 0x1000000, true, false));
        this.patientSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    BillingProposalWizardDialog.this.patientOnly.setSelection(true);
                } else {
                    BillingProposalWizardDialog.this.patientOnly.setSelection(false);
                }
            }
        });
        this.accountingOnly = new Button(content, 32);
        this.accountingOnly.setText("nur von folgenden Abrechnungssystemen");
        this.accountingSelector = new GenericSelectionComposite(content, 0, ch.elexis.core.l10n.Messages.GenericSearchSelectionDialog_BillingSystemSelection, ch.elexis.core.l10n.Messages.GenericSearchSelectionDialog_BillingSystemSelection, ch.elexis.core.l10n.Messages.GenericSearchSelectionDialog_ChangeBillingSystemMessage);
        this.accountingSelector.setInput(Arrays.asList(BillingSystem.getAbrechnungsSysteme()));
        this.accountingSelector.setLayoutData(new GridData(131072, 0x1000000, true, false));
        this.accountingSelector.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() != null && !event.getSelection().isEmpty()) {
                    BillingProposalWizardDialog.this.accountingOnly.setSelection(true);
                } else {
                    BillingProposalWizardDialog.this.accountingOnly.setSelection(false);
                }
            }
        });
        this.errorneousOnly = new Button(content, 32);
        this.errorneousOnly.setText("nur fehlerhafte");
        new Label(content, 0);
        new Label(content, 0);
        new Label(content, 0);
        new Label(content, 0);
        return ret;
    }

    protected void okPressed() {
        ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getShell());
        QueryProposalRunnable runnable = new QueryProposalRunnable();
        try {
            progress.run(true, true, (IRunnableWithProgress)runnable);
            if (runnable.isCanceled()) {
                return;
            }
            this.proposal = runnable.getProposal();
            this.series = runnable.isSeries();
        }
        catch (InterruptedException | InvocationTargetException e) {
            LoggerFactory.getLogger(BillingProposalWizardDialog.class).error("Error running proposal query", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Fehler", (String)"Fehler beim Ausf\u00fchren des Rechnungs-Vorschlags.");
            return;
        }
        super.okPressed();
    }

    public Optional<List<Konsultation>> getProposal() {
        return Optional.ofNullable(this.proposal);
    }

    public boolean isSeries() {
        return this.series;
    }

    protected boolean isResizable() {
        return true;
    }

    private class FilterByMoneyComposite
    extends Composite {
        private MoneyInput txtFilterKonsByMoney;
        private Button filterKonsByMoney;
        private ComboViewer lowerOrHigher;
        private boolean series;

        public FilterByMoneyComposite(Composite parent, boolean series) {
            super(parent, 0);
            this.setLayoutData(new GridData(4, 4, false, false, 2, 1));
            this.setLayout((Layout)SWTHelper.createGridLayout(true, 3));
            this.series = series;
        }

        private void createContents() {
            this.filterKonsByMoney = new Button((Composite)this, 32);
            if (this.series) {
                this.filterKonsByMoney.setText("Offene Behandlungsserien");
            } else {
                this.filterKonsByMoney.setText("Offene Behandlungen");
            }
            this.lowerOrHigher = new ComboViewer((Composite)this, 2048);
            this.lowerOrHigher.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.lowerOrHigher.setInput((Object)new String[]{ch.elexis.core.l10n.Messages.Core_Higher, ch.elexis.core.l10n.Messages.Core_Lower});
            this.lowerOrHigher.setSelection((ISelection)new StructuredSelection((Object)ch.elexis.core.l10n.Messages.Core_Higher));
            this.lowerOrHigher.getControl().setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
            Composite c = new Composite((Composite)this, 0);
            c.setLayout((Layout)new GridLayout(2, false));
            c.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
            Label lblBeforeTimeOnlyValueLessThen = new Label(c, 0);
            lblBeforeTimeOnlyValueLessThen.setText("Betrag CHF");
            this.txtFilterKonsByMoney = new MoneyInput(c);
            this.txtFilterKonsByMoney.getControl().addListener(25, new Listener(){

                public void handleEvent(Event e) {
                    String string = e.text;
                    char[] chars = new char[string.length()];
                    string.getChars(0, chars.length, chars, 0);
                    int i = 0;
                    while (i < chars.length) {
                        if (('0' > chars[i] || chars[i] > '9') && (e.start <= 0 || chars[i] != '.' && chars[i] != ',')) {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
        }

        public void changeVisibility(boolean show) {
            this.removeAllChildrens();
            if (show) {
                this.createContents();
            }
            this.getParent().layout(true, true);
        }

        private void removeAllChildrens() {
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
        }

        public boolean isSelected() {
            return this.isVisible() && this.filterKonsByMoney != null && !this.filterKonsByMoney.isDisposed() && this.filterKonsByMoney.getSelection();
        }

        public boolean isHigher() {
            if (!this.lowerOrHigher.getStructuredSelection().isEmpty()) {
                return ((String)this.lowerOrHigher.getStructuredSelection().getFirstElement()).equals(ch.elexis.core.l10n.Messages.Core_Higher);
            }
            return true;
        }

        public Money getMoney() {
            if (this.isVisible() && this.txtFilterKonsByMoney != null && !this.txtFilterKonsByMoney.isDisposed()) {
                return this.txtFilterKonsByMoney.getMoney(true);
            }
            return null;
        }
    }

    private class QueryProposalRunnable
    implements IRunnableWithProgress {
        private boolean canceled = false;
        private List<Konsultation> proposal = new ArrayList<Konsultation>();
        private IFilter insurerOnlyFilter;
        private IFilter accountingOnlyFilter;
        private IFilter errorneousOnlyFilter;
        private IFilter mandatorsOnlyFilter;
        private Query<Konsultation> query = new Query(Konsultation.class, "BEHANDLUNGEN", false, new String[]{"Datum", "Zeit", "MandantID", "RechnungsID", "FallID"});
        private boolean addSeries;
        private Money filterSeriesByMoney;
        private Money filterKonsByMoney;
        private boolean filterByMoneyHigher;

        public QueryProposalRunnable() {
            IStructuredSelection selection;
            this.query.add("RechnungsID", "=", null);
            this.query.add("billable", "=", "1");
            if (BillingProposalWizardDialog.this.timeSpanOnly.getSelection() && (selection = (IStructuredSelection)BillingProposalWizardDialog.this.timeSpanSelection.getSelection()) != null && !selection.isEmpty()) {
                TimeSpan timeSpan = (TimeSpan)selection.getFirstElement();
                this.query.add("Datum", ">=", timeSpan.from.toString(9));
                this.query.add("Datum", "<=", timeSpan.until.toString(9));
            }
            if (BillingProposalWizardDialog.this.filterKonsByMoneyComposite.isSelected()) {
                this.filterKonsByMoney = BillingProposalWizardDialog.this.filterKonsByMoneyComposite.getMoney();
                this.filterByMoneyHigher = BillingProposalWizardDialog.this.filterKonsByMoneyComposite.isHigher();
            }
            if (BillingProposalWizardDialog.this.beforeTimeOnly.getSelection()) {
                this.addSeries = true;
                selection = (IStructuredSelection)BillingProposalWizardDialog.this.beforeDaysOrDate.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    LocalDate fromDate = (LocalDate)selection.getFirstElement();
                    TimeTool fromTool = new TimeTool(fromDate);
                    this.query.add("Datum", "<=", fromTool.toString(9));
                    if (BillingProposalWizardDialog.this.filterSeriesByMoneyComposite.isSelected()) {
                        this.filterSeriesByMoney = BillingProposalWizardDialog.this.filterSeriesByMoneyComposite.getMoney();
                        this.filterByMoneyHigher = BillingProposalWizardDialog.this.filterSeriesByMoneyComposite.isHigher();
                    }
                }
            }
            if (BillingProposalWizardDialog.this.converageMarkedOnly.getSelection()) {
                Query coverageQuery = new Query(Fall.class);
                coverageQuery.add("RnPlanung", "<=", new TimeTool().toString(9));
                coverageQuery.add("RnPlanung", "<>", "");
                List coverages = coverageQuery.execute();
                if (coverages.isEmpty()) {
                    this.query.addToken("1 = 2");
                } else {
                    this.query.addToken("FallID IN (" + coverages.stream().map(c -> "'" + c.getId() + "'").collect(Collectors.joining(",")) + ")");
                }
            }
            if (BillingProposalWizardDialog.this.mandatorOnly.getSelection()) {
                selection = (IStructuredSelection)BillingProposalWizardDialog.this.mandatorSelector.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    List mandators = selection.toList();
                    this.query.startGroup();
                    int i = 0;
                    while (i < mandators.size()) {
                        if (i > 0) {
                            this.query.or();
                        }
                        this.query.add("MandantID", "=", ((Mandant)mandators.get(i)).getId());
                        ++i;
                    }
                    this.query.endGroup();
                }
                this.mandatorsOnlyFilter = new IFilter(){
                    private Set<String> mandatorIds = null;

                    public boolean select(Object element) {
                        if (this.mandatorIds == null) {
                            this.mandatorIds = new HashSet<String>();
                            IStructuredSelection selection = (IStructuredSelection)((QueryProposalRunnable)QueryProposalRunnable.this).BillingProposalWizardDialog.this.mandatorSelector.getSelection();
                            if (selection != null && !selection.isEmpty()) {
                                selection.forEach(o -> {
                                    boolean bl = this.mandatorIds.add(((Mandant)o).getId());
                                });
                            }
                        }
                        return this.mandatorIds.contains(((Konsultation)element).getMandant().getId());
                    }
                };
            }
            if (BillingProposalWizardDialog.this.patientOnly.getSelection() && (selection = (IStructuredSelection)BillingProposalWizardDialog.this.patientSelector.getSelection()) != null && !selection.isEmpty()) {
                List patients = selection.toList();
                List coverages = patients.stream().flatMap(p -> p.getCoverages().stream()).collect(Collectors.toList());
                if (coverages.isEmpty()) {
                    this.query.addToken("1 = 2");
                } else {
                    this.query.addToken("FallID IN (" + coverages.stream().map(c -> "'" + c.getId() + "'").collect(Collectors.joining(",")) + ")");
                }
            }
            if (BillingProposalWizardDialog.this.insurerOnly.getSelection()) {
                this.insurerOnlyFilter = new IFilter(){
                    private List<Kontakt> insurers;
                    {
                        this.insurers = ((IStructuredSelection)((QueryProposalRunnable)QueryProposalRunnable.this).BillingProposalWizardDialog.this.insurerSelection.getSelection()).toList();
                    }

                    public boolean select(Object element) {
                        Fall fall = ((Konsultation)element).getFall();
                        Kontakt costBearer = fall.getCostBearer();
                        if (costBearer != null) {
                            for (Kontakt insurer : this.insurers) {
                                if (!costBearer.getId().equals(insurer.getId())) continue;
                                return true;
                            }
                        }
                        return false;
                    }
                };
            }
            if (BillingProposalWizardDialog.this.accountingOnly.getSelection()) {
                this.accountingOnlyFilter = new IFilter(){
                    private List<String> accountings;
                    {
                        this.accountings = ((IStructuredSelection)((QueryProposalRunnable)QueryProposalRunnable.this).BillingProposalWizardDialog.this.accountingSelector.getSelection()).toList();
                    }

                    public boolean select(Object element) {
                        Fall fall = ((Konsultation)element).getFall();
                        String accounting = fall.getAbrechnungsSystem();
                        return this.accountings.contains(accounting);
                    }
                };
            }
            if (BillingProposalWizardDialog.this.errorneousOnly.getSelection()) {
                this.errorneousOnlyFilter = new IFilter(){

                    public boolean select(Object element) {
                        return !BillingUtil.getBillableResult((Konsultation)((Konsultation)element)).isOK();
                    }
                };
            }
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            ArrayList<Konsultation> proposalCopy;
            List initialList = this.query.execute();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            progress.setTaskName("Vorschlag filter");
            if (this.addSeries) {
                progress.setWorkRemaining(initialList.size() * 2);
            } else {
                progress.setWorkRemaining(initialList.size());
            }
            for (Konsultation konsultation : initialList) {
                if (progress.isCanceled()) {
                    this.canceled = true;
                    return;
                }
                if (!this.applyFilters(konsultation)) {
                    progress.worked(1);
                    continue;
                }
                this.proposal.add(konsultation);
                progress.worked(1);
            }
            if (this.addSeries) {
                progress.setTaskName("Behandlungsserien laden");
                HashSet knownIds = new HashSet();
                knownIds.addAll(this.proposal.parallelStream().map(k -> k.getId()).collect(Collectors.toList()));
                ArrayList<Konsultation> proposalCopy2 = new ArrayList<Konsultation>(this.proposal);
                proposalCopy2.forEach(k -> {
                    List<Konsultation> series = this.getSeries(k.getFall());
                    if (this.filterSeriesByMoney != null) {
                        Money totalForKonsSerie = this.getSeriesTotal(series);
                        if (this.filterByMoneyHigher && this.filterSeriesByMoney.isMoreThan(totalForKonsSerie) || !this.filterByMoneyHigher && totalForKonsSerie.isMoreThan(this.filterSeriesByMoney)) {
                            knownIds.addAll(series.parallelStream().map(sk -> sk.getId()).collect(Collectors.toList()));
                            this.proposal.remove(k);
                        }
                    }
                    series.forEach(sk -> {
                        if (!knownIds.contains(sk.getId())) {
                            knownIds.add(sk.getId());
                            if (this.applyFilters((Konsultation)sk)) {
                                this.proposal.add((Konsultation)sk);
                            }
                        }
                    });
                    progress.worked(1);
                    if (progress.isCanceled()) {
                        this.canceled = true;
                        return;
                    }
                });
            }
            if (this.filterKonsByMoney != null) {
                proposalCopy = new ArrayList<Konsultation>(this.proposal);
                proposalCopy.forEach(k -> {
                    IEncounter encounter = NoPoUtil.loadAsIdentifiable((PersistentObject)k, IEncounter.class).orElse(null);
                    if (encounter != null) {
                        Money konsTotal = EncounterServiceHolder.get().getSales(encounter);
                        if (this.filterByMoneyHigher && this.filterKonsByMoney.isMoreThan(konsTotal) || !this.filterByMoneyHigher && konsTotal.isMoreThan(this.filterKonsByMoney)) {
                            this.proposal.remove(k);
                        }
                    }
                });
            }
            proposalCopy = new ArrayList<Konsultation>(this.proposal);
            TimeTool now = new TimeTool();
            proposalCopy.forEach(k -> {
                TimeTool billingDate = k.getFall().getBillingDate();
                if (billingDate != null && billingDate.isAfter(now)) {
                    this.proposal.remove(k);
                }
            });
            monitor.done();
        }

        private Money getSeriesTotal(List<Konsultation> series) {
            Money ret = new Money();
            series.forEach(sk -> {
                Money money2 = ret.addMoney(BillingUtil.getTotal((Konsultation)sk));
            });
            return ret;
        }

        private boolean applyFilters(Konsultation konsultation) {
            if (this.insurerOnlyFilter != null && !this.insurerOnlyFilter.select((Object)konsultation)) {
                return false;
            }
            if (this.accountingOnlyFilter != null && !this.accountingOnlyFilter.select((Object)konsultation)) {
                return false;
            }
            if (this.errorneousOnlyFilter != null && !this.errorneousOnlyFilter.select((Object)konsultation)) {
                return false;
            }
            return this.mandatorsOnlyFilter == null || this.mandatorsOnlyFilter.select((Object)konsultation);
        }

        private List<Konsultation> getSeries(Fall fall) {
            return Arrays.asList(fall.getBehandlungen(false)).parallelStream().filter(k -> k.isBillable()).filter(k -> k.getRechnung() == null || !k.getRechnung().exists()).collect(Collectors.toList());
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public List<Konsultation> getProposal() {
            return this.proposal;
        }

        public boolean isSeries() {
            return this.addSeries;
        }
    }
}

