/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dialogs;

import ch.elexis.core.data.events.ElexisEventDispatcher;
import ch.elexis.core.data.interfaces.IPersistentObject;
import ch.elexis.core.model.IArticle;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.services.holder.StoreToStringServiceHolder;
import ch.elexis.core.ui.dialogs.Messages;
import ch.elexis.core.ui.util.LabeledInputField;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.Artikel;
import java.util.Optional;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ArtikelDetailDialog
extends TitleAreaDialog {
    protected IArticle article;

    public static final LabeledInputField.InputData[] getFieldDefs(Shell shell) {
        LabeledInputField.InputData[] ret = new LabeledInputField.InputData[]{new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Core_Type, "Typ", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Artikeldetail_EAN, "EAN", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Core_Phamacode, "ExtInfo", LabeledInputField.InputData.Typ.STRING, "Pharmacode"), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Artikeldetail_Einkaufspreis, "EK_Preis", LabeledInputField.InputData.Typ.CURRENCY, null), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Artikeldetail_Verkaufspreis, "VK_Preis", LabeledInputField.InputData.Typ.CURRENCY, null), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Core_Pieces_per_pack, "ExtInfo", LabeledInputField.InputData.Typ.INT, "VerpackungsEinheit"), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Core_Pieces_by_dose, "ExtInfo", LabeledInputField.InputData.Typ.INT, "Verkaufseinheit")};
        return ret;
    }

    public static final LabeledInputField.InputData[] getModelFieldDefs(Shell shell) {
        LabeledInputField.InputData[] ret = new LabeledInputField.InputData[]{new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Core_Type, "typ", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Artikeldetail_EAN, "gtin", LabeledInputField.InputData.Typ.STRING, null), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Core_Phamacode, "extInfo", LabeledInputField.InputData.Typ.STRING, "Pharmacode"), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Artikeldetail_Einkaufspreis, "purchasePrice", LabeledInputField.InputData.Typ.CURRENCY, null), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Artikeldetail_Verkaufspreis, "sellingPrice", LabeledInputField.InputData.Typ.CURRENCY, null), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Core_Pieces_per_pack, "extInfo", LabeledInputField.InputData.Typ.INT, "VerpackungsEinheit"), new LabeledInputField.InputData(ch.elexis.core.ui.views.artikel.Messages.Core_Pieces_by_dose, "extInfo", LabeledInputField.InputData.Typ.INT, "Verkaufseinheit")};
        return ret;
    }

    public ArtikelDetailDialog(Shell shell, IPersistentObject o) {
        super(shell);
        Optional identifiable = StoreToStringServiceHolder.get().loadFromString(o.storeToString());
        if (!identifiable.isPresent() || !(identifiable.get() instanceof IArticle)) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Fehler", (String)("Der Artikel [" + o.getLabel() + "] konnte nicht geladen werden."));
            throw new IllegalStateException("Could not load identifiable for article [" + o.getLabel() + "]");
        }
        this.article = (IArticle)identifiable.get();
    }

    public ArtikelDetailDialog(Shell shell, IArticle article) {
        super(shell);
        this.article = article;
    }

    protected Control createDialogArea(Composite parent) {
        ScrolledComposite ret = new ScrolledComposite(parent, 512);
        Composite cnt = new Composite((Composite)ret, 0);
        ret.setContent((Control)cnt);
        ret.setExpandHorizontal(true);
        ret.setExpandVertical(true);
        ret.setLayoutData((Object)SWTHelper.getFillGridData(1, true, 1, true));
        cnt.setLayout((Layout)new FillLayout());
        LabeledInputField.AutoForm tblArtikel = null;
        tblArtikel = this.article instanceof Identifiable ? new LabeledInputField.AutoForm(cnt, ArtikelDetailDialog.getModelFieldDefs(parent.getShell())) : new LabeledInputField.AutoForm(cnt, ArtikelDetailDialog.getFieldDefs(parent.getShell()));
        tblArtikel.reload((Identifiable)this.article);
        ret.setMinSize(cnt.computeSize(-1, -1));
        return ret;
    }

    protected Point getInitialSize() {
        Point orig = super.getInitialSize();
        orig.y += orig.y >> 2;
        return orig;
    }

    public void create() {
        this.setShellStyle(this.getShellStyle() | 0x10);
        super.create();
        this.getShell().setText(Messages.Article_Detail);
        this.setTitle(this.article.getLabel());
        this.setMessage(Messages.ArtikelDetailDialog_enterArticleDetails);
    }

    protected void okPressed() {
        ElexisEventDispatcher.reload(Artikel.class);
        super.okPressed();
    }
}

