/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.data;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.data.UiDBImage;
import ch.elexis.data.DBImage;
import ch.elexis.data.Sticker;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class UiSticker {
    private Sticker sticker;

    public UiSticker(Sticker sticker) {
        this.sticker = sticker;
    }

    public Image getImage() {
        Image ret = null;
        DBImage dbImage = DBImage.load((String)this.sticker.get("BildID"));
        if (!dbImage.exists()) {
            dbImage = null;
        }
        UiDBImage image = new UiDBImage(dbImage);
        ret = UiDesk.getImageRegistry().get(image.getName());
        if (ret == null && (ret = image.getImageScaledTo(16, 16, false)) != null) {
            UiDesk.getImageRegistry().put(image.getName(), ret);
        }
        return ret;
    }

    public void setImage(UiDBImage image) {
        this.sticker.set("BildID", image.getId());
    }

    public Color getForeground() {
        return UiDesk.getColorFromRGB(this.sticker.getForeground());
    }

    public void setForeground(Color fg) {
        if (fg != null) {
            this.sticker.setForeground("vg");
        }
    }

    public Color getBackground() {
        return UiDesk.getColorFromRGB(this.sticker.getBackground());
    }

    public void setBackground(Color bg) {
        if (bg != null) {
            this.sticker.setBackground(UiDesk.createColor(bg.getRGB()));
        }
    }

    public Composite createForm(Composite parent) {
        Composite ret = new Composite(parent, 0);
        ret.setLayout((Layout)new GridLayout(2, false));
        Image img = this.getImage();
        GridData gd1 = null;
        GridData gd2 = null;
        Composite cImg = new Composite(ret, 0);
        if (img != null) {
            cImg.setBackgroundImage(img);
            gd1 = new GridData(img.getBounds().width, img.getBounds().height);
            gd2 = new GridData(-1, img.getBounds().height);
        } else {
            gd1 = new GridData(10, 10);
            gd2 = new GridData(-1, -1);
        }
        cImg.setLayoutData((Object)gd1);
        Label lbl = new Label(ret, 0);
        lbl.setLayoutData((Object)gd2);
        lbl.setText(this.sticker.getLabel());
        lbl.setForeground(UiDesk.getColorFromRGB(this.sticker.getForeground()));
        lbl.setBackground(UiDesk.getColorFromRGB(this.sticker.getBackground()));
        return ret;
    }
}

