/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.data;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.data.DBImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiDBImage {
    private Logger log = LoggerFactory.getLogger(UiDBImage.class);
    private DBImage dbImage;

    public UiDBImage(DBImage dbImage) {
        this.dbImage = dbImage;
    }

    public UiDBImage(String prefix, String name, InputStream source) {
        this.dbImage = new DBImage(prefix, name);
        try {
            ImageLoader iml = new ImageLoader();
            iml.load(source);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            iml.save((OutputStream)baos, 5);
            this.dbImage.setBinary("Bild", baos.toByteArray());
        }
        catch (IllegalArgumentException | SWTException e) {
            this.log.error("Error setting image object on DBImage " + this.dbImage.getLabel(), e);
        }
    }

    public Image getImage() {
        byte[] in = this.dbImage.getBinary("Bild");
        ByteArrayInputStream bais = new ByteArrayInputStream(in);
        try {
            ImageData idata = new ImageData((InputStream)bais);
            Image ret = new Image((Device)UiDesk.getDisplay(), idata);
            return ret;
        }
        catch (Exception ex) {
            SWTHelper.showError("Image Error", "Ung\u00fcltiges Bild", "Das Bild ist ung\u00fcltig " + ex.getMessage());
            return null;
        }
    }

    public Image getImageScaledTo(int width, int height, boolean bShrinkOnly) {
        if (this.dbImage == null) {
            return null;
        }
        byte[] in = this.dbImage.getBinary("Bild");
        ByteArrayInputStream bais = new ByteArrayInputStream(in);
        try {
            ImageData idata = new ImageData((InputStream)bais);
            if (idata.width != width || idata.height != height) {
                idata = idata.scaledTo(width, height);
            }
            Image ret = new Image((Device)UiDesk.getDisplay(), idata);
            return ret;
        }
        catch (Exception ex) {
            SWTHelper.showError("Image Error", "Ung\u00fcltiges Bild", "Das Bild ist ung\u00fcltig " + ex.getMessage());
            return null;
        }
    }

    public String getId() {
        if (this.dbImage == null) {
            return null;
        }
        return this.dbImage.getId();
    }

    public String getName() {
        if (this.dbImage == null) {
            return null;
        }
        return this.dbImage.getName();
    }
}

