/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.model.IDocumentLetter;
import ch.elexis.core.model.IDocumentTemplate;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.ui.commands.Messages;
import ch.elexis.core.ui.views.textsystem.model.TextTemplate;
import ch.elexis.data.Brief;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class TemplateRenameSettingsCommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection structuredSelection;
        Object firstElement;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof TextTemplate) {
            TextTemplate textTemplate = (TextTemplate)firstElement;
            if (textTemplate.isSystemTemplate()) {
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)Messages.Template_not_editable, (String)Messages.Template_not_editable_text);
            } else {
                List<String> existingNames = this.getExistingNames();
                InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.Edit_Template, Messages.Edit_Template_Description, textTemplate.getName(), newName -> {
                    if (StringUtils.isBlank((CharSequence)newName)) {
                        return "Eingabefeld darf nicht leer sein.";
                    }
                    if (existingNames.contains(newName)) {
                        return "Dieser Name ist bereits vergeben. Bitte w\u00e4hlen Sie einen anderen.";
                    }
                    return null;
                });
                if (dialog.open() == 0) {
                    String newName2 = dialog.getValue();
                    Brief template = textTemplate.getTemplate();
                    if (template != null) {
                        template.set("Betreff", newName2);
                        ContextServiceHolder.get().postEvent("info/elexis/model/reload", IDocumentLetter.class);
                    }
                }
            }
        }
        return null;
    }

    private List<String> getExistingNames() {
        IQuery query = CoreModelServiceHolder.get().getQuery(IDocumentTemplate.class);
        List existingTemplates = query.execute();
        ArrayList<String> existingNames = new ArrayList<String>();
        for (IDocumentTemplate template : existingTemplates) {
            existingNames.add(template.getTitle());
        }
        return existingNames;
    }
}

