/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.interfaces.IRnOutputter;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.mail.AttachmentsUtil;
import ch.elexis.core.model.IInvoice;
import ch.elexis.core.model.Identifiable;
import ch.elexis.core.preferences.PreferencesUtil;
import ch.elexis.core.services.IConfigService;
import ch.elexis.core.services.LocalConfigService;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.utils.Extensions;
import ch.elexis.data.Rechnung;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.LoggerFactory;

public class SendInvoiceAsMailHandler
extends AbstractHandler {
    private IRnOutputter pdfOutputter;
    private List<File> movedExisting;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Optional selectedInvoice = ContextServiceHolder.get().getTyped(IInvoice.class);
        if (!selectedInvoice.isPresent()) return Boolean.TRUE;
        Optional<IRnOutputter> pdfOutputter = this.getPdfOutputter();
        if (pdfOutputter.isPresent()) {
            this.moveExistingPfds((IInvoice)selectedInvoice.get());
            Properties outputProps = new Properties();
            outputProps.put("OutputNoUi", Boolean.toString(true));
            outputProps.put("OutputNoPrint", Boolean.toString(true));
            outputProps.put("OutputModifyInvoiceState", Boolean.toString(false));
            outputProps.put("OutputWithEsr", Boolean.toString(true));
            outputProps.put("OutputWithReclaim", Boolean.toString(true));
            outputProps.put("OutputWithMail", Boolean.toString(false));
            pdfOutputter.get().doOutput(IRnOutputter.TYPE.COPY, Collections.singletonList((Rechnung)NoPoUtil.loadAsPersistentObject((Identifiable)((Identifiable)selectedInvoice.get()))), outputProps);
            List<File> pdfs = this.getPdfs((IInvoice)selectedInvoice.get());
            if (pdfs.isEmpty()) {
                this.restoreExistingPfds();
                MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)"Konnte keine Rechnungskopie Pdfs erstellen.");
                return Boolean.FALSE;
            }
            pdfs = this.moveCopyPdfs(pdfs, (IInvoice)selectedInvoice.get());
            this.restoreExistingPfds();
            if (pdfs.isEmpty()) return Boolean.TRUE;
            ICommandService commandService = (ICommandService)HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getService(ICommandService.class);
            try {
                String attachmentsString = AttachmentsUtil.getAttachmentsString(pdfs);
                Command sendMailCommand = commandService.getCommand("ch.elexis.core.mail.ui.sendMail");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("ch.elexis.core.mail.ui.sendMail.attachments", attachmentsString);
                if (StringUtils.isNotBlank((CharSequence)((IInvoice)selectedInvoice.get()).getCoverage().getPatient().getEmail())) {
                    params.put("ch.elexis.core.mail.ui.sendMail.to", ((IInvoice)selectedInvoice.get()).getCoverage().getPatient().getEmail());
                }
                params.put("ch.elexis.core.mail.ui.sendMail.subject", "Rechnungskopie " + ((IInvoice)selectedInvoice.get()).getNumber());
                ParameterizedCommand parametrizedCommmand = ParameterizedCommand.generateCommand((Command)sendMailCommand, params);
                Object result = ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand(parametrizedCommmand, null);
                if (!Boolean.TRUE.equals(result)) return Boolean.TRUE;
                ((IInvoice)selectedInvoice.get()).addTrace("Ausgegeben", "Rechnungskopie per Mail");
                CoreModelServiceHolder.get().save((Identifiable)selectedInvoice.get());
                ContextServiceHolder.get().postEvent("info/elexis/model/update", selectedInvoice.get());
                return Boolean.TRUE;
            }
            catch (Exception ex) {
                throw new RuntimeException("ch.elexis.core.mail.ui.sendMail not found", ex);
            }
        } else {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Fehler", (String)"Keine pdf Ausgabe installiert.");
            return Boolean.FALSE;
        }
    }

    private List<File> moveCopyPdfs(List<File> pdfs, IInvoice iInvoice) {
        ArrayList<File> movedFiles = new ArrayList<File>();
        for (File file : pdfs) {
            try {
                Path destination;
                if (file.getName().endsWith("_esr.pdf")) {
                    destination = file.toPath().resolveSibling(iInvoice.getNumber() + "_Rechnungskopie_Einzahlungsschein.pdf");
                    if (destination.toFile().exists()) {
                        destination.toFile().delete();
                    }
                    Files.move(file.toPath(), destination, new CopyOption[0]);
                    movedFiles.add(destination.toFile());
                    continue;
                }
                if (!file.getName().endsWith("_rf.pdf")) continue;
                destination = file.toPath().resolveSibling(iInvoice.getNumber() + "_Rechnungskopie_Formular.pdf");
                if (destination.toFile().exists()) {
                    destination.toFile().delete();
                }
                Files.move(file.toPath(), destination, new CopyOption[0]);
                movedFiles.add(destination.toFile());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error moving existing pdfs", (Throwable)e);
            }
        }
        return movedFiles;
    }

    private void moveExistingPfds(IInvoice iInvoice) {
        this.movedExisting = new ArrayList<File>();
        List<File> pdfs = this.getPdfs(iInvoice);
        for (File file : pdfs) {
            try {
                Path destination = file.toPath().resolveSibling("existing_" + file.getName());
                if (destination.toFile().exists()) {
                    destination.toFile().delete();
                }
                Files.move(file.toPath(), destination, new CopyOption[0]);
                this.movedExisting.add(destination.toFile());
            }
            catch (IOException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error moving existing pdfs", (Throwable)e);
            }
        }
    }

    private void restoreExistingPfds() {
        if (this.movedExisting != null) {
            for (File file : this.movedExisting) {
                try {
                    Path destination = file.toPath().resolveSibling(file.getName().replace("existing_", ""));
                    if (destination.toFile().exists()) {
                        destination.toFile().delete();
                    }
                    Files.move(file.toPath(), destination, new CopyOption[0]);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Error restoring existing pdfs", (Throwable)e);
                }
            }
        }
    }

    private List<File> getPdfs(IInvoice iInvoice) {
        try {
            String pdfOutputDir = OutputterUtil.getPdfOutputDir("qrpdf-output/");
            File esrFile = VirtualFilesystemServiceHolder.get().of(pdfOutputDir + File.separator + iInvoice.getNumber() + "_esr.pdf").toFile().orElse(null);
            File rfFile = VirtualFilesystemServiceHolder.get().of(pdfOutputDir + File.separator + iInvoice.getNumber() + "_rf.pdf").toFile().orElse(null);
            if (esrFile.exists() && rfFile.exists()) {
                ArrayList<File> ret = new ArrayList<File>();
                ret.add(esrFile);
                ret.add(rfFile);
                return ret;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Could not access qr pdf output", (Throwable)e);
        }
        return Collections.emptyList();
    }

    private Optional<IRnOutputter> getPdfOutputter() {
        if (this.pdfOutputter != null) {
            return Optional.of(this.pdfOutputter);
        }
        List foundOutputters = Extensions.getClasses((String)"ch.elexis.core.data.RechnungsManager", (String)"outputter");
        for (IRnOutputter outputter : foundOutputters) {
            if (!outputter.getClass().getName().endsWith("pdfBills.QrRnOutputter")) continue;
            this.pdfOutputter = outputter;
            return Optional.of(this.pdfOutputter);
        }
        return Optional.empty();
    }

    private class OutputterUtil {
        public static final String CFG_ROOT = "pdf-outputter/";
        public static final String CFG_PRINT_GLOBALOUTPUTDIRS = "pdf-outputter/global.output.dirs";
        public static final String CFG_PRINT_GLOBALPDFDIR = "pdf-outputter/global.output.pdfdir";
        public static final String CFG_PRINT_GLOBALXMLDIR = "pdf-outputter/global.output.xmldir";
        public static final String PDFDIR = "pdfdir";

        private OutputterUtil() {
        }

        public static boolean useGlobalOutputDirs() {
            return OutputterUtil.hasGlobalDirectories() && LocalConfigService.get((String)CFG_PRINT_GLOBALOUTPUTDIRS, (boolean)true);
        }

        private static boolean hasGlobalDirectories() {
            return StringUtils.isNotBlank((CharSequence)PreferencesUtil.getOsSpecificPreference((String)CFG_PRINT_GLOBALPDFDIR, (IConfigService)ConfigServiceHolder.get())) && StringUtils.isNotBlank((CharSequence)PreferencesUtil.getOsSpecificPreference((String)CFG_PRINT_GLOBALXMLDIR, (IConfigService)ConfigServiceHolder.get()));
        }

        public static String getPdfOutputDir(String configRoot) {
            if (OutputterUtil.useGlobalOutputDirs()) {
                return PreferencesUtil.getOsSpecificPreference((String)CFG_PRINT_GLOBALPDFDIR, (IConfigService)ConfigServiceHolder.get());
            }
            return LocalConfigService.get((String)(configRoot + PDFDIR), (String)"");
        }
    }
}

