/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.commands;

import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.holder.CoverageServiceHolder;
import ch.elexis.core.ui.commands.Messages;
import ch.elexis.core.ui.services.EncounterServiceHolder;
import ch.elexis.core.ui.util.SWTHelper;
import ch.elexis.core.ui.views.FallDetailView;
import ch.elexis.data.Fall;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.rgw.tools.Result;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallCopyCommand
extends AbstractHandler {
    private static Logger logger = LoggerFactory.getLogger(FallCopyCommand.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean transferCons;
        Konsultation[] consultations;
        ICoverage clone;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        FallDetailView fallDetailView = (FallDetailView)activePage.findView("ch.elexis.FallDetailView");
        Fall activeFall = fallDetailView.getActiveFall();
        if (activeFall != null && (clone = this.createFallClone(NoPoUtil.loadAsIdentifiable((PersistentObject)activeFall, ICoverage.class).orElse(null))) != null && activeFall.isOpen() && (consultations = activeFall.getBehandlungen(true)) != null && consultations.length > 0 && (transferCons = SWTHelper.askYesNo(Messages.FallCopyCommand_RelatedConsultations, Messages.FallCopyCommand_TransferConsultations + Messages.FallCopyCommand_AttentionTransferConsultations))) {
            logger.debug("trying to transfer consulations");
            Konsultation[] konsultationArray = consultations;
            int n = consultations.length;
            int n2 = 0;
            while (n2 < n) {
                Result result;
                Konsultation cons = konsultationArray[n2];
                if (cons.isEditable(false) && !(result = EncounterServiceHolder.get().transferToCoverage((IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)cons, IEncounter.class).get(), clone, false)).isOK()) {
                    SWTHelper.alert("Error", result.toString());
                }
                ++n2;
            }
        }
        return null;
    }

    private ICoverage createFallClone(ICoverage fall) {
        if (fall != null) {
            return CoverageServiceHolder.get().createCopy(fall);
        }
        return null;
    }
}

