/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.actions;

import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.ui.util.IScannerListener;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ScannerEvents
implements Listener {
    private static int BUF_LIMIT = 500;
    private static int BUF_MINIMUM = 30;
    private static ScannerEvents input;
    private int prefixCode = 0;
    private int postfixCode = 0;
    private int barcodeLength = 13;
    private final ArrayList<IScannerListener> listenerList;
    private StringBuffer inputBuffer = new StringBuffer();
    private boolean prefixOn = false;

    ScannerEvents() {
        this.listenerList = new ArrayList();
        this.reloadCodes();
    }

    public static ScannerEvents getInstance() {
        if (input == null) {
            input = new ScannerEvents();
        }
        return input;
    }

    public void reloadCodes() {
        this.prefixCode = ConfigServiceHolder.getGlobal((String)"scanner/prefixcode", (int)0);
        this.postfixCode = ConfigServiceHolder.getGlobal((String)"scanner/postfixcode", (int)0);
        this.barcodeLength = ConfigServiceHolder.getGlobal((String)"scanner/barcodelength", (int)13);
    }

    public static void addListenerToDisplay(Display display) {
        display.addFilter(1, (Listener)ScannerEvents.getInstance());
    }

    private String getBarcode(StringBuffer strBuf) {
        String barcode = strBuf.toString();
        barcode = barcode.replaceAll(Character.valueOf('\r').toString(), "");
        barcode = barcode.replaceAll(Character.valueOf('\n').toString(), "");
        if ((barcode = barcode.replaceAll(Character.valueOf('\u0000').toString(), "")).length() > this.barcodeLength) {
            return barcode.substring(barcode.length() - this.barcodeLength);
        }
        return barcode;
    }

    public void handleEvent(Event event) {
        if (!this.listenerList.isEmpty()) {
            if (event.keyCode == this.prefixCode) {
                this.prefixOn = true;
                this.inputBuffer = new StringBuffer();
            } else if (event.keyCode == this.postfixCode) {
                this.prefixOn = false;
                this.fireScannerInput(event.widget, this.getBarcode(this.inputBuffer));
                this.inputBuffer = new StringBuffer();
            } else if (this.prefixOn && event.character == '\r') {
                this.prefixOn = false;
                this.fireScannerInput(event.widget, this.getBarcode(this.inputBuffer));
                this.inputBuffer = new StringBuffer();
            }
            if (this.inputBuffer.length() > BUF_LIMIT) {
                this.inputBuffer = this.inputBuffer.delete(0, this.inputBuffer.length() - BUF_MINIMUM);
            }
            this.inputBuffer.append(event.character);
        }
    }

    public void addScannerListener(IScannerListener listener) {
        this.listenerList.add(listener);
    }

    public void removeScannerListener(IScannerListener listener) {
        this.listenerList.remove(listener);
    }

    public void fireScannerInput(Widget widget, String input) {
        Event e = new Event();
        e.widget = widget;
        e.text = input;
        for (IScannerListener listener : this.listenerList) {
            listener.scannerInput(e);
        }
    }

    public static void beep() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().beep();
    }
}

