/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.reminder.supplier;

import ch.elexis.core.model.IContact;
import ch.elexis.core.model.IReminder;
import ch.elexis.core.model.IReminderResponsibleLink;
import ch.elexis.core.model.ModelPackage;
import ch.elexis.core.model.issue.ProcessStatus;
import ch.elexis.core.services.IQuery;
import ch.elexis.core.services.ISubQuery;
import ch.elexis.core.services.holder.CoreModelServiceHolder;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.LoggerFactory;

public class ContactSupplier
implements Supplier<List<IReminder>> {
    private IContact contact;
    private String search;
    private boolean showCompleted;
    private int limit;

    public ContactSupplier(IContact contact, String search, boolean showCompleted, int limit) {
        this.contact = contact;
        this.search = search;
        this.showCompleted = showCompleted;
        this.limit = limit;
    }

    @Override
    public List<IReminder> get() {
        long start = System.currentTimeMillis();
        IQuery query = CoreModelServiceHolder.get().getQuery(IReminder.class);
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__STATUS, this.showCompleted ? IQuery.COMPARATOR.EQUALS : IQuery.COMPARATOR.NOT_EQUALS, (Object)ProcessStatus.CLOSED);
        ISubQuery subQuery = query.createSubQuery(IReminderResponsibleLink.class, CoreModelServiceHolder.get());
        subQuery.andParentCompare("id", IQuery.COMPARATOR.EQUALS, "reminderid");
        subQuery.and("responsible", IQuery.COMPARATOR.EQUALS, (Object)this.contact);
        query.exists(subQuery);
        if (StringUtils.isNotBlank((CharSequence)this.search)) {
            this.addSearchToQuery((IQuery<IReminder>)query);
        }
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IDENTIFIABLE__LASTUPDATE, IQuery.ORDER.DESC);
        query.orderBy((EStructuralFeature)ModelPackage.Literals.IREMINDER__DUE, IQuery.ORDER.DESC);
        query.limit(this.limit);
        List ret = query.execute();
        LoggerFactory.getLogger(this.getClass()).info("Supply [" + String.valueOf(this.contact) + "] took " + (System.currentTimeMillis() - start) + "[ms]");
        return ret;
    }

    private void addSearchToQuery(IQuery<IReminder> query) {
        String likeSearch = "%" + this.search + "%";
        query.and((EStructuralFeature)ModelPackage.Literals.IREMINDER__SUBJECT, IQuery.COMPARATOR.LIKE, (Object)likeSearch, true);
    }
}

