/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.laboratory.controls;

import ch.elexis.core.ui.UiDesk;
import ch.elexis.core.ui.laboratory.controls.LaborChartPopupManager;
import ch.elexis.core.ui.laboratory.controls.Messages;
import ch.elexis.core.ui.laboratory.controls.model.LaborItemResults;
import ch.elexis.core.ui.laboratory.views.LaborView;
import ch.elexis.data.LabResult;
import ch.elexis.data.Patient;
import ch.rgw.tools.TimeTool;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swtchart.Chart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class LaborChartComposite
extends Composite {
    public static final String ID = "ch.elexis.LaborResultsComposite";
    private final FormToolkit tk = UiDesk.getToolkit();
    private Form form;
    private Patient actPatient;
    private LaborView parentLaborView;
    private LaborChartPopupManager laborChartPopupManager;
    private List<Chart> charts = new ArrayList<Chart>();
    public TreeViewer viewer;
    private DateTime fromDate;
    private DateTime toDate;
    private Button updateChartsButton;
    private List<TreeItem> selectedItems = new ArrayList<TreeItem>();
    private Composite body;
    private Composite chartsComposite;
    private Button legendCheckbox;

    public LaborChartComposite(Composite parent, int style, LaborView parentLaborView) {
        super(parent, style);
        this.parentLaborView = parentLaborView;
        this.laborChartPopupManager = new LaborChartPopupManager(this.actPatient);
        this.createContent();
    }

    public Composite getChartsComposite() {
        return this.chartsComposite;
    }

    private void createContent() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.form = this.tk.createForm((Composite)this);
        this.form.setLayoutData((Object)new GridData(4, 4, true, true));
        this.body = this.form.getBody();
        this.body.setLayout((Layout)new GridLayout(1, false));
        Composite topComposite = new Composite(this.body, 0);
        GridLayout topLayout = new GridLayout(3, false);
        topComposite.setLayout((Layout)topLayout);
        topComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.createCalendarAndButton(topComposite);
        this.chartsComposite = new Composite(this.body, 0);
        this.chartsComposite.setLayout((Layout)new GridLayout(1, false));
        this.chartsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.updateCharts(this.chartsComposite);
    }

    public void selectPatient(Patient patient) {
        this.actPatient = patient;
        if (!this.isVisible()) {
            return;
        }
        this.clearCharts();
        this.setRedraw(false);
        TimeTool now = new TimeTool();
        this.setRedraw(true);
    }

    private void createCalendarAndButton(Composite parent) {
        this.fromDate = new DateTime(parent, 36);
        this.toDate = new DateTime(parent, 36);
        GridData fromDateGridData = new GridData(4, 0x1000000, false, false);
        this.fromDate.setLayoutData((Object)fromDateGridData);
        GridData toDateGridData = new GridData(4, 0x1000000, false, false);
        this.toDate.setLayoutData((Object)toDateGridData);
        this.fromDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalDate from = LaborChartComposite.this.getDate(LaborChartComposite.this.fromDate);
                LocalDate to = LaborChartComposite.this.getDate(LaborChartComposite.this.toDate);
                LocalDate currentDate = LocalDate.now();
                if (from.isAfter(to)) {
                    LaborChartComposite.this.setDate(LaborChartComposite.this.fromDate, to);
                    LaborChartComposite.this.showMessage(Messages.Error_StartDateAfterEndDate);
                }
                if (to.isAfter(currentDate)) {
                    LaborChartComposite.this.setDate(LaborChartComposite.this.toDate, currentDate);
                    LaborChartComposite.this.showMessage(Messages.Error_EndDateInFuture);
                }
            }
        });
        this.toDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocalDate from = LaborChartComposite.this.getDate(LaborChartComposite.this.fromDate);
                LocalDate to = LaborChartComposite.this.getDate(LaborChartComposite.this.toDate);
                LocalDate currentDate = LocalDate.now();
                if (from.isAfter(to)) {
                    LaborChartComposite.this.setDate(LaborChartComposite.this.fromDate, to);
                    LaborChartComposite.this.showMessage(Messages.Error_StartDateAfterEndDate);
                }
                if (to.isAfter(currentDate)) {
                    LaborChartComposite.this.setDate(LaborChartComposite.this.toDate, currentDate);
                    LaborChartComposite.this.showMessage(Messages.Error_EndDateInFuture);
                }
            }
        });
        this.createUpdateChartsButton(parent);
        this.createLegendCheckbox(parent);
    }

    public void setSelectedItems(List<TreeItem> items) {
        this.selectedItems = items != null ? new ArrayList<TreeItem>(items) : new ArrayList();
    }

    public List<TreeItem> getSelectedItems() {
        return this.selectedItems;
    }

    private void clearCharts() {
        for (Chart chart : this.charts) {
            if (chart == null || chart.isDisposed()) continue;
            chart.dispose();
        }
        this.charts.clear();
    }

    private LocalDate getDate(DateTime dateTime) {
        int day = dateTime.getDay();
        int month = dateTime.getMonth();
        int year = dateTime.getYear();
        return LocalDate.of(year, month + 1, day);
    }

    private void setDate(DateTime dateTime, LocalDate date) {
        dateTime.setDate(date.getYear(), date.getMonthValue() - 1, date.getDayOfMonth());
    }

    private void showMessage(String message) {
        MessageBox messageBox = new MessageBox(this.fromDate.getShell(), 34);
        messageBox.setMessage(message);
        messageBox.open();
    }

    private void createUpdateChartsButton(final Composite parent) {
        this.updateChartsButton = new Button(parent, 0x800008);
        this.updateChartsButton.setText(Messages.Button_UpdateCharts);
        GridData gridData = new GridData(4, 0x1000000, false, false);
        this.updateChartsButton.setLayoutData((Object)gridData);
        this.updateChartsButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(parent.getDisplay().getSystemColor(2));
                e.gc.setLineWidth(1);
                e.gc.drawRectangle(0, 0, LaborChartComposite.this.updateChartsButton.getSize().x - 1, LaborChartComposite.this.updateChartsButton.getSize().y - 1);
            }
        });
        this.updateChartsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaborChartComposite.this.updateCharts(LaborChartComposite.this.chartsComposite);
            }
        });
    }

    private void createLegendCheckbox(Composite parent) {
        this.legendCheckbox = new Button(parent, 32);
        this.legendCheckbox.setText(Messages.Checkbox_ShowLegend);
        this.legendCheckbox.setSelection(true);
        this.legendCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean showLegend = LaborChartComposite.this.legendCheckbox.getSelection();
                for (Chart chart : LaborChartComposite.this.charts) {
                    if (chart == null || chart.isDisposed()) continue;
                    chart.getLegend().setVisible(showLegend);
                    chart.redraw();
                }
            }
        });
    }

    public void updateCharts(Composite chartsComposite) {
        this.selectedItems = this.parentLaborView.getSelectedItems();
        this.clearCharts();
        LocalDate from = this.getDate(this.fromDate);
        LocalDate to = this.getDate(this.toDate);
        LocalDate currentDate = LocalDate.now();
        boolean showAll = from.isEqual(currentDate) && to.isEqual(currentDate);
        int index = 0;
        for (TreeItem item : this.selectedItems) {
            if (index >= 5) break;
            LaborItemResults laborItemResults = (LaborItemResults)item.getData();
            ArrayList<LabResult> labResults = new ArrayList<LabResult>(laborItemResults.getAllResults());
            List<LabResult> filteredResults = showAll ? labResults : this.filterResultsByDateRange(labResults, from, to);
            if (filteredResults.isEmpty()) continue;
            Chart chart = this.laborChartPopupManager.createChart(chartsComposite, filteredResults, this.actPatient);
            chart.setLayoutData((Object)new GridData(4, 4, true, true));
            chart.getLegend().setVisible(this.legendCheckbox.getSelection());
            this.charts.add(chart);
            ++index;
        }
        this.body.layout(true, true);
        for (Chart chart : this.charts) {
            chart.redraw();
        }
    }

    private List<LabResult> filterResultsByDateRange(List<LabResult> labResults, LocalDate from, LocalDate to) {
        ArrayList<LabResult> filteredResults = new ArrayList<LabResult>();
        for (LabResult result : labResults) {
            LocalDate resultDate;
            TimeTool resultDateTool = result.getAnalyseTime();
            if (resultDateTool == null && (resultDateTool = result.getObservationTime()) == null) {
                resultDateTool = result.getTransmissionTime();
            }
            if (resultDateTool == null || !(resultDate = LocalDate.of(resultDateTool.get(1), resultDateTool.get(2) + 1, resultDateTool.get(5))).isEqual(from) && !resultDate.isAfter(from) || !resultDate.isEqual(to) && !resultDate.isBefore(to)) continue;
            filteredResults.add(result);
        }
        return filteredResults;
    }
}

