/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.jface.preference;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.holder.VirtualFilesystemServiceHolder;
import ch.elexis.core.ui.e4.dialog.VirtualFilesystemUriEditorDialog;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;

public class URIFieldEditor
extends StringButtonFieldEditor {
    private String scheme;

    protected URIFieldEditor() {
    }

    public URIFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.setErrorMessage(JFaceResources.getString((String)"DirectoryFieldEditor.errorMessage"));
        this.setChangeButtonText(JFaceResources.getString((String)"openBrowse"));
        this.createControl(parent);
        this.getTextControl().setEchoChar('*');
        this.getTextControl().setEnabled(false);
    }

    protected void doLoad() {
        String value = this.getPreferenceStore().getString(this.getPreferenceName());
        if (this.getTextControl() != null) {
            this.getTextControl().setText(value);
            this.oldValue = value;
        }
    }

    protected void doStore() {
        super.doStore();
    }

    protected String changePressed() {
        IVirtualFilesystemService virtualFilesystemService = VirtualFilesystemServiceHolder.get();
        URI inputUri = null;
        try {
            String stringValue = this.getStringValue();
            if (StringUtils.isNotBlank((CharSequence)stringValue)) {
                IVirtualFilesystemService.IVirtualFilesystemHandle fileHandle = virtualFilesystemService.of(this.getStringValue(), false);
                inputUri = fileHandle.toURL().toURI();
            }
        }
        catch (IOException | URISyntaxException stringValue) {
            // empty catch block
        }
        VirtualFilesystemUriEditorDialog dialog = new VirtualFilesystemUriEditorDialog(this.getShell(), virtualFilesystemService, inputUri);
        dialog.setFixedScheme(this.scheme);
        if (dialog.open() == 0) {
            return dialog.getValue().toString();
        }
        return null;
    }

    public void setFixedScheme(String scheme) {
        this.scheme = scheme;
    }
}

