/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.dialog;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.IContact;
import ch.elexis.core.time.TimeUtil;
import ch.elexis.core.ui.e4.dialog.DialogTrayWithSelectionListener;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class IContactDetailsDialogTray
extends DialogTrayWithSelectionListener {
    private Text txtFamilyName;
    private Text txtName;
    private Text txtDob;
    private Text txtStreet;
    private Text txtZip;
    private Text txtCity;
    private Text txtTelephone;
    private Text txtMobile;
    private Text txtEmail;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.minimumWidth = 600;
        container.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        layout.marginTop = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        Label lblContactDetails = new Label(container, 0);
        lblContactDetails.setText("Kontaktdaten");
        lblContactDetails.setFont(JFaceResources.getFontRegistry().getBold("default"));
        new Label(container, 0);
        Label lblFamilyName = new Label(container, 0);
        lblFamilyName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFamilyName.setText(Messages.Core_Name);
        this.txtFamilyName = new Text(container, 2048);
        this.txtFamilyName.setEditable(false);
        GridData gd_txtName = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtName.minimumWidth = 300;
        this.txtFamilyName.setLayoutData((Object)gd_txtName);
        Label lblName = new Label(container, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText(Messages.Core_Firstname);
        this.txtName = new Text(container, 2048);
        this.txtName.setEditable(false);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDob = new Label(container, 0);
        lblDob.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDob.setText(Messages.Core_Enter_Birthdate);
        this.txtDob = new Text(container, 2048);
        this.txtDob.setEditable(false);
        this.txtDob.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblStreet = new Label(container, 0);
        lblStreet.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStreet.setText(Messages.Core_Street);
        this.txtStreet = new Text(container, 2048);
        this.txtStreet.setEditable(false);
        this.txtStreet.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblZip = new Label(container, 0);
        lblZip.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblZip.setText(Messages.Core_Postal_code);
        this.txtZip = new Text(container, 2048);
        this.txtZip.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblCity = new Label(container, 0);
        lblCity.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCity.setText(Messages.Core_City);
        this.txtCity = new Text(container, 2048);
        this.txtCity.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblTelephone = new Label(container, 0);
        lblTelephone.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTelephone.setText(Messages.Core_Phone);
        this.txtTelephone = new Text(container, 2048);
        this.txtTelephone.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblMobil = new Label(container, 0);
        lblMobil.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblMobil.setText(Messages.Core_Mobilephone);
        this.txtMobile = new Text(container, 2048);
        this.txtMobile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblEmail = new Label(container, 0);
        lblEmail.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblEmail.setText(Messages.Core_E_Mail);
        this.txtEmail = new Text(container, 2048);
        this.txtEmail.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        container.getShell().setSize(600, 400);
        return container;
    }

    @Override
    public void selectionChanged(Object selection) {
        this.txtFamilyName.setText("");
        this.txtName.setText("");
        this.txtStreet.setText("");
        this.txtZip.setText("");
        this.txtCity.setText("");
        this.txtTelephone.setText("");
        this.txtMobile.setText("");
        this.txtEmail.setText("");
        this.txtDob.setText("");
        if (selection instanceof IContact) {
            IContact contact = (IContact)selection;
            this.txtFamilyName.setText(StringUtils.trimToEmpty((String)contact.getDescription1()));
            this.txtName.setText(StringUtils.trimToEmpty((String)contact.getDescription2()));
            this.txtStreet.setText(StringUtils.trimToEmpty((String)contact.getStreet()));
            this.txtZip.setText(StringUtils.trimToEmpty((String)contact.getZip()));
            this.txtCity.setText(StringUtils.trimToEmpty((String)contact.getCity()));
            this.txtTelephone.setText(StringUtils.trimToEmpty((String)contact.getPhone1()));
            this.txtMobile.setText(StringUtils.trimToEmpty((String)contact.getMobile()));
            this.txtEmail.setText(StringUtils.trimToEmpty((String)contact.getEmail()));
            if (contact.isPerson()) {
                LocalDateTime dateOfBirth = contact.asIPerson().getDateOfBirth();
                this.txtDob.setText(TimeUtil.formatSafe((LocalDate)(dateOfBirth != null ? dateOfBirth.toLocalDate() : null)));
            }
        }
    }
}

