/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.e4.dialog;

import ch.elexis.core.l10n.Messages;
import ch.elexis.core.model.Identifiable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GenericSelectionDialog
extends TitleAreaDialog {
    private List<?> input;
    private Map<Object, Button> buttonMap = new HashMap<Object, Button>();
    private List<Object> selection = new LinkedList<Object>();
    private String title;
    private String message;
    private Text txtSearch;
    private LabelProvider labelProvider;

    public GenericSelectionDialog(Shell parentShell, List<?> input, String title, String message) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.input = input;
        this.setBlockOnOpen(true);
    }

    public GenericSelectionDialog(Shell parentShell, List<?> input) {
        this(parentShell, input, "Auswahl", null);
    }

    public void setSelection(List<Object> selection) {
        this.selection = new LinkedList<Object>(selection);
    }

    public IStructuredSelection getSelection() {
        return new StructuredSelection(this.selection);
    }

    public void setLabelProvider(LabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    protected Control createDialogArea(Composite parent) {
        boolean showSearch;
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite ret = (Composite)super.createDialogArea(parent);
        ret.setLayout((Layout)new GridLayout(1, false));
        boolean bl = showSearch = this.input != null && this.input.size() > 10;
        if (showSearch) {
            this.txtSearch = new Text(ret, 2944);
            this.txtSearch.setMessage(Messages.AddLinkDialog_searchCaption);
            this.txtSearch.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        } else {
            this.txtSearch = null;
        }
        final ScrolledComposite sc = new ScrolledComposite(ret, 768);
        final Composite child = new Composite((Composite)sc, 0);
        child.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 400;
        sc.setLayoutData((Object)data);
        for (final Object object : this.input) {
            final Button button = new Button(child, 32);
            button.setText(this.getLabel(object));
            button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (button.getSelection()) {
                        GenericSelectionDialog.this.selection.add(object);
                    } else {
                        GenericSelectionDialog.this.selection.remove(object);
                    }
                }
            });
            this.buttonMap.put(object, button);
        }
        sc.setMinSize(child.computeSize(-1, -1));
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setContent((Control)child);
        this.updateSelectionUi();
        if (this.txtSearch != null) {
            this.txtSearch.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String pattern = GenericSelectionDialog.this.txtSearch.getText().trim().toLowerCase();
                    boolean doFilter = pattern.length() >= 2;
                    for (Map.Entry<Object, Button> entry : GenericSelectionDialog.this.buttonMap.entrySet()) {
                        Button b = entry.getValue();
                        String text = b.getText().toLowerCase();
                        boolean visible = !doFilter ? true : text.contains(pattern);
                        GridData gd = (GridData)b.getLayoutData();
                        if (gd == null) {
                            gd = new GridData(4, 0x1000000, true, false);
                            b.setLayoutData((Object)gd);
                        }
                        gd.exclude = !visible;
                        b.setVisible(visible);
                    }
                    child.layout(true, true);
                    sc.setMinSize(child.computeSize(-1, -1));
                }
            });
        }
        return ret;
    }

    private void updateSelectionUi() {
        if (this.selection != null && !this.selection.isEmpty() && !this.buttonMap.isEmpty()) {
            for (Object object : this.selection) {
                this.buttonMap.get(object).setSelection(true);
            }
        }
    }

    private String getLabel(Object object) {
        if (this.labelProvider != null) {
            return this.labelProvider.getText(object);
        }
        if (object instanceof Identifiable) {
            return ((Identifiable)object).getLabel();
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    protected boolean isResizable() {
        return true;
    }
}

