/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.documents.views;

import ch.elexis.core.documents.FilterCategory;
import ch.elexis.core.model.ICategory;
import ch.elexis.core.model.IDocument;
import ch.elexis.core.model.IPatient;
import ch.elexis.core.ui.documents.service.DocumentStoreServiceHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class DocumentsTreeContentProvider
implements ITreeContentProvider {
    private Map<ICategory, List<IDocument>> documentsMap = new HashMap<ICategory, List<IDocument>>();
    private FilterCategory selectedFilter = null;
    private boolean flat;
    private TreeViewer viewer;
    private IPatient currentPatient;

    public DocumentsTreeContentProvider(TreeViewer viewer) {
        this.viewer = viewer;
        this.flat = false;
    }

    public void setFlat(boolean value) {
        this.flat = value;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput instanceof IPatient) {
            this.loadByFilterCategory((IPatient)newInput);
        } else {
            this.documentsMap.clear();
        }
    }

    public DocumentsTreeContentProvider selectFilterCategory(ISelection selection) {
        Object element;
        StructuredSelection sel = (StructuredSelection)selection;
        if (selection != null && (element = sel.getFirstElement()) instanceof FilterCategory) {
            this.selectedFilter = (FilterCategory)element;
            if (this.viewer != null) {
                this.viewer.refresh(true);
                this.viewer.expandAll();
            }
        }
        return this;
    }

    private void loadByFilterCategory(IPatient newInput) {
        if (newInput != this.currentPatient && newInput != null) {
            if (this.selectedFilter.isAll()) {
                this.documentsMap = DocumentStoreServiceHolder.getService().getDocumentsByPatientId(newInput.getId());
                if (this.viewer != null) {
                    this.viewer.refresh(true);
                }
            } else {
                this.loadElementsByCategory(newInput.getId(), (ICategory)this.selectedFilter);
            }
        }
        this.currentPatient = newInput;
    }

    public void updateElement(IDocument iDocument) {
        if (iDocument != null && !"text/category".equals(iDocument.getMimeType())) {
            this.removeFromCategories(iDocument);
            FilterCategory filterCategory = new FilterCategory(iDocument.getCategory());
            List<IDocument> categoryDocuments = this.documentsMap.get(filterCategory);
            if (categoryDocuments != null) {
                if (!categoryDocuments.contains(iDocument) && !iDocument.isDeleted()) {
                    categoryDocuments.add(iDocument);
                } else if (categoryDocuments.contains(iDocument) && iDocument.isDeleted()) {
                    categoryDocuments.remove(iDocument);
                }
            } else if (!iDocument.isDeleted()) {
                categoryDocuments = new ArrayList<IDocument>();
                categoryDocuments.add(iDocument);
                this.documentsMap.put((ICategory)filterCategory, categoryDocuments);
            }
        }
    }

    private void removeFromCategories(IDocument iDocument) {
        HashSet<ICategory> categories = new HashSet<ICategory>(this.documentsMap.keySet());
        for (ICategory category : categories) {
            List<IDocument> categoryDocuments = this.documentsMap.get(category);
            categoryDocuments.remove(iDocument);
            if (!categoryDocuments.isEmpty()) continue;
            this.documentsMap.remove(category);
        }
    }

    private void loadElementsByCategory(String patientId, ICategory iCategory) {
        List iDocuments;
        if (!(iCategory instanceof FilterCategory && this.documentsMap.get(iCategory) != null || (iDocuments = DocumentStoreServiceHolder.getService().getDocumentsByCategory(patientId, iCategory)).isEmpty())) {
            this.documentsMap.put((ICategory)new FilterCategory(((IDocument)iDocuments.get(0)).getCategory()), iDocuments);
        }
        if (this.viewer != null) {
            this.viewer.refresh(true);
        }
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (this.documentsMap.isEmpty() && parent != null && parent instanceof IPatient) {
            this.loadByFilterCategory((IPatient)parent);
        }
        Object[] categories = this.getFilteredCategories();
        if (this.flat) {
            if (categories.length == 1) {
                return this.getChildren(categories[0]);
            }
            return Arrays.stream(categories).flatMap(o -> Arrays.stream(this.getChildren(o))).toArray();
        }
        return categories;
    }

    private Object[] getFilteredCategories() {
        if (this.selectedFilter.isAll()) {
            ArrayList<ICategory> keys = new ArrayList<ICategory>(this.documentsMap.keySet());
            return keys.toArray();
        }
        if (this.documentsMap.containsKey(this.selectedFilter)) {
            return new Object[]{this.selectedFilter};
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ICategory && this.documentsMap.containsKey(parentElement)) {
            return this.documentsMap.get(parentElement).toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof IDocument) {
            IDocument dh = (IDocument)element;
            return new FilterCategory(dh.getCategory());
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.documentsMap.containsKey(element);
    }

    public void setViewer(TreeViewer treeViewer) {
        this.viewer = treeViewer;
    }
}

