/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.ui.dbcheck.contributions;

import ch.elexis.core.data.service.LocalLockServiceHolder;
import ch.elexis.core.data.util.NoPoUtil;
import ch.elexis.core.lock.types.LockResponse;
import ch.elexis.core.model.IBillable;
import ch.elexis.core.model.IBilled;
import ch.elexis.core.model.ICodeElement;
import ch.elexis.core.model.ICoverage;
import ch.elexis.core.model.IEncounter;
import ch.elexis.core.services.ICodeElementService;
import ch.elexis.core.services.holder.BillingServiceHolder;
import ch.elexis.core.services.holder.ConfigServiceHolder;
import ch.elexis.core.services.holder.ContextServiceHolder;
import ch.elexis.core.ui.dbcheck.external.ExternalMaintenance;
import ch.elexis.data.Konsultation;
import ch.elexis.data.PersistentObject;
import ch.elexis.data.Query;
import ch.rgw.tools.Result;
import ch.rgw.tools.TimeTool;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public class ReChargeTardocOpenCons
extends ExternalMaintenance {
    private List<String> problems = new ArrayList<String>();
    protected ICodeElementService codeElementService;
    private ServiceReference<ICodeElementService> serviceRef;
    private boolean currentMandantOnly;

    @Override
    public String executeMaintenance(IProgressMonitor pm, String DBVersion) {
        Integer count = 0;
        if (this.initCodeElementService()) {
            this.getCurrentMandantOnly();
            boolean presetBillingStrict = ConfigServiceHolder.getUser((String)"billing/strict", (boolean)false);
            ConfigServiceHolder.setUser((String)"billing/strict", (boolean)false);
            List<Konsultation> consultations = this.getKonsultation(this.getBeginOfYear(), this.getYesterday());
            pm.beginTask("Bitte warten, TARDOC Leistungen werden neu verrechnet", consultations.size());
            for (Konsultation konsultation : consultations) {
                if (konsultation.getRechnung() != null) continue;
                IEncounter encounter = (IEncounter)NoPoUtil.loadAsIdentifiable((PersistentObject)konsultation, IEncounter.class).get();
                if (pm.isCanceled()) {
                    this.addProblem("Cancelled.", encounter);
                    return this.getProblemsString();
                }
                List<IBilled> tardocVerrechnet = this.getTardocOnly(encounter.getBilled());
                List<IBilled> tardocZuschlagVerrechnet = tardocVerrechnet.stream().filter(v -> this.isZuschlag((IBilled)v)).toList();
                tardocVerrechnet.removeAll(tardocZuschlagVerrechnet);
                List<IBilled> tardocReferenzVerrechnet = tardocVerrechnet.stream().filter(v -> this.isReferenz((IBilled)v)).toList();
                tardocVerrechnet.removeAll(tardocReferenzVerrechnet);
                this.reCharge(tardocVerrechnet, encounter);
                this.reCharge(tardocZuschlagVerrechnet, encounter);
                this.reCharge(tardocReferenzVerrechnet, encounter);
                count = count + 1;
                pm.worked(1);
            }
            ConfigServiceHolder.setUser((String)"billing/strict", (boolean)presetBillingStrict);
            pm.done();
            this.deInitCodeElementService();
        }
        return "TARDOC Leistungen von [" + String.valueOf(count) + "] Konsultationen des Jahres [" + this.getBeginOfYear().get(1) + "] neu verrechnet" + this.getProblemsString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<ICodeElement> getMatchingVerrechenbar(IBilled tardocVerr, IEncounter encounter) {
        IBillable verrechenbar = tardocVerr.getBillable();
        if (verrechenbar != null) {
            Optional matchingVerrechenbar = this.codeElementService.loadFromString(verrechenbar.getCodeSystemName(), verrechenbar.getCode(), this.getContext(encounter));
            if (!matchingVerrechenbar.isEmpty()) return matchingVerrechenbar;
            this.addProblem("Could not find matching Verrechenbar for [" + verrechenbar.getCodeSystemName() + "->" + verrechenbar.getCode() + "]", encounter);
            return Optional.empty();
        } else {
            this.addProblem("Could not find Verrechenbar for [" + tardocVerr.getLabel() + "]", encounter);
        }
        return Optional.empty();
    }

    private void reCharge(List<IBilled> tardocVerrechnet, IEncounter encounter) {
        HashMap amountMap = new HashMap();
        HashMap verrechenbarMap = new HashMap();
        tardocVerrechnet.forEach(v -> {
            Double d = amountMap.put(v, v.getAmount());
        });
        tardocVerrechnet.forEach(v -> this.getMatchingVerrechenbar((IBilled)v, encounter).ifPresent(c -> {
            ICodeElement iCodeElement = verrechenbarMap.put(v, c);
        }));
        tardocVerrechnet = tardocVerrechnet.stream().filter(v -> verrechenbarMap.containsKey(v)).toList();
        tardocVerrechnet.forEach(v -> this.removeVerrechnet(encounter, (IBilled)v));
        tardocVerrechnet.forEach(v -> this.addVerrechnet(encounter, (ICodeElement)verrechenbarMap.get(v), (Double)amountMap.get(v)));
    }

    private boolean isReferenz(IBilled tardocVerr) {
        IBillable verrechenbar = tardocVerr.getBillable();
        String serviceTyp = this.getServiceTypReflective(verrechenbar);
        return serviceTyp != null && serviceTyp.equals("R");
    }

    private boolean isZuschlag(IBilled tardocVerr) {
        IBillable verrechenbar = tardocVerr.getBillable();
        Boolean serviceTyp = this.getIsZuschlagsleistungReflective(verrechenbar);
        return serviceTyp != null && serviceTyp != false;
    }

    private String getServiceTypReflective(IBillable billable) {
        try {
            Method getterMethod = billable.getClass().getMethod("getServiceTyp", null);
            Object typ = getterMethod.invoke((Object)billable, null);
            if (typ instanceof String) {
                return (String)typ;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not get service typ of [" + String.valueOf(billable) + "]", (Object)e.getMessage());
        }
        return null;
    }

    private Boolean getIsZuschlagsleistungReflective(IBillable billable) {
        try {
            Method getterMethod = billable.getClass().getMethod("isZuschlagsleistung", null);
            Object typ = getterMethod.invoke((Object)billable, null);
            if (typ instanceof Boolean) {
                return (Boolean)typ;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Could not get service typ of [" + String.valueOf(billable) + "]", (Object)e.getMessage());
        }
        return null;
    }

    private void getCurrentMandantOnly() {
        Display.getDefault().syncExec(() -> {
            this.currentMandantOnly = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)"Nur Mandant neu verrechnen", (String)"Sollen die offenen Konsultationen aller Mandanten (Nein), oder nur des aktiven (Ja) neu verrechnet werden?");
        });
    }

    protected TimeTool getBeginOfYear() {
        TimeTool beginOfYear = new TimeTool();
        beginOfYear.set(2, 0);
        beginOfYear.set(5, 1);
        return beginOfYear;
    }

    protected TimeTool getEndOfYear() {
        TimeTool endOfYear = this.getBeginOfYear();
        endOfYear.set(2, 11);
        endOfYear.set(5, 31);
        return endOfYear;
    }

    private TimeTool getYesterday() {
        return new TimeTool(LocalDate.now().minusDays(1L));
    }

    private void addVerrechnet(IEncounter encounter, ICodeElement matchingVerrechenbar, double amount) {
        int i = 0;
        while ((double)i < amount) {
            Result addRes = BillingServiceHolder.get().bill((IBillable)matchingVerrechenbar, encounter, 1.0);
            if (!addRes.isOK()) {
                this.addProblem("Could not add Verrechenbar [" + matchingVerrechenbar.getCode() + "][" + addRes.toString() + "]", encounter);
            }
            ++i;
        }
    }

    private void removeVerrechnet(IEncounter encounter, IBilled tardocVerr) {
        LockResponse result = LocalLockServiceHolder.get().acquireLockBlocking((Object)tardocVerr, 10, (IProgressMonitor)new NullProgressMonitor());
        if (result.isOk()) {
            LockResponse releaseLock;
            Result removeRes = BillingServiceHolder.get().removeBilled(tardocVerr, encounter);
            if (!removeRes.isOK()) {
                this.addProblem("Could not remove Verrechnet [" + tardocVerr.getLabel() + "][" + removeRes.toString() + "]", encounter);
            }
            if (!(releaseLock = LocalLockServiceHolder.get().releaseLock(result.getLockInfo())).isOk()) {
                this.addProblem("Could not release lock for Verrechnet [" + tardocVerr.getLabel() + "][" + removeRes.toString() + "]", encounter);
            }
        } else {
            this.addProblem("Could not remove Verrechnet [" + tardocVerr.getLabel() + "][ could not acquire lock ]", encounter);
        }
    }

    private HashMap<Object, Object> getContext(IEncounter encounter) {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        if (encounter != null) {
            ret.put(ICodeElementService.ContextKeys.CONSULTATION, encounter);
            ICoverage coverage = encounter.getCoverage();
            if (coverage != null) {
                ret.put(ICodeElementService.ContextKeys.COVERAGE, coverage);
            }
        }
        return ret;
    }

    private void deInitCodeElementService() {
        BundleContext context = FrameworkUtil.getBundle(ReChargeTardocOpenCons.class).getBundleContext();
        if (this.serviceRef != null) {
            context.ungetService(this.serviceRef);
            this.codeElementService = null;
        }
    }

    private boolean initCodeElementService() {
        BundleContext context = FrameworkUtil.getBundle(ReChargeTardocOpenCons.class).getBundleContext();
        this.serviceRef = context.getServiceReference(ICodeElementService.class);
        if (this.serviceRef != null) {
            this.codeElementService = (ICodeElementService)context.getService(this.serviceRef);
            return true;
        }
        return false;
    }

    private List<IBilled> getTardocOnly(List<IBilled> list) {
        ArrayList<IBilled> ret = new ArrayList<IBilled>();
        for (IBilled verrechnet : list) {
            IBillable billable = verrechnet.getBillable();
            if (!billable.getCodeSystemName().contains("TARDOC")) continue;
            ret.add(verrechnet);
        }
        return ret;
    }

    public List<Konsultation> getKonsultation(TimeTool from, TimeTool to) {
        Query qbe = new Query(Konsultation.class);
        qbe.add("Datum", ">=", from.toString(9));
        if (to != null) {
            qbe.add("Datum", "<=", to.toString(9));
        }
        if (this.currentMandantOnly) {
            qbe.add("MandantID", "=", ContextServiceHolder.getActiveMandatorOrNull().getId());
        }
        return qbe.execute();
    }

    private String getProblemsString() {
        if (this.problems != null && !this.problems.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\nProblems:\n");
            this.problems.stream().forEach(problem -> {
                StringBuilder stringBuilder2 = sb.append(problem + "\n");
            });
            return sb.toString();
        }
        return "";
    }

    private void addProblem(String prefix, IEncounter cons) {
        this.problems.add("[" + prefix + "][" + cons.getId() + "] - [" + cons.getLabel() + "] of [" + cons.getPatient().getLabel() + "]");
    }

    @Override
    public String getMaintenanceDescription() {
        return "TARDOC Leistungen aller offenen Konsultationen dieses Jahres neu verrechnen";
    }
}

