/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.ui.internal.ready;

import ch.elexis.core.model.IAppointment;
import ch.elexis.core.services.IAppointmentService;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.spotlight.ui.internal.ready.PatientSelectionHistorySupplier;
import ch.elexis.core.spotlight.ui.internal.ready.SpotlightReadyRefreshTimerTask;
import ch.elexis.core.ui.e4.util.CoreUiUtil;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={SpotlightReadyService.class})
public class SpotlightReadyService {
    private static final String PATIENT_SELECTION_HISTORY = "patient-selection-history";
    @Reference
    private IContextService contextService;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService coreModelService;
    @Reference
    private IAppointmentService appointmentService;
    private Timer timer;
    private SpotlightReadyRefreshTimerTask spotlightReadyRefreshTimerTask;

    @Activate
    public void activate() {
        PatientSelectionHistorySupplier patientSelectionHistorySupplier = new PatientSelectionHistorySupplier();
        CoreUiUtil.injectServicesWithContext((Object)patientSelectionHistorySupplier);
        this.contextService.getRootContext().setNamed(PATIENT_SELECTION_HISTORY, (Object)patientSelectionHistorySupplier);
        this.timer = new Timer("spotlight-ready-refresh");
        this.spotlightReadyRefreshTimerTask = new SpotlightReadyRefreshTimerTask(this.contextService, this.coreModelService, this.appointmentService);
        CoreUiUtil.injectServicesWithContext((Object)this.spotlightReadyRefreshTimerTask);
        this.timer.schedule((TimerTask)this.spotlightReadyRefreshTimerTask, 1000L, 20000L);
    }

    @Deactivate
    public void deactivate() {
        this.timer.cancel();
    }

    public List<Object[]> getLastPatientSelections() {
        return (List)this.contextService.getRootContext().getNamed(PATIENT_SELECTION_HISTORY).get();
    }

    public IAppointment getNextAppointment() {
        return this.spotlightReadyRefreshTimerTask.getNextAppointment();
    }

    public String getNextAppointmentLabel() {
        return this.spotlightReadyRefreshTimerTask.getNextAppointmentLabel();
    }

    public long getInfoAgeInSeconds() {
        return this.spotlightReadyRefreshTimerTask.getInfoAgeInSeconds();
    }

    public Long getNewLabValuesCount() {
        return this.spotlightReadyRefreshTimerTask.getNewLabValuesCount();
    }

    public Long getNewDocumentsCount() {
        return this.spotlightReadyRefreshTimerTask.getNewDocumentsCount();
    }
}

