/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.spotlight.ui.internal.ready;

import ch.elexis.core.spotlight.ISpotlightResultEntry;
import ch.elexis.core.spotlight.ui.internal.CustomLinkWithOptionalImage;
import ch.elexis.core.spotlight.ui.internal.SpotlightShell;
import ch.elexis.core.spotlight.ui.internal.ready.SpotlightReadyService;
import ch.elexis.core.ui.icons.Images;
import java.util.function.Supplier;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class SpotlightReadyComposite
extends Composite {
    private SpotlightReadyService spotlightReadyService;
    private CustomLinkWithOptionalImage nextAppointment;
    private CustomLinkWithOptionalImage newLabValues;
    private CustomLinkWithOptionalImage newDocuments;
    private ListViewer listViewerLastPatients;
    private static final String NEW_LABVALUES_TEMPLATE = "%s neue Laborwerte";
    private static final String NEW_DOCUMENTS_TEMPLATE = "%s neue Dokumente";

    public SpotlightReadyComposite(Composite parent, int style, EPartService partService, SpotlightReadyService spotlightReadyService) {
        super(parent, style);
        this.spotlightReadyService = spotlightReadyService;
        GridLayout gridLayout = new GridLayout(2, true);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        Font boldDefaultFont = JFaceResources.getFontRegistry().getBold("default");
        Composite compositeLeft = new Composite((Composite)this, 0);
        compositeLeft.setLayout((Layout)new GridLayout(1, false));
        compositeLeft.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblNextAppointment = new Label(compositeLeft, 0);
        lblNextAppointment.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblNextAppointment.setText("N\u00e4chster Termin");
        lblNextAppointment.setFont(boldDefaultFont);
        this.nextAppointment = new CustomLinkWithOptionalImage(compositeLeft, 64, null);
        this.nextAppointment.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblLastPatients = new Label(compositeLeft, 0);
        lblLastPatients.setText("Patientenverlauf");
        lblLastPatients.setFont(boldDefaultFont);
        this.listViewerLastPatients = new ListViewer(compositeLeft, 512);
        this.listViewerLastPatients.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.listViewerLastPatients.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Object[] _element = (Object[])element;
                return _element[2].toString() + " (" + _element[1].toString() + ")";
            }
        });
        this.listViewerLastPatients.addSelectionChangedListener(event -> {
            Object[] firstElement = (Object[])event.getStructuredSelection().getFirstElement();
            if (firstElement != null) {
                ((SpotlightShell)this.getShell()).setSelectedElement(ISpotlightResultEntry.Category.PATIENT.name() + "::" + String.valueOf(firstElement[0]));
            } else {
                ((SpotlightShell)this.getShell()).setSelectedElement(null);
            }
        });
        List listLastPatients = this.listViewerLastPatients.getList();
        listLastPatients.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        listLastPatients.setBackground(this.getBackground());
        listLastPatients.addListener(15, event -> {
            int itemCount = listLastPatients.getItemCount();
            if (itemCount >= 1) {
                this.listViewerLastPatients.setSelection((ISelection)new StructuredSelection((Object)listLastPatients.getItem(0)));
            }
            listLastPatients.setSelection(0);
        });
        listLastPatients.addListener(16, event -> this.listViewerLastPatients.setSelection(null));
        compositeLeft.setTabList(new Control[]{this.nextAppointment, listLastPatients});
        Composite compositeRight = new Composite((Composite)this, 0);
        compositeRight.setLayout((Layout)new GridLayout(1, false));
        compositeRight.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        CustomLinkWithOptionalImage openReminders = new CustomLinkWithOptionalImage(compositeRight, 0, Images.IMG_BELL_EXCLAMATION.getImage());
        openReminders.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        openReminders.getLink().setText("? Pendenzen");
        Supplier<Boolean> jumpToInboxViewSupplier = () -> {
            partService.showPart("at.medevit.elexis.inbox.ui.view", EPartService.PartState.ACTIVATE);
            return false;
        };
        this.newDocuments = new CustomLinkWithOptionalImage(compositeRight, 0, Images.IMG_DOCUMENT.getImage());
        this.newDocuments.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.newDocuments.setData(jumpToInboxViewSupplier);
        this.newLabValues = new CustomLinkWithOptionalImage(compositeRight, 0, Images.IMG_VIEW_LABORATORY.getImage());
        this.newLabValues.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.newLabValues.setData(jumpToInboxViewSupplier);
        compositeRight.setTabList(new Control[]{openReminders, this.newDocuments, this.newLabValues});
        Label lblUpdateTime = new Label((Composite)this, 0);
        lblUpdateTime.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        lblUpdateTime.setText("Aktualisiert vor " + spotlightReadyService.getInfoAgeInSeconds() + " Sekunden.");
        this.setTabList(new Control[]{compositeLeft, compositeRight});
        this.refresh();
    }

    private void refresh() {
        this.nextAppointment.getLink().setText(this.spotlightReadyService.getNextAppointmentLabel());
        this.nextAppointment.setData(this.spotlightReadyService.getNextAppointment());
        this.listViewerLastPatients.setInput(this.spotlightReadyService.getLastPatientSelections());
        Long newLabValuesCount = this.spotlightReadyService.getNewLabValuesCount();
        if (newLabValuesCount == null) {
            newLabValuesCount = -1L;
        }
        String newLabValuesCountText = newLabValuesCount > 1000L ? "> 1000" : newLabValuesCount.toString();
        this.newLabValues.getLink().setText(String.format(NEW_LABVALUES_TEMPLATE, newLabValuesCountText));
        Long newDocumentsCount = this.spotlightReadyService.getNewDocumentsCount();
        if (newDocumentsCount == null) {
            newDocumentsCount = -1L;
        }
        String newDocumentsCountText = newDocumentsCount > 1000L ? "> 1000" : newDocumentsCount.toString();
        this.newDocuments.getLink().setText(String.format(NEW_DOCUMENTS_TEMPLATE, newDocumentsCountText));
    }
}

