/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.model.IUser;
import ch.elexis.core.services.IContextService;
import ch.elexis.core.services.IModelService;
import ch.elexis.core.services.ITraceService;
import ch.elexis.core.utils.OsgiServiceUtil;
import ch.rgw.tools.net.NetTool;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component
public class TraceService
implements ITraceService {
    private ExecutorService traceExecutor;
    @Reference(target="(service.model.name=ch.elexis.core.model)")
    private IModelService modelService;

    @Activate
    public void activate() {
        this.traceExecutor = Executors.newSingleThreadExecutor();
    }

    @Deactivate
    public void deactivate() {
        this.traceExecutor.shutdown();
    }

    public void addTraceEntry(String username, String workstation, String action) {
        this.traceExecutor.execute(() -> {
            String _workstation = StringUtils.abbreviate((String)workstation, (int)40);
            String _username = StringUtils.abbreviate((String)username, (int)30);
            String _action = StringUtils.isEmpty((CharSequence)action) ? "" : action;
            String insertStatement = "INSERT INTO TRACES (logtime, workstation, username, action) VALUES(" + System.currentTimeMillis() + ", '" + _workstation + "', '" + _username + "', '" + _action + "')";
            this.modelService.executeNativeUpdate(insertStatement, false);
        });
    }

    public void addTraceEntry(String action) {
        String username = null;
        String workstation = NetTool.hostname;
        Optional contextService = OsgiServiceUtil.getService(IContextService.class);
        if (contextService.isPresent()) {
            Optional user = ((IContextService)contextService.get()).getActiveUser();
            if (user.isPresent()) {
                username = ((IUser)user.get()).getId();
            }
            OsgiServiceUtil.ungetService(contextService.get());
        }
        this.addTraceEntry(username, workstation, action);
    }
}

