/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services;

import ch.elexis.core.interfaces.IReferenceDataImporter;
import ch.elexis.core.services.IReferenceDataImporterService;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.LoggerFactory;

@Component
public class ReferenceDataImporterService
implements IReferenceDataImporterService {
    private HashMap<String, IReferenceDataImporter> importersMap = new HashMap();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setReferenceDataImporter(IReferenceDataImporter referenceDataImporter, Map<String, Object> properties) {
        IReferenceDataImporter previous = this.importersMap.put((String)properties.get("referenceDataId"), referenceDataImporter);
        if (previous != null) {
            LoggerFactory.getLogger(this.getClass()).warn("Possible IReferenceDataImporter collision previous [" + String.valueOf(previous) + "] new [" + String.valueOf(referenceDataImporter) + "]");
        }
    }

    public void unsetReferenceDataImporter(IReferenceDataImporter referenceDataImporter, Map<String, Object> properties) {
        this.importersMap.remove((String)properties.get("referenceDataId"));
        LoggerFactory.getLogger(this.getClass()).info("Removed IReferenceDataImporter [" + String.valueOf(referenceDataImporter) + "]");
    }

    public Optional<IReferenceDataImporter> getImporter(String referenceDataId) {
        return Optional.ofNullable(this.importersMap.get(referenceDataId));
    }
}

