/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.vfs;

import ch.elexis.core.services.IVirtualFilesystemService;
import ch.elexis.core.services.vfs.AbstractVirtualFileHandleTest;
import ch.elexis.core.utils.OsgiServiceUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class VirtualFileHandle_FileDirectory_Test
extends AbstractVirtualFileHandleTest {
    @BeforeClass
    public static void beforeClass() throws IOException {
        service = (IVirtualFilesystemService)OsgiServiceUtil.getService(IVirtualFilesystemService.class).get();
        tempDirectory = Files.createTempDirectory("virtualFilesystemTest_filedirectory", new FileAttribute[0]);
        testDirectory = new File(tempDirectory.toFile(), "subDir/");
        Assert.assertTrue((boolean)testDirectory.mkdir());
        testDirectory.deleteOnExit();
        testHandle = service.of(testDirectory);
        Assert.assertTrue((boolean)testHandle.isDirectory());
    }

    @AfterClass
    public static void afterClass() throws IOException {
        FileUtils.deleteDirectory((File)tempDirectory.toFile());
    }

    @Test(expected=IOException.class)
    public void testOpenOutputStream() throws IOException {
        testHandle.openOutputStream();
    }

    @Test
    public void testCopyTo() throws IOException {
        File copyToFile = new File(testDirectory, "copyToFile");
        copyToFile.createNewFile();
        IVirtualFilesystemService.IVirtualFilesystemHandle srcFile = service.of(copyToFile);
        IVirtualFilesystemService.IVirtualFilesystemHandle dstFile = srcFile.copyTo(testHandle);
        File _srcFile = (File)srcFile.toFile().get();
        File _dstFile = (File)dstFile.toFile().get();
        Assert.assertTrue((boolean)_srcFile.canRead());
        Assert.assertTrue((boolean)_dstFile.canRead());
        Assert.assertEquals((long)_srcFile.length(), (long)_dstFile.length());
    }

    @Test
    public void testGetParent() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle parent = testHandle.getParent();
        Assert.assertEquals((Object)tempDirectory.toFile(), parent.toFile().get());
    }

    @Test
    public void testListHandles() throws IOException {
        File file = new File((File)testHandle.toFile().get(), "listingFile.txt");
        Assert.assertTrue((boolean)file.createNewFile());
        File fileWithSpace = new File((File)testHandle.toFile().get(), "space listingFile.txt");
        Assert.assertTrue((boolean)fileWithSpace.createNewFile());
        IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles = testHandle.listHandles();
        Assert.assertEquals((long)2L, (long)listHandles.length);
        IVirtualFilesystemService.IVirtualFilesystemHandle[] iVirtualFilesystemHandleArray = listHandles;
        int n = listHandles.length;
        int n2 = 0;
        while (n2 < n) {
            IVirtualFilesystemService.IVirtualFilesystemHandle ivfsh = iVirtualFilesystemHandleArray[n2];
            if (ivfsh.getName().contains("space")) {
                Assert.assertEquals((Object)fileWithSpace, ivfsh.toFile().get());
            } else {
                Assert.assertEquals((Object)file, ivfsh.toFile().get());
            }
            ++n2;
        }
        Assert.assertTrue((boolean)file.delete());
        Assert.assertTrue((boolean)fileWithSpace.delete());
    }

    @Test
    public void testListHandlesIVirtualFilesystemhandleFilter() throws IOException {
        File file = new File((File)testHandle.toFile().get(), "listingFile.txt");
        Assert.assertTrue((boolean)file.createNewFile());
        File file1 = new File((File)testHandle.toFile().get(), "test file.txt");
        Assert.assertTrue((boolean)file1.createNewFile());
        File file2 = new File((File)testHandle.toFile().get(), "listingFile.txta");
        Assert.assertTrue((boolean)file2.createNewFile());
        IVirtualFilesystemService.IVirtualFilesystemHandle[] listHandles = testHandle.listHandles(handle -> "txt".equalsIgnoreCase(handle.getExtension()));
        Assert.assertEquals((long)2L, (long)listHandles.length);
        Assert.assertTrue((boolean)file.delete());
        Assert.assertTrue((boolean)file1.delete());
        Assert.assertTrue((boolean)file2.delete());
    }

    @Test
    public void testDelete() throws IOException {
        testHandle.delete();
        Assert.assertFalse((boolean)testDirectory.exists());
        Assert.assertTrue((boolean)testDirectory.mkdir());
    }

    @Test
    public void testToURL() throws MalformedURLException {
        Assert.assertEquals((Object)testDirectory.toURI().toURL(), (Object)testHandle.toURL());
    }

    @Test
    public void testIsDirectory() throws IOException {
        Assert.assertTrue((boolean)testHandle.isDirectory());
    }

    @Test
    public void testToFile() {
        Assert.assertEquals((Object)testDirectory, testHandle.toFile().get());
    }

    @Test
    public void testGetExtension() {
        Assert.assertEquals((Object)"", (Object)testHandle.getExtension());
    }

    @Test
    public void testExists() throws IOException {
        Assert.assertTrue((boolean)testDirectory.delete());
        Assert.assertFalse((boolean)testHandle.exists());
        Assert.assertTrue((boolean)testDirectory.mkdir());
        Assert.assertTrue((boolean)testHandle.exists());
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"subDir", (Object)testHandle.getName());
    }

    @Test
    public void testCanRead() {
        Assert.assertTrue((boolean)testHandle.canRead());
    }

    @Test
    public void testGetAbsolutePath() {
        Assert.assertEquals((Object)testDirectory.toURI().toString(), (Object)testHandle.getAbsolutePath());
    }

    @Test
    public void testMoveTo() throws IOException {
        File moveToFile = new File(tempDirectory.toFile(), "moveToFile_2");
        Assert.assertTrue((boolean)moveToFile.createNewFile());
        IVirtualFilesystemService.IVirtualFilesystemHandle vfh_moveTo = service.of(moveToFile);
        IVirtualFilesystemService.IVirtualFilesystemHandle vfh_target = vfh_moveTo.moveTo(service.of(testDirectory));
        Assert.assertNotEquals((Object)vfh_moveTo, (Object)vfh_target);
        Assert.assertFalse((boolean)moveToFile.exists());
        Assert.assertTrue((boolean)((File)vfh_target.toFile().get()).exists());
    }

    @Test
    public void testSubDir() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle subDir = testHandle.subDir("subdir");
        Assert.assertFalse((boolean)subDir.exists());
        subDir.mkdir();
        Assert.assertTrue((boolean)subDir.exists());
    }

    @Test
    public void testSubFile() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle subFile = testHandle.subFile("subfile");
        Assert.assertFalse((boolean)subFile.exists());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSubFileWithStartingSlash() throws IOException {
        testHandle.subFile("/bla/foo.txt");
    }

    @Test
    public void testMkdirs() throws IOException {
        IVirtualFilesystemService.IVirtualFilesystemHandle subMkdirs = service.of(testDirectory).subDir("parent1").subDir("parent2").subDir("parent3").mkdirs();
        Assert.assertTrue((boolean)subMkdirs.exists());
        service.of(testDirectory).subDir("parent1").delete();
    }

    @Test(expected=IOException.class)
    public void openInputStreamFails() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = testHandle.openInputStream();){
            String string = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
            System.out.println(string);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

