/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.services.ace;

import ch.elexis.core.ac.ACEAccessBitMap;
import ch.elexis.core.ac.AccessControlList;
import ch.elexis.core.ac.AccessControlListUtil;
import ch.elexis.core.model.IOrganization;
import ch.elexis.core.utils.OsgiServiceUtil;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AccessControlListFileTest {
    private static Gson gson;

    @BeforeClass
    public static void beforeClass() {
        gson = (Gson)OsgiServiceUtil.getService(Gson.class).get();
    }

    @Test
    public void deserializeJsonFile() throws IOException {
        AccessControlList aclUser;
        Throwable throwable = null;
        Object var3_3 = null;
        try (InputStream roleAccessDefaultUserFile = AccessControlList.class.getClassLoader().getResourceAsStream("/rsc/acl/user.json");){
            aclUser = (AccessControlList)gson.fromJson((Reader)new InputStreamReader(roleAccessDefaultUserFile), AccessControlList.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.assertEquals((Object)"user", aclUser.getRolesRepresented().iterator().next());
        byte[] bs = ((ACEAccessBitMap)aclUser.getObject().get(IOrganization.class.getName())).getAccessRightMap();
        byte[] byArray = new byte[9];
        byArray[1] = 4;
        byArray[5] = 4;
        Assert.assertArrayEquals((byte[])byArray, (byte[])bs);
        ACEAccessBitMap aceAccessBitMap = (ACEAccessBitMap)aclUser.getSystemCommand().get("ch.elexis.core.ui.login");
        byte[] byArray2 = new byte[9];
        byArray2[4] = 4;
        Assert.assertArrayEquals((byte[])byArray2, (byte[])aceAccessBitMap.getAccessRightMap());
    }

    @Test
    public void deserializeCombineUserAssistant() throws IOException {
        AccessControlList aclMedicalUser;
        AccessControlList aclUser;
        Object roleAccessDefaultUserFile;
        Throwable throwable = null;
        Object var3_3 = null;
        try {
            roleAccessDefaultUserFile = AccessControlList.class.getClassLoader().getResourceAsStream("/rsc/acl/user.json");
            try {
                aclUser = (AccessControlList)gson.fromJson((Reader)new InputStreamReader((InputStream)roleAccessDefaultUserFile), AccessControlList.class);
            }
            finally {
                if (roleAccessDefaultUserFile != null) {
                    ((InputStream)roleAccessDefaultUserFile).close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        byte[] bs = ((ACEAccessBitMap)aclUser.getObject().get("ch.elexis.core.model.IArticle")).getAccessRightMap();
        byte[] byArray = new byte[9];
        byArray[1] = 4;
        byArray[5] = 4;
        Assert.assertArrayEquals((String)Arrays.toString(bs), (byte[])byArray, (byte[])bs);
        bs = ((ACEAccessBitMap)aclUser.getObject().get("ch.elexis.core.model.IContact")).getAccessRightMap();
        byte[] byArray2 = new byte[9];
        byArray2[1] = 4;
        byArray2[5] = 4;
        Assert.assertArrayEquals((String)Arrays.toString(bs), (byte[])byArray2, (byte[])bs);
        roleAccessDefaultUserFile = null;
        Object var5_8 = null;
        try (InputStream roleAccessDefaultAssistantFile = AccessControlList.class.getClassLoader().getResourceAsStream("/rsc/acl/medical-user.json");){
            aclMedicalUser = (AccessControlList)gson.fromJson((Reader)new InputStreamReader(roleAccessDefaultAssistantFile), AccessControlList.class);
        }
        catch (Throwable throwable3) {
            if (roleAccessDefaultUserFile == null) {
                roleAccessDefaultUserFile = throwable3;
            } else if (roleAccessDefaultUserFile != throwable3) {
                ((Throwable)roleAccessDefaultUserFile).addSuppressed(throwable3);
            }
            throw roleAccessDefaultUserFile;
        }
        bs = ((ACEAccessBitMap)aclMedicalUser.getObject().get("ch.elexis.core.model.IArticle")).getAccessRightMap();
        byte[] byArray3 = new byte[9];
        byArray3[0] = 4;
        byArray3[1] = 4;
        byArray3[2] = 4;
        byArray3[3] = 4;
        byArray3[4] = 4;
        byArray3[5] = 4;
        byArray3[6] = 4;
        byArray3[7] = 4;
        Assert.assertArrayEquals((String)Arrays.toString(bs), (byte[])byArray3, (byte[])bs);
        AccessControlList merge = AccessControlListUtil.merge((AccessControlList)aclUser, (AccessControlList)aclMedicalUser);
        AccessControlList revMerge = AccessControlListUtil.merge((AccessControlList)aclMedicalUser, (AccessControlList)aclUser);
        Assert.assertTrue((boolean)merge.getRolesRepresented().contains("user"));
        Assert.assertTrue((boolean)merge.getRolesRepresented().contains("medical-user"));
        bs = ((ACEAccessBitMap)merge.getObject().get("ch.elexis.core.model.IArticle")).getAccessRightMap();
        byte[] byArray4 = new byte[9];
        byArray4[0] = 4;
        byArray4[1] = 4;
        byArray4[2] = 4;
        byArray4[3] = 4;
        byArray4[4] = 4;
        byArray4[5] = 4;
        byArray4[6] = 4;
        byArray4[7] = 4;
        Assert.assertArrayEquals((String)Arrays.toString(bs), (byte[])byArray4, (byte[])bs);
        bs = ((ACEAccessBitMap)revMerge.getObject().get("ch.elexis.core.model.IArticle")).getAccessRightMap();
        byte[] byArray5 = new byte[9];
        byArray5[0] = 4;
        byArray5[1] = 4;
        byArray5[2] = 4;
        byArray5[3] = 4;
        byArray5[4] = 4;
        byArray5[5] = 4;
        byArray5[6] = 4;
        byArray5[7] = 4;
        Assert.assertArrayEquals((String)Arrays.toString(bs), (byte[])byArray5, (byte[])bs);
        bs = ((ACEAccessBitMap)merge.getObject().get("ch.elexis.core.model.IInvoice")).getAccessRightMap();
        byte[] byArray6 = new byte[9];
        byArray6[0] = 1;
        byArray6[1] = 1;
        byArray6[2] = 1;
        byArray6[3] = 1;
        byArray6[4] = 1;
        byArray6[5] = 1;
        Assert.assertArrayEquals((String)Arrays.toString(bs), (byte[])byArray6, (byte[])bs);
        bs = ((ACEAccessBitMap)revMerge.getObject().get("ch.elexis.core.model.IInvoice")).getAccessRightMap();
        byte[] byArray7 = new byte[9];
        byArray7[0] = 1;
        byArray7[1] = 1;
        byArray7[2] = 1;
        byArray7[3] = 1;
        byArray7[4] = 1;
        byArray7[5] = 1;
        Assert.assertArrayEquals((String)Arrays.toString(bs), (byte[])byArray7, (byte[])bs);
        bs = ((ACEAccessBitMap)revMerge.getObject().get("ch.elexis.core.model.IContact")).getAccessRightMap();
        byte[] byArray8 = new byte[9];
        byArray8[0] = 4;
        byArray8[1] = 4;
        byArray8[2] = 4;
        byArray8[3] = 4;
        byArray8[4] = 4;
        byArray8[5] = 4;
        byArray8[6] = 4;
        byArray8[7] = 4;
        Assert.assertArrayEquals((String)Arrays.toString(bs), (byte[])byArray8, (byte[])bs);
    }
}

