/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.jaxrs.filter;

import ch.elexis.core.jaxrs.filter.ContextSettingFilter;
import io.curity.oauth.OAuthJwtFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public abstract class AbstractCombinedOauthJwtContextSettingFilter
implements Filter {
    private static final boolean IS_DISABLE_WEBSEC = Boolean.valueOf(System.getProperty("disable.web.security"));
    private ContextSettingFilter contextSettingFilter;
    private Pattern skipPattern;
    private Filter oAuthJwtFilter;

    public void init(FilterConfig filterConfig) throws ServletException {
        if (IS_DISABLE_WEBSEC) {
            LoggerFactory.getLogger(this.getClass()).error("!!! UNPROTECTED API !!!");
        } else {
            this.initializeOAuthFilter(filterConfig);
            LoggerFactory.getLogger(this.getClass()).debug("Filter initialized");
        }
        this.contextSettingFilter = new ContextSettingFilter(IS_DISABLE_WEBSEC);
        String skipPatternDefinition = filterConfig.getInitParameter("skipPattern");
        if (skipPatternDefinition != null) {
            this.skipPattern = Pattern.compile(skipPatternDefinition, 32);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        if (this.shouldSkip(servletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        if (!IS_DISABLE_WEBSEC) {
            this.oAuthJwtFilter.doFilter((ServletRequest)servletRequest, response, (req, res) -> this.contextSettingFilter.doFilter(req, res, chain));
        } else {
            this.contextSettingFilter.doFilter(request, response, chain);
        }
    }

    private void initializeOAuthFilter(FilterConfig filterConfig) throws ServletException {
        this.oAuthJwtFilter = new OAuthJwtFilter();
        this.oAuthJwtFilter.init((FilterConfig)new EnvironmentVariablesExtendedFilterConfig(filterConfig));
    }

    private boolean shouldSkip(HttpServletRequest request) {
        if (this.skipPattern == null) {
            return false;
        }
        String requestPath = request.getRequestURI().substring(request.getContextPath().length());
        return this.skipPattern.matcher(requestPath).matches();
    }

    private class EnvironmentVariablesExtendedFilterConfig
    implements FilterConfig {
        private final String ENV_PREFIX;
        private FilterConfig filterConfig;

        public EnvironmentVariablesExtendedFilterConfig(FilterConfig filterConfig) {
            this.filterConfig = filterConfig;
            String filterId = filterConfig.getInitParameter("filter-id");
            this.ENV_PREFIX = filterId != null ? "OAUTH_FILTER_" + filterId + "_" : "OAUTH_FILTER_";
        }

        public String getFilterName() {
            return this.filterConfig.getFilterName();
        }

        public String getInitParameter(String name) {
            String initParameter = this.filterConfig.getInitParameter(name);
            if (initParameter == null) {
                initParameter = System.getenv(this.ENV_PREFIX + name);
            }
            return initParameter;
        }

        public Enumeration<String> getInitParameterNames() {
            Enumeration initParameterNames = this.filterConfig.getInitParameterNames();
            List<String> list = System.getenv().keySet().stream().filter(key -> key.startsWith(this.ENV_PREFIX)).map(key -> key.substring(this.ENV_PREFIX.length())).toList();
            ArrayList<String> lt = new ArrayList<String>(list);
            initParameterNames.asIterator().forEachRemaining(lt::add);
            return Collections.enumeration(lt);
        }

        public ServletContext getServletContext() {
            return this.filterConfig.getServletContext();
        }
    }
}

