/*
 * Decompiled with CFR 0.152.
 */
package ch.elexis.core.console;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.framework.console.CommandInterpreter;

public class ConsoleProgressMonitor
implements IProgressMonitor {
    private CommandInterpreter ci;
    private String name;
    private int totalWork;
    private int worked;
    private boolean cancelled;

    public ConsoleProgressMonitor() {
    }

    public ConsoleProgressMonitor(CommandInterpreter ci) {
        this.ci = ci;
    }

    public void beginTask(String name, int totalWork) {
        this.name = name;
        this.totalWork = totalWork == -1 ? 9999 : totalWork;
        this.worked = 0;
        this.cancelled = false;
        this.printStatus();
    }

    private void printStatus() {
        if (this.name == null && this.worked == 0 && this.totalWork == 0) {
            return;
        }
        String msg = this.name + " [" + this.worked + "/" + this.totalWork + "]";
        if (this.cancelled) {
            msg = "-CNCLD- " + msg;
        }
        if (this.ci != null) {
            this.ci.println((Object)msg);
        } else {
            System.out.println(msg);
        }
    }

    public void done() {
        this.worked = this.totalWork;
        this.printStatus();
    }

    public void internalWorked(double work) {
    }

    public boolean isCanceled() {
        return this.cancelled;
    }

    public void setCanceled(boolean value) {
        this.cancelled = value;
        if (value) {
            this.printStatus();
        }
    }

    public void setTaskName(String name) {
        this.name = name;
    }

    public void subTask(String name) {
        this.name = name;
    }

    public void worked(int work) {
        this.worked += work;
        this.printStatus();
    }
}

